/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.spectator.http.internal;

import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Registry;
import io.reactivex.netty.spectator.internal.SpectatorUtils;

public class ResponseCodesHolder {
    private final Counter response5xx;
    private final Counter response4xx;
    private final Counter response3xx;
    private final Counter response2xx;
    private final Counter response1xx;

    public ResponseCodesHolder(Registry registry, String monitorId) {
        this.response1xx = SpectatorUtils.newCounter(registry, "responseCodes", monitorId, "code", "1xx");
        this.response2xx = SpectatorUtils.newCounter(registry, "responseCodes", monitorId, "code", "2xx");
        this.response3xx = SpectatorUtils.newCounter(registry, "responseCodes", monitorId, "code", "3xx");
        this.response4xx = SpectatorUtils.newCounter(registry, "responseCodes", monitorId, "code", "4xx");
        this.response5xx = SpectatorUtils.newCounter(registry, "responseCodes", monitorId, "code", "5xx");
    }

    public void update(int responseCode) {
        int firstDigit = responseCode / 100;
        switch (firstDigit) {
            case 1: {
                this.response1xx.increment();
                break;
            }
            case 2: {
                this.response2xx.increment();
                break;
            }
            case 3: {
                this.response3xx.increment();
                break;
            }
            case 4: {
                this.response4xx.increment();
                break;
            }
            case 5: {
                this.response5xx.increment();
            }
        }
    }

    public long getResponse1xx() {
        return this.response1xx.count();
    }

    public long getResponse2xx() {
        return this.response2xx.count();
    }

    public long getResponse3xx() {
        return this.response3xx.count();
    }

    public long getResponse4xx() {
        return this.response4xx.count();
    }

    public long getResponse5xx() {
        return this.response5xx.count();
    }
}

