/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.spectator.http;

import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Spectator;
import io.reactivex.netty.protocol.http.client.events.HttpClientEventsListener;
import io.reactivex.netty.spectator.http.internal.ResponseCodesHolder;
import io.reactivex.netty.spectator.internal.EventMetric;
import io.reactivex.netty.spectator.tcp.TcpClientListener;
import java.util.concurrent.TimeUnit;

public class HttpClientListener
extends HttpClientEventsListener {
    private final EventMetric requestWrite;
    private final EventMetric requestProcessing;
    private final EventMetric response;
    private final ResponseCodesHolder responseCodesHolder;
    private final TcpClientListener tcpDelegate;

    public HttpClientListener(Registry registry, String monitorId) {
        this.requestWrite = new EventMetric(registry, "request", monitorId, "action", "write");
        this.requestProcessing = new EventMetric(registry, "request", monitorId, "action", "processing");
        this.response = new EventMetric(registry, "response", monitorId, "action", "read");
        this.responseCodesHolder = new ResponseCodesHolder(registry, monitorId);
        this.tcpDelegate = new TcpClientListener(registry, monitorId);
    }

    public HttpClientListener(String monitorId) {
        this(Spectator.globalRegistry(), monitorId);
    }

    @Override
    public void onRequestProcessingComplete(long duration, TimeUnit timeUnit) {
        this.requestProcessing.success(duration, timeUnit);
    }

    @Override
    public void onResponseHeadersReceived(int responseCode, long duration, TimeUnit timeUnit) {
        this.responseCodesHolder.update(responseCode);
    }

    @Override
    public void onResponseReceiveComplete(long duration, TimeUnit timeUnit) {
        this.response.success(duration, timeUnit);
    }

    @Override
    public void onRequestWriteStart() {
        this.requestWrite.start();
    }

    @Override
    public void onResponseFailed(Throwable throwable) {
        this.response.failure();
    }

    @Override
    public void onRequestWriteComplete(long duration, TimeUnit timeUnit) {
        this.requestWrite.success(duration, timeUnit);
    }

    @Override
    public void onRequestWriteFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.requestWrite.failure(duration, timeUnit);
    }

    @Override
    public void onRequestSubmitted() {
        this.requestProcessing.start();
    }

    @Override
    public void onByteRead(long bytesRead) {
        this.tcpDelegate.onByteRead(bytesRead);
    }

    @Override
    public void onByteWritten(long bytesWritten) {
        this.tcpDelegate.onByteWritten(bytesWritten);
    }

    @Override
    public void onFlushComplete(long duration, TimeUnit timeUnit) {
        this.tcpDelegate.onFlushComplete(duration, timeUnit);
    }

    @Override
    public void onFlushStart() {
        this.tcpDelegate.onFlushStart();
    }

    @Override
    public void onWriteFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.tcpDelegate.onWriteFailed(duration, timeUnit, throwable);
    }

    @Override
    public void onWriteSuccess(long duration, TimeUnit timeUnit) {
        this.tcpDelegate.onWriteSuccess(duration, timeUnit);
    }

    @Override
    public void onWriteStart() {
        this.tcpDelegate.onWriteStart();
    }

    @Override
    public void onPoolReleaseFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.tcpDelegate.onPoolReleaseFailed(duration, timeUnit, throwable);
    }

    @Override
    public void onPoolReleaseSuccess(long duration, TimeUnit timeUnit) {
        this.tcpDelegate.onPoolReleaseSuccess(duration, timeUnit);
    }

    @Override
    public void onPoolReleaseStart() {
        this.tcpDelegate.onPoolReleaseStart();
    }

    @Override
    public void onPooledConnectionEviction() {
        this.tcpDelegate.onPooledConnectionEviction();
    }

    @Override
    public void onPooledConnectionReuse() {
        this.tcpDelegate.onPooledConnectionReuse();
    }

    @Override
    public void onPoolAcquireFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.tcpDelegate.onPoolAcquireFailed(duration, timeUnit, throwable);
    }

    @Override
    public void onPoolAcquireSuccess(long duration, TimeUnit timeUnit) {
        this.tcpDelegate.onPoolAcquireSuccess(duration, timeUnit);
    }

    @Override
    public void onPoolAcquireStart() {
        this.tcpDelegate.onPoolAcquireStart();
    }

    @Override
    public void onConnectionCloseFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.tcpDelegate.onConnectionCloseFailed(duration, timeUnit, throwable);
    }

    @Override
    public void onConnectionCloseSuccess(long duration, TimeUnit timeUnit) {
        this.tcpDelegate.onConnectionCloseSuccess(duration, timeUnit);
    }

    @Override
    public void onConnectionCloseStart() {
        this.tcpDelegate.onConnectionCloseStart();
    }

    @Override
    public void onConnectFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.tcpDelegate.onConnectFailed(duration, timeUnit, throwable);
    }

    @Override
    public void onConnectSuccess(long duration, TimeUnit timeUnit) {
        this.tcpDelegate.onConnectSuccess(duration, timeUnit);
    }

    @Override
    public void onConnectStart() {
        this.tcpDelegate.onConnectStart();
    }
}

