/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.tcp.server;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.util.concurrent.EventExecutorGroup;
import io.reactivex.netty.protocol.tcp.server.ConnectionHandler;
import io.reactivex.netty.protocol.tcp.server.TcpServer;
import io.reactivex.netty.protocol.tcp.server.TcpServerConnectionToChannelBridge;
import io.reactivex.netty.protocol.tcp.server.TcpServerState;
import io.reactivex.netty.protocol.tcp.server.events.TcpServerEventListener;
import io.reactivex.netty.protocol.tcp.server.events.TcpServerEventPublisher;
import io.reactivex.netty.server.ServerState;
import io.reactivex.netty.ssl.SslCodec;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Subscription;
import rx.functions.Action1;
import rx.functions.Func0;
import rx.functions.Func1;

public class TcpServerImpl<R, W>
extends TcpServer<R, W> {
    private static final Logger logger = LoggerFactory.getLogger(TcpServerImpl.class);
    private final ServerState<R, W> state;
    private ChannelFuture bindFuture;
    protected final AtomicReference<ServerStatus> serverStateRef;

    public TcpServerImpl(SocketAddress socketAddress) {
        this.state = TcpServerState.create(socketAddress);
        this.serverStateRef = new AtomicReference<ServerStatus>(ServerStatus.Created);
    }

    public TcpServerImpl(SocketAddress socketAddress, EventLoopGroup parent, EventLoopGroup child, Class<? extends ServerChannel> channelClass) {
        this.state = TcpServerState.create(socketAddress, parent, child, channelClass);
        this.serverStateRef = new AtomicReference<ServerStatus>(ServerStatus.Created);
    }

    private TcpServerImpl(ServerState<R, W> state) {
        this.state = state;
        this.serverStateRef = new AtomicReference<ServerStatus>(ServerStatus.Created);
    }

    @Override
    public <T> TcpServer<R, W> channelOption(ChannelOption<T> option, T value) {
        return TcpServerImpl.copy(this.state.channelOption(option, value));
    }

    @Override
    public <T> TcpServer<R, W> clientChannelOption(ChannelOption<T> option, T value) {
        return TcpServerImpl.copy(this.state.clientChannelOption(option, value));
    }

    @Override
    public <RR, WW> TcpServer<RR, WW> addChannelHandlerFirst(String name, Func0<ChannelHandler> handlerFactory) {
        return TcpServerImpl.copy(this.state.addChannelHandlerFirst(name, handlerFactory));
    }

    @Override
    public <RR, WW> TcpServer<RR, WW> addChannelHandlerFirst(EventExecutorGroup group, String name, Func0<ChannelHandler> handlerFactory) {
        return TcpServerImpl.copy(this.state.addChannelHandlerFirst(group, name, handlerFactory));
    }

    @Override
    public <RR, WW> TcpServer<RR, WW> addChannelHandlerLast(String name, Func0<ChannelHandler> handlerFactory) {
        return TcpServerImpl.copy(this.state.addChannelHandlerLast(name, handlerFactory));
    }

    @Override
    public <RR, WW> TcpServer<RR, WW> addChannelHandlerLast(EventExecutorGroup group, String name, Func0<ChannelHandler> handlerFactory) {
        return TcpServerImpl.copy(this.state.addChannelHandlerLast(group, name, handlerFactory));
    }

    @Override
    public <RR, WW> TcpServer<RR, WW> addChannelHandlerBefore(String baseName, String name, Func0<ChannelHandler> handlerFactory) {
        return TcpServerImpl.copy(this.state.addChannelHandlerBefore(baseName, name, handlerFactory));
    }

    @Override
    public <RR, WW> TcpServer<RR, WW> addChannelHandlerBefore(EventExecutorGroup group, String baseName, String name, Func0<ChannelHandler> handlerFactory) {
        return TcpServerImpl.copy(this.state.addChannelHandlerBefore(group, baseName, name, handlerFactory));
    }

    @Override
    public <RR, WW> TcpServer<RR, WW> addChannelHandlerAfter(String baseName, String name, Func0<ChannelHandler> handlerFactory) {
        return TcpServerImpl.copy(this.state.addChannelHandlerAfter(baseName, name, handlerFactory));
    }

    @Override
    public <RR, WW> TcpServer<RR, WW> addChannelHandlerAfter(EventExecutorGroup group, String baseName, String name, Func0<ChannelHandler> handlerFactory) {
        return TcpServerImpl.copy(this.state.addChannelHandlerAfter(group, baseName, name, handlerFactory));
    }

    @Override
    public <RR, WW> TcpServer<RR, WW> pipelineConfigurator(Action1<ChannelPipeline> pipelineConfigurator) {
        return TcpServerImpl.copy(this.state.pipelineConfigurator(pipelineConfigurator));
    }

    @Override
    public TcpServer<R, W> secure(Func1<ByteBufAllocator, SSLEngine> sslEngineFactory) {
        return TcpServerImpl.copy(((TcpServerState)this.state).secure(sslEngineFactory));
    }

    @Override
    public TcpServer<R, W> secure(SSLEngine sslEngine) {
        return TcpServerImpl.copy(((TcpServerState)this.state).secure(sslEngine));
    }

    @Override
    public TcpServer<R, W> secure(SslCodec sslCodec) {
        return TcpServerImpl.copy(((TcpServerState)this.state).secure(sslCodec));
    }

    @Override
    public TcpServer<R, W> unsafeSecure() {
        return TcpServerImpl.copy(((TcpServerState)this.state).unsafeSecure());
    }

    @Override
    @Deprecated
    public TcpServer<R, W> enableWireLogging(LogLevel wireLoggingLevel) {
        return TcpServerImpl.copy(this.state.enableWireLogging(wireLoggingLevel));
    }

    @Override
    public TcpServer<R, W> enableWireLogging(String name, LogLevel wireLoggingLevel) {
        return TcpServerImpl.copy(this.state.enableWireLogging(name, wireLoggingLevel));
    }

    @Override
    public int getServerPort() {
        SocketAddress localAddress = this.getServerAddress();
        if (localAddress instanceof InetSocketAddress) {
            return ((InetSocketAddress)localAddress).getPort();
        }
        return 0;
    }

    @Override
    public SocketAddress getServerAddress() {
        SocketAddress localAddress = null != this.bindFuture && this.bindFuture.isDone() ? this.bindFuture.channel().localAddress() : this.state.getServerAddress();
        return localAddress;
    }

    @Override
    public TcpServer<R, W> start(final ConnectionHandler<R, W> connectionHandler) {
        if (!this.serverStateRef.compareAndSet(ServerStatus.Created, ServerStatus.Starting)) {
            throw new IllegalStateException("Server already started");
        }
        try {
            Action1<ChannelPipeline> handlerFactory = new Action1<ChannelPipeline>(){

                @Override
                public void call(ChannelPipeline pipeline) {
                    TcpServerState tcpState = (TcpServerState)TcpServerImpl.this.state;
                    TcpServerConnectionToChannelBridge.addToPipeline(pipeline, connectionHandler, tcpState.getEventPublisher(), tcpState.isSecure());
                }
            };
            TcpServerState newState = (TcpServerState)this.state.pipelineConfigurator(handlerFactory);
            this.bindFuture = newState.getBootstrap().bind(newState.getServerAddress()).sync();
            if (!this.bindFuture.isSuccess()) {
                throw new RuntimeException(this.bindFuture.cause());
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        this.serverStateRef.set(ServerStatus.Started);
        logger.info("Rx server started at port: " + this.getServerPort());
        return this;
    }

    @Override
    public void shutdown() {
        if (!this.serverStateRef.compareAndSet(ServerStatus.Started, ServerStatus.Shutdown)) {
            throw new IllegalStateException("The server is already shutdown.");
        }
        try {
            this.bindFuture.channel().close().sync();
        }
        catch (InterruptedException e) {
            logger.error("Interrupted while waiting for the server socket to close.", e);
        }
    }

    @Override
    public void awaitShutdown() {
        ServerStatus status = this.serverStateRef.get();
        switch (status) {
            case Created: 
            case Starting: {
                throw new IllegalStateException("Server not started yet.");
            }
            case Started: {
                try {
                    this.bindFuture.channel().closeFuture().await();
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                    logger.error("Interrupted while waiting for the server socket to close.", e);
                }
                break;
            }
        }
    }

    @Override
    public void awaitShutdown(long duration, TimeUnit timeUnit) {
        ServerStatus status = this.serverStateRef.get();
        switch (status) {
            case Created: 
            case Starting: {
                throw new IllegalStateException("Server not started yet.");
            }
            case Started: {
                try {
                    this.bindFuture.channel().closeFuture().await(duration, timeUnit);
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                    logger.error("Interrupted while waiting for the server socket to close.", e);
                }
                break;
            }
        }
    }

    @Override
    public TcpServerEventPublisher getEventPublisher() {
        return ((TcpServerState)this.state).getEventPublisher();
    }

    @Override
    public Subscription subscribe(TcpServerEventListener listener) {
        return ((TcpServerState)this.state).getEventPublisher().subscribe(listener);
    }

    private static <RR, WW> TcpServer<RR, WW> copy(ServerState<RR, WW> newState) {
        return new TcpServerImpl<RR, WW>(newState);
    }

    protected static enum ServerStatus {
        Created,
        Starting,
        Started,
        Shutdown;

    }
}

