/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.tcp.client.internal;

import io.netty.channel.Channel;
import io.reactivex.netty.channel.DetachedChannelPipeline;
import io.reactivex.netty.client.ChannelProvider;
import io.reactivex.netty.client.events.ClientEventListener;
import io.reactivex.netty.events.EventAttributeKeys;
import io.reactivex.netty.events.EventPublisher;
import rx.Observable;
import rx.functions.Func1;

public class TcpChannelProvider
implements ChannelProvider {
    private final DetachedChannelPipeline channelPipeline;
    private final ChannelProvider delegate;
    private final EventPublisher publisher;
    private final ClientEventListener hostEventPublisher;

    public TcpChannelProvider(DetachedChannelPipeline channelPipeline, ChannelProvider delegate, EventPublisher publisher, ClientEventListener hostEventPublisher) {
        this.channelPipeline = channelPipeline;
        this.delegate = delegate;
        this.publisher = publisher;
        this.hostEventPublisher = hostEventPublisher;
    }

    @Override
    public Observable<Channel> newChannel(Observable<Channel> input) {
        return this.delegate.newChannel(input).map(new Func1<Channel, Channel>(){

            @Override
            public Channel call(Channel channel) {
                channel.attr(EventAttributeKeys.EVENT_PUBLISHER).set(TcpChannelProvider.this.publisher);
                channel.attr(EventAttributeKeys.CLIENT_EVENT_LISTENER).set(TcpChannelProvider.this.hostEventPublisher);
                channel.attr(EventAttributeKeys.CONNECTION_EVENT_LISTENER).set(TcpChannelProvider.this.hostEventPublisher);
                TcpChannelProvider.this.channelPipeline.addToChannel(channel);
                return channel;
            }
        });
    }
}

