/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.http.client.internal;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.AttributeKey;
import io.reactivex.netty.client.ClientConnectionToChannelBridge;
import io.reactivex.netty.client.pool.PooledConnection;
import io.reactivex.netty.events.Clock;
import io.reactivex.netty.events.EventAttributeKeys;
import io.reactivex.netty.events.EventPublisher;
import io.reactivex.netty.protocol.http.client.events.HttpClientEventsListener;
import io.reactivex.netty.protocol.http.client.internal.HttpChannelProvider;
import io.reactivex.netty.protocol.http.client.internal.HttpClientResponseImpl;
import io.reactivex.netty.protocol.http.internal.AbstractHttpConnectionBridge;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;

public class HttpClientToConnectionBridge<C>
extends AbstractHttpConnectionBridge<C> {
    public static final AttributeKey<Long> KEEP_ALIVE_TIMEOUT_MILLIS_ATTR = PooledConnection.DYNAMIC_CONN_KEEP_ALIVE_TIMEOUT_MS;
    private HttpClientEventsListener eventsListener;
    private EventPublisher eventPublisher;
    private String hostHeader;
    private long requestWriteCompletionTimeNanos;

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.eventsListener = ctx.channel().attr(HttpChannelProvider.HTTP_CLIENT_EVENT_LISTENER).get();
        this.eventPublisher = ctx.channel().attr(EventAttributeKeys.EVENT_PUBLISHER).get();
        super.handlerAdded(ctx);
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        SocketAddress remoteAddr = ctx.channel().remoteAddress();
        if (remoteAddr instanceof InetSocketAddress) {
            InetSocketAddress inetSock = (InetSocketAddress)remoteAddr;
            String hostString = inetSock.getHostString();
            this.hostHeader = hostString + ':' + inetSock.getPort();
        }
        super.channelActive(ctx);
    }

    @Override
    protected void beforeOutboundHeaderWrite(HttpMessage httpMsg, ChannelPromise promise, long startTimeNanos) {
        this.requestWriteCompletionTimeNanos = -1L;
        if (null != this.hostHeader && !httpMsg.headers().contains(HttpHeaderNames.HOST)) {
            httpMsg.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)this.hostHeader);
        }
        if (this.eventPublisher.publishingEnabled()) {
            this.eventsListener.onRequestWriteStart();
        }
    }

    @Override
    protected void onOutboundLastContentWrite(LastHttpContent msg, ChannelPromise promise, final long headerWriteStartTimeNanos) {
        if (this.eventPublisher.publishingEnabled()) {
            promise.addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture future) throws Exception {
                    if (HttpClientToConnectionBridge.this.eventPublisher.publishingEnabled()) {
                        HttpClientToConnectionBridge.this.requestWriteCompletionTimeNanos = Clock.newStartTimeNanos();
                        if (future.isSuccess()) {
                            HttpClientToConnectionBridge.this.eventsListener.onRequestWriteComplete(Clock.onEndNanos(headerWriteStartTimeNanos), TimeUnit.NANOSECONDS);
                        } else {
                            HttpClientToConnectionBridge.this.eventsListener.onRequestWriteFailed(Clock.onEndNanos(headerWriteStartTimeNanos), TimeUnit.NANOSECONDS, future.cause());
                        }
                    }
                }
            });
        }
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof ClientConnectionToChannelBridge.ConnectionReuseEvent) {
            this.resetSubscriptionState(this.connectionInputSubscriber);
            this.connectionInputSubscriber = null;
        } else if (ClientConnectionToChannelBridge.PooledConnectionReleaseEvent.INSTANCE == evt) {
            this.onPooledConnectionRelease(this.connectionInputSubscriber);
        }
        super.userEventTriggered(ctx, evt);
    }

    @Override
    protected void onClosedBeforeReceiveComplete(Channel channel) {
        if (channel.isActive()) {
            channel.attr(ClientConnectionToChannelBridge.DISCARD_CONNECTION).set(true);
        }
    }

    @Override
    protected boolean isInboundHeader(Object nextItem) {
        return nextItem instanceof HttpResponse;
    }

    @Override
    protected boolean isOutboundHeader(Object nextItem) {
        return nextItem instanceof HttpRequest;
    }

    @Override
    protected Object newHttpObject(Object nextItem, Channel channel) {
        HttpClientResponseImpl rxResponse;
        Long keepAliveTimeoutSeconds;
        HttpResponse nettyResponse = (HttpResponse)nextItem;
        if (this.eventPublisher.publishingEnabled()) {
            long duration = -1L;
            if (this.requestWriteCompletionTimeNanos != -1L) {
                duration = Clock.onEndNanos(this.requestWriteCompletionTimeNanos);
            }
            this.eventsListener.onResponseHeadersReceived(nettyResponse.status().code(), duration, TimeUnit.NANOSECONDS);
        }
        if (null != (keepAliveTimeoutSeconds = (rxResponse = HttpClientResponseImpl.unsafeCreate(nettyResponse)).getKeepAliveTimeoutSeconds())) {
            channel.attr(KEEP_ALIVE_TIMEOUT_MILLIS_ATTR).set(keepAliveTimeoutSeconds * 1000L);
        }
        if (!rxResponse.isKeepAlive()) {
            channel.attr(ClientConnectionToChannelBridge.DISCARD_CONNECTION).set(true);
        }
        return rxResponse;
    }

    @Override
    protected void onContentReceived() {
        if (this.eventPublisher.publishingEnabled()) {
            this.eventsListener.onResponseContentReceived();
        }
    }

    @Override
    protected void onContentReceiveComplete(long receiveStartTimeNanos) {
        this.connectionInputSubscriber.onCompleted();
        if (this.eventPublisher.publishingEnabled()) {
            long headerWriteStart = this.getHeaderWriteStartTimeNanos();
            this.eventsListener.onResponseReceiveComplete(Clock.onEndNanos(receiveStartTimeNanos), TimeUnit.NANOSECONDS);
            this.eventsListener.onRequestProcessingComplete(Clock.onEndNanos(headerWriteStart), TimeUnit.NANOSECONDS);
        }
    }

    private void onPooledConnectionRelease(AbstractHttpConnectionBridge.ConnectionInputSubscriber connectionInputSubscriber) {
        this.onChannelClose(connectionInputSubscriber);
    }
}

