/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.events;

import io.reactivex.netty.events.EventListener;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ListenerInvocationException
extends RuntimeException {
    private Map<EventListener, Throwable> exceptions = new HashMap<EventListener, Throwable>();
    private String message = super.getMessage();
    private static final long serialVersionUID = -4381062024201397997L;

    protected ListenerInvocationException() {
        super("Metric event listener invocation failed.");
    }

    protected void addException(EventListener listener, Throwable error) {
        this.exceptions.put(listener, error);
    }

    protected void finish() {
        this.exceptions = Collections.unmodifiableMap(this.exceptions);
        StringBuilder msgBuilder = new StringBuilder(this.getMessage()).append(". Errors: \n");
        for (Map.Entry<EventListener, Throwable> exceptionEntry : this.exceptions.entrySet()) {
            msgBuilder.append("Listener: ");
            msgBuilder.append(exceptionEntry.getKey().getClass().getSimpleName());
            msgBuilder.append("\n Error:");
            ByteArrayOutputStream stackTraceStream = new ByteArrayOutputStream();
            exceptionEntry.getValue().printStackTrace(new PrintStream(stackTraceStream));
            msgBuilder.append(stackTraceStream.toString());
        }
        this.message = msgBuilder.toString();
    }

    public Map<EventListener, Throwable> getExceptions() {
        return this.exceptions;
    }

    @Override
    public String getMessage() {
        return this.message;
    }
}

