/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.client.loadbalancer;

import io.reactivex.netty.client.loadbalancer.HostCollector;
import io.reactivex.netty.client.loadbalancer.HostHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import rx.Single;
import rx.functions.Func1;

public class NoBufferHostCollector
implements HostCollector {
    private final boolean allowDuplicates;

    public NoBufferHostCollector() {
        this(false);
    }

    public NoBufferHostCollector(boolean allowDuplicates) {
        this.allowDuplicates = allowDuplicates;
    }

    @Override
    public <W, R> Func1<HostCollector.HostUpdate<W, R>, Single<List<HostHolder<W, R>>>> newCollector() {
        return new Func1<HostCollector.HostUpdate<W, R>, Single<List<HostHolder<W, R>>>>(){
            private volatile List<HostHolder<W, R>> currentList = Collections.emptyList();

            @Override
            public Single<List<HostHolder<W, R>>> call(HostCollector.HostUpdate<W, R> update) {
                ArrayList newList = null;
                switch (update.getAction()) {
                    case Add: {
                        if (!NoBufferHostCollector.this.allowDuplicates && this.currentList.contains(update.getHostHolder())) break;
                        newList = new ArrayList(this.currentList);
                        newList.add(update.getHostHolder());
                        break;
                    }
                    case Remove: {
                        newList = new ArrayList(this.currentList);
                        newList.remove(update.getHostHolder());
                    }
                }
                if (null != newList) {
                    this.currentList = newList;
                }
                return Single.just(this.currentList);
            }
        };
    }
}

