/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.channel;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.EventExecutorGroup;
import io.reactivex.netty.channel.AllocatingTransformer;
import io.reactivex.netty.channel.ChannelOperations;
import io.reactivex.netty.channel.ConnectionInputSubscriberEvent;
import io.reactivex.netty.channel.ContentSource;
import io.reactivex.netty.channel.MarkAwarePipeline;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Action1;
import rx.functions.Func1;

public abstract class Connection<R, W>
implements ChannelOperations<W> {
    public static final AttributeKey<Connection> CONNECTION_ATTRIBUTE_KEY = AttributeKey.valueOf("rx-netty-conn-attr");
    private final Channel nettyChannel;
    private final ContentSource<R> contentSource;
    protected final MarkAwarePipeline markAwarePipeline;

    protected Connection(Channel nettyChannel) {
        if (null == nettyChannel) {
            throw new IllegalArgumentException("Channel can not be null");
        }
        this.nettyChannel = nettyChannel;
        this.markAwarePipeline = new MarkAwarePipeline(nettyChannel.pipeline());
        this.contentSource = new ContentSource(nettyChannel, new Func1<Subscriber<? super R>, Object>(){

            @Override
            public Object call(Subscriber<? super R> subscriber) {
                return new ConnectionInputSubscriberEvent(subscriber);
            }
        });
    }

    protected Connection(Connection<R, W> toCopy) {
        this.nettyChannel = toCopy.nettyChannel;
        this.markAwarePipeline = toCopy.markAwarePipeline;
        this.contentSource = toCopy.contentSource;
    }

    protected Connection(Connection<?, ?> toCopy, ContentSource<R> contentSource) {
        this.nettyChannel = toCopy.nettyChannel;
        this.markAwarePipeline = toCopy.markAwarePipeline;
        this.contentSource = contentSource;
    }

    public ContentSource<R> getInput() {
        return this.contentSource;
    }

    public Observable<Void> ignoreInput() {
        return this.getInput().map(new Func1<R, Void>(){

            @Override
            public Void call(R r) {
                ReferenceCountUtil.release(r);
                return null;
            }
        }).ignoreElements();
    }

    public abstract <RR, WW> Connection<RR, WW> addChannelHandlerFirst(String var1, ChannelHandler var2);

    public abstract <RR, WW> Connection<RR, WW> addChannelHandlerFirst(EventExecutorGroup var1, String var2, ChannelHandler var3);

    public abstract <RR, WW> Connection<RR, WW> addChannelHandlerLast(String var1, ChannelHandler var2);

    public abstract <RR, WW> Connection<RR, WW> addChannelHandlerLast(EventExecutorGroup var1, String var2, ChannelHandler var3);

    public abstract <RR, WW> Connection<RR, WW> addChannelHandlerBefore(String var1, String var2, ChannelHandler var3);

    public abstract <RR, WW> Connection<RR, WW> addChannelHandlerBefore(EventExecutorGroup var1, String var2, String var3, ChannelHandler var4);

    public abstract <RR, WW> Connection<RR, WW> addChannelHandlerAfter(String var1, String var2, ChannelHandler var3);

    public abstract <RR, WW> Connection<RR, WW> addChannelHandlerAfter(EventExecutorGroup var1, String var2, String var3, ChannelHandler var4);

    public abstract <RR, WW> Connection<RR, WW> pipelineConfigurator(Action1<ChannelPipeline> var1);

    public abstract <RR> Connection<RR, W> transformRead(Observable.Transformer<R, RR> var1);

    public abstract <WW> Connection<R, WW> transformWrite(AllocatingTransformer<WW, W> var1);

    public MarkAwarePipeline getResettableChannelPipeline() {
        return this.markAwarePipeline;
    }

    public ChannelPipeline getChannelPipeline() {
        return this.nettyChannel.pipeline();
    }

    public Channel unsafeNettyChannel() {
        return this.nettyChannel;
    }

    protected void connectCloseToChannelClose() {
        this.nettyChannel.closeFuture().addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                Connection.this.close(false);
            }
        });
        this.nettyChannel.attr(CONNECTION_ATTRIBUTE_KEY).set(this);
    }
}

