/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.http.websocket;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.WebSocketFrameAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketFrameDecoder;
import io.netty.handler.codec.http.websocketx.WebSocketFrameEncoder;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.util.CharsetUtil;
import io.reactivex.netty.metrics.MetricEventsSubject;
import io.reactivex.netty.protocol.http.websocket.WebSocketServerMetricsEvent;
import io.reactivex.netty.protocol.http.websocket.WebSocketServerMetricsHandlers;
import io.reactivex.netty.server.ServerMetricsEvent;

public class WebSocketServerHandler
extends SimpleChannelInboundHandler<Object> {
    private final WebSocketServerHandshakerFactory handshakeHandlerFactory;
    private ChannelPromise handshakeFuture;
    private final int maxFramePayloadLength;
    private final boolean messageAggregator;
    private final MetricEventsSubject<ServerMetricsEvent<?>> eventsSubject;

    public WebSocketServerHandler(WebSocketServerHandshakerFactory handshakeHandlerFactory, int maxFramePayloadLength, boolean messageAggregator, MetricEventsSubject<ServerMetricsEvent<?>> eventsSubject) {
        this.handshakeHandlerFactory = handshakeHandlerFactory;
        this.maxFramePayloadLength = maxFramePayloadLength;
        this.messageAggregator = messageAggregator;
        this.eventsSubject = eventsSubject;
    }

    public void addHandshakeFinishedListener(ChannelFutureListener listener) {
        this.handshakeFuture.addListener(listener);
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) {
        this.handshakeFuture = ctx.newPromise();
    }

    @Override
    public void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof FullHttpRequest) {
            ChannelFuture upgradeFuture = this.handleHttpRequest(ctx, (FullHttpRequest)msg);
            if (upgradeFuture != null) {
                this.updatePipeline(ctx);
                upgradeFuture.addListener(new ChannelFutureListener(){

                    @Override
                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (future.isSuccess()) {
                            WebSocketServerHandler.this.handshakeFuture.setSuccess();
                            WebSocketServerHandler.this.eventsSubject.onEvent(WebSocketServerMetricsEvent.HANDSHAKE_PROCESSED);
                        } else {
                            WebSocketServerHandler.this.handshakeFuture.setFailure(future.cause());
                            WebSocketServerHandler.this.eventsSubject.onEvent(WebSocketServerMetricsEvent.HANDSHAKE_FAILURE);
                        }
                    }
                });
            }
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    private void updatePipeline(ChannelHandlerContext ctx) {
        ChannelPipeline p = ctx.pipeline();
        ChannelHandlerContext nettyEncoderCtx = p.context(WebSocketFrameEncoder.class);
        p.addAfter(nettyEncoderCtx.name(), "websocket-write-metrics", new WebSocketServerMetricsHandlers.ServerWriteMetricsHandler(this.eventsSubject));
        ChannelHandlerContext nettyDecoderCtx = p.context(WebSocketFrameDecoder.class);
        p.addAfter(nettyDecoderCtx.name(), "websocket-read-metrics", new WebSocketServerMetricsHandlers.ServerReadMetricsHandler(this.eventsSubject));
        if (this.messageAggregator) {
            p.addAfter("websocket-read-metrics", "websocket-frame-aggregator", new WebSocketFrameAggregator(this.maxFramePayloadLength));
        }
        p.remove(this);
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    private ChannelFuture handleHttpRequest(ChannelHandlerContext ctx, FullHttpRequest req) {
        if (!req.getDecoderResult().isSuccess()) {
            WebSocketServerHandler.sendHttpResponse(ctx, req, new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST));
            this.eventsSubject.onEvent(WebSocketServerMetricsEvent.HANDSHAKE_FAILURE);
            return null;
        }
        if (req.getMethod() != HttpMethod.GET) {
            WebSocketServerHandler.sendHttpResponse(ctx, req, new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FORBIDDEN));
            this.eventsSubject.onEvent(WebSocketServerMetricsEvent.HANDSHAKE_FAILURE);
            return null;
        }
        WebSocketServerHandshaker handshaker = this.handshakeHandlerFactory.newHandshaker(req);
        if (handshaker == null) {
            WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse(ctx.channel());
            return null;
        }
        return handshaker.handshake(ctx.channel(), req);
    }

    private static void sendHttpResponse(ChannelHandlerContext ctx, FullHttpRequest req, FullHttpResponse res) {
        if (res.getStatus().code() != 200) {
            ByteBuf buf = Unpooled.copiedBuffer(res.getStatus().toString(), CharsetUtil.UTF_8);
            res.content().writeBytes(buf);
            buf.release();
            HttpHeaders.setContentLength(res, res.content().readableBytes());
        }
        ChannelFuture f = ctx.channel().writeAndFlush(res);
        if (!HttpHeaders.isKeepAlive(req) || res.getStatus().code() != 200) {
            f.addListener(ChannelFutureListener.CLOSE);
        }
    }
}

