/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.http.client;

import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.reactivex.netty.protocol.http.client.HttpClient;
import io.reactivex.netty.protocol.http.client.HttpClientRequest;
import io.reactivex.netty.protocol.http.client.HttpClientResponse;
import io.reactivex.netty.protocol.http.client.HttpRedirectException;
import io.reactivex.netty.protocol.http.client.RedirectOperator;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public class DefaultRedirectHandler<I, O>
implements RedirectOperator.RedirectHandler<I, O> {
    private static final Logger logger = LoggerFactory.getLogger(DefaultRedirectHandler.class);
    private static final int[] REDIRECTABLE_STATUS_CODES = new int[]{301, 302, 303, 307, 308};
    private final int maxHops;
    private final HttpClient<I, O> client;

    public DefaultRedirectHandler(int maxHops, HttpClient<I, O> client) {
        this.maxHops = maxHops;
        this.client = client;
    }

    @Override
    public Observable<HttpClientResponse<O>> doRedirect(RedirectOperator.RedirectHandler.RedirectionContext context, HttpClientRequest<I> originalRequest, HttpClient.HttpClientConfig config) {
        URI nextRedirect = context.getNextRedirect();
        if (logger.isDebugEnabled()) {
            logger.debug("Following redirect to location: " + nextRedirect + ". Redirect count: " + context.getRedirectCount());
        }
        HttpClientRequest<I> redirectRequest = this.createRedirectRequest(originalRequest, nextRedirect, context.getLastRedirectStatus().code());
        return this.redirect(redirectRequest, config);
    }

    protected Observable<HttpClientResponse<O>> redirect(HttpClientRequest<I> redirectRequest, HttpClient.HttpClientConfig config) {
        return this.client.submit(redirectRequest, config);
    }

    @Override
    public boolean requiresRedirect(RedirectOperator.RedirectHandler.RedirectionContext context, HttpClientResponse<O> response) {
        int statusCode = response.getStatus().code();
        if (Arrays.binarySearch(REDIRECTABLE_STATUS_CODES, statusCode) >= 0) {
            String location = this.extractRedirectLocation(response);
            return !location.startsWith("http");
        }
        return false;
    }

    @Override
    public void validate(RedirectOperator.RedirectHandler.RedirectionContext context, HttpClientResponse<O> redirectResponse) {
        URI redirectUri;
        String location = this.extractRedirectLocation(redirectResponse);
        if (location == null) {
            throw new HttpRedirectException(HttpRedirectException.Reason.InvalidRedirect, "No redirect location found.");
        }
        if (context.getVisitedLocations().contains(location)) {
            throw new HttpRedirectException(HttpRedirectException.Reason.RedirectLoop, "Redirection contains a loop. Last requested location: " + location);
        }
        if (context.getRedirectCount() >= this.maxHops) {
            throw new HttpRedirectException(HttpRedirectException.Reason.TooManyRedirects, "Too many redirects. Max redirects: " + this.maxHops);
        }
        try {
            redirectUri = new URI(location);
        }
        catch (Exception e) {
            throw new HttpRedirectException(HttpRedirectException.Reason.InvalidRedirect, "Location is not a valid URI. Provided location: " + location, e);
        }
        context.setNextRedirect(redirectUri);
    }

    protected String extractRedirectLocation(HttpClientResponse<O> redirectedResponse) {
        return redirectedResponse.getHeaders().get("Location");
    }

    protected HttpClientRequest<I> createRedirectRequest(HttpClientRequest<I> original, URI redirectLocation, int redirectStatus) {
        HttpRequest nettyRequest = original.getNettyRequest();
        nettyRequest.setUri(DefaultRedirectHandler.getNettyRequestUri(redirectLocation, original.getUri(), redirectStatus));
        HttpClientRequest<I> newRequest = new HttpClientRequest<I>(nettyRequest, original);
        if (redirectStatus == 303) {
            nettyRequest.setMethod(HttpMethod.GET);
            newRequest.removeContent();
        }
        return newRequest;
    }

    protected static String getNettyRequestUri(URI uri, String originalUriString, int redirectStatus) {
        StringBuilder sb = new StringBuilder();
        if (uri.getRawPath() != null) {
            sb.append(uri.getRawPath());
        }
        if (uri.getRawQuery() != null) {
            sb.append('?').append(uri.getRawQuery());
        }
        if (uri.getRawFragment() != null) {
            sb.append('#').append(uri.getRawFragment());
        } else if (redirectStatus >= 300) {
            try {
                URI originalUri = new URI(originalUriString);
                if (originalUri.getRawFragment() != null) {
                    sb.append('#').append(originalUri.getRawFragment());
                }
            }
            catch (URISyntaxException e) {
                logger.warn("Error parsing original request URI during redirect. This means that the path fragment if any in the original request will not be inherited by the redirect.", e);
            }
        }
        return sb.toString();
    }

    static {
        Arrays.sort(REDIRECTABLE_STATUS_CODES);
    }
}

