/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.socket.DatagramPacket;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.logging.LogLevel;
import io.reactivex.netty.channel.ConnectionHandler;
import io.reactivex.netty.channel.ContentTransformer;
import io.reactivex.netty.channel.RxEventLoopProvider;
import io.reactivex.netty.channel.SingleNioLoopProvider;
import io.reactivex.netty.client.ClientBuilder;
import io.reactivex.netty.client.RxClient;
import io.reactivex.netty.metrics.MetricEventsListenerFactory;
import io.reactivex.netty.pipeline.PipelineConfigurator;
import io.reactivex.netty.protocol.http.client.CompositeHttpClient;
import io.reactivex.netty.protocol.http.client.CompositeHttpClientBuilder;
import io.reactivex.netty.protocol.http.client.HttpClient;
import io.reactivex.netty.protocol.http.client.HttpClientBuilder;
import io.reactivex.netty.protocol.http.client.HttpClientRequest;
import io.reactivex.netty.protocol.http.client.HttpClientResponse;
import io.reactivex.netty.protocol.http.server.HttpServer;
import io.reactivex.netty.protocol.http.server.HttpServerBuilder;
import io.reactivex.netty.protocol.http.server.HttpServerRequest;
import io.reactivex.netty.protocol.http.server.HttpServerResponse;
import io.reactivex.netty.protocol.http.server.RequestHandler;
import io.reactivex.netty.protocol.http.websocket.WebSocketClientBuilder;
import io.reactivex.netty.protocol.http.websocket.WebSocketServerBuilder;
import io.reactivex.netty.protocol.udp.client.UdpClientBuilder;
import io.reactivex.netty.protocol.udp.server.UdpServer;
import io.reactivex.netty.protocol.udp.server.UdpServerBuilder;
import io.reactivex.netty.server.RxServer;
import io.reactivex.netty.server.ServerBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import rx.Observable;

public final class RxNetty {
    private static volatile RxEventLoopProvider rxEventLoopProvider = new SingleNioLoopProvider(1, Runtime.getRuntime().availableProcessors());
    private static final CompositeHttpClient<ByteBuf, ByteBuf> globalClient = (CompositeHttpClient)new CompositeHttpClientBuilder().withMaxConnections(1000).build();
    private static MetricEventsListenerFactory metricEventsListenerFactory;
    private static volatile boolean usingNativeTransport;

    private RxNetty() {
    }

    public static <I, O> UdpServerBuilder<I, O> newUdpServerBuilder(int port, ConnectionHandler<I, O> connectionHandler) {
        UdpServerBuilder builder = (UdpServerBuilder)new UdpServerBuilder<I, O>(port, connectionHandler).enableWireLogging(LogLevel.DEBUG);
        if (null != metricEventsListenerFactory) {
            builder.withMetricEventsListenerFactory(metricEventsListenerFactory);
        }
        return builder;
    }

    public static <I, O> UdpClientBuilder<I, O> newUdpClientBuilder(String host, int port) {
        UdpClientBuilder builder = (UdpClientBuilder)((UdpClientBuilder)((UdpClientBuilder)new UdpClientBuilder(host, port).channel(NioDatagramChannel.class)).enableWireLogging(LogLevel.DEBUG)).eventloop(RxNetty.getRxEventLoopProvider().globalClientEventLoop());
        if (null != metricEventsListenerFactory) {
            builder.withMetricEventsListenerFactory(metricEventsListenerFactory);
        }
        return builder;
    }

    public static <I, O> UdpServer<I, O> createUdpServer(int port, PipelineConfigurator<I, O> pipelineConfigurator, ConnectionHandler<I, O> connectionHandler) {
        return (UdpServer)((UdpServerBuilder)RxNetty.newUdpServerBuilder(port, connectionHandler).pipelineConfigurator(pipelineConfigurator)).build();
    }

    public static <I, O> RxClient<I, O> createUdpClient(String host, int port, PipelineConfigurator<O, I> pipelineConfigurator) {
        return ((UdpClientBuilder)RxNetty.newUdpClientBuilder(host, port).pipelineConfigurator(pipelineConfigurator)).build();
    }

    public static UdpServer<DatagramPacket, DatagramPacket> createUdpServer(int port, ConnectionHandler<DatagramPacket, DatagramPacket> connectionHandler) {
        return (UdpServer)new UdpServerBuilder<DatagramPacket, DatagramPacket>(port, connectionHandler).build();
    }

    public static RxClient<DatagramPacket, DatagramPacket> createUdpClient(String host, int port) {
        return RxNetty.newUdpClientBuilder(host, port).build();
    }

    public static <I, O> ServerBuilder<I, O> newTcpServerBuilder(int port, ConnectionHandler<I, O> connectionHandler) {
        ServerBuilder builder = (ServerBuilder)new ServerBuilder<I, O>(port, connectionHandler).enableWireLogging(LogLevel.DEBUG);
        if (null != metricEventsListenerFactory) {
            builder.withMetricEventsListenerFactory(metricEventsListenerFactory);
        }
        return builder;
    }

    public static <I, O> RxServer<I, O> createTcpServer(int port, PipelineConfigurator<I, O> pipelineConfigurator, ConnectionHandler<I, O> connectionHandler) {
        return (RxServer)((ServerBuilder)RxNetty.newTcpServerBuilder(port, connectionHandler).pipelineConfigurator(pipelineConfigurator)).build();
    }

    public static <I, O> ClientBuilder<I, O> newTcpClientBuilder(String host, int port) {
        ClientBuilder builder = (ClientBuilder)new ClientBuilder(host, port).enableWireLogging(LogLevel.DEBUG);
        if (null != metricEventsListenerFactory) {
            builder.withMetricEventsListenerFactory(metricEventsListenerFactory);
        }
        return builder;
    }

    public static <I, O> RxClient<I, O> createTcpClient(String host, int port, PipelineConfigurator<O, I> configurator) {
        return ((ClientBuilder)RxNetty.newTcpClientBuilder(host, port).pipelineConfigurator(configurator)).build();
    }

    public static RxServer<ByteBuf, ByteBuf> createTcpServer(int port, ConnectionHandler<ByteBuf, ByteBuf> connectionHandler) {
        return (RxServer)new ServerBuilder<ByteBuf, ByteBuf>(port, connectionHandler).build();
    }

    public static RxClient<ByteBuf, ByteBuf> createTcpClient(String host, int port) {
        return RxNetty.newTcpClientBuilder(host, port).build();
    }

    public static <I, O> HttpServerBuilder<I, O> newHttpServerBuilder(int port, RequestHandler<I, O> requestHandler) {
        HttpServerBuilder builder = (HttpServerBuilder)new HttpServerBuilder<I, O>(port, requestHandler).enableWireLogging(LogLevel.DEBUG);
        if (null != metricEventsListenerFactory) {
            builder.withMetricEventsListenerFactory(metricEventsListenerFactory);
        }
        return builder;
    }

    public static <I, O> HttpClientBuilder<I, O> newHttpClientBuilder(String host, int port) {
        HttpClientBuilder builder = (HttpClientBuilder)((HttpClientBuilder)new HttpClientBuilder(host, port).withMaxConnections(1000)).enableWireLogging(LogLevel.DEBUG);
        if (null != metricEventsListenerFactory) {
            builder.withMetricEventsListenerFactory(metricEventsListenerFactory);
        }
        return builder;
    }

    public static HttpServer<ByteBuf, ByteBuf> createHttpServer(int port, RequestHandler<ByteBuf, ByteBuf> requestHandler) {
        return RxNetty.newHttpServerBuilder(port, requestHandler).build();
    }

    public static HttpClient<ByteBuf, ByteBuf> createHttpClient(String host, int port) {
        return (HttpClient)RxNetty.newHttpClientBuilder(host, port).build();
    }

    public static <I, O> HttpServer<I, O> createHttpServer(int port, RequestHandler<I, O> requestHandler, PipelineConfigurator<HttpServerRequest<I>, HttpServerResponse<O>> configurator) {
        return ((HttpServerBuilder)RxNetty.newHttpServerBuilder(port, requestHandler).pipelineConfigurator(configurator)).build();
    }

    public static <I, O> HttpClient<I, O> createHttpClient(String host, int port, PipelineConfigurator<HttpClientResponse<O>, HttpClientRequest<I>> configurator) {
        return (HttpClient)((HttpClientBuilder)RxNetty.newHttpClientBuilder(host, port).pipelineConfigurator(configurator)).build();
    }

    public static Observable<HttpClientResponse<ByteBuf>> createHttpRequest(HttpClientRequest<ByteBuf> request) {
        RxClient.ServerInfo serverInfo;
        try {
            serverInfo = RxNetty.getServerInfoFromRequest(request);
        }
        catch (URISyntaxException e) {
            return Observable.error(e);
        }
        return globalClient.submit(serverInfo, request);
    }

    public static Observable<HttpClientResponse<ByteBuf>> createHttpRequest(HttpClientRequest<ByteBuf> request, HttpClient.HttpClientConfig config) {
        RxClient.ServerInfo serverInfo;
        try {
            serverInfo = RxNetty.getServerInfoFromRequest(request);
        }
        catch (URISyntaxException e) {
            return Observable.error(e);
        }
        return globalClient.submit(serverInfo, request, config);
    }

    public static Observable<HttpClientResponse<ByteBuf>> createHttpGet(String uri) {
        return RxNetty.createHttpRequest(HttpClientRequest.createGet(uri));
    }

    public static Observable<HttpClientResponse<ByteBuf>> createHttpPost(String uri, Observable<ByteBuf> content) {
        return RxNetty.createHttpRequest(HttpClientRequest.createPost(uri).withContentSource(content));
    }

    public static Observable<HttpClientResponse<ByteBuf>> createHttpPut(String uri, Observable<ByteBuf> content) {
        return RxNetty.createHttpRequest(HttpClientRequest.createPut(uri).withContentSource(content));
    }

    public static <T> Observable<HttpClientResponse<ByteBuf>> createHttpPost(String uri, Observable<T> content, ContentTransformer<T> transformer) {
        return RxNetty.createHttpRequest(HttpClientRequest.createPost(uri).withRawContentSource(content, transformer));
    }

    public static <T> Observable<HttpClientResponse<ByteBuf>> createHttpPut(String uri, Observable<T> content, ContentTransformer<T> transformer) {
        return RxNetty.createHttpRequest(HttpClientRequest.createPut(uri).withRawContentSource(content, transformer));
    }

    public static Observable<HttpClientResponse<ByteBuf>> createHttpDelete(String uri) {
        return RxNetty.createHttpRequest(HttpClientRequest.createDelete(uri));
    }

    public static <I extends WebSocketFrame, O extends WebSocketFrame> WebSocketClientBuilder<I, O> newWebSocketClientBuilder(String host, int port) {
        return (WebSocketClientBuilder)new WebSocketClientBuilder(host, port).enableWireLogging(LogLevel.DEBUG);
    }

    public static <I extends WebSocketFrame, O extends WebSocketFrame> WebSocketServerBuilder<I, O> newWebSocketServerBuilder(int port, ConnectionHandler<I, O> connectionHandler) {
        return (WebSocketServerBuilder)new WebSocketServerBuilder<I, O>(port, connectionHandler).enableWireLogging(LogLevel.DEBUG);
    }

    public static RxEventLoopProvider useEventLoopProvider(RxEventLoopProvider provider) {
        RxEventLoopProvider oldProvider = rxEventLoopProvider;
        rxEventLoopProvider = provider;
        return oldProvider;
    }

    public static void useMetricListenersFactory(MetricEventsListenerFactory factory) {
        metricEventsListenerFactory = factory;
    }

    public static RxEventLoopProvider getRxEventLoopProvider() {
        return rxEventLoopProvider;
    }

    public static void useNativeTransportIfApplicable() {
        usingNativeTransport = true;
    }

    public static void disableNativeTransport() {
        usingNativeTransport = false;
    }

    public static boolean isUsingNativeTransport() {
        return usingNativeTransport;
    }

    private static RxClient.ServerInfo getServerInfoFromRequest(HttpClientRequest<ByteBuf> request) throws URISyntaxException {
        URI uri = new URI(request.getUri());
        String host = uri.getHost();
        if (null != host) {
            String scheme;
            int port = uri.getPort();
            if (port < 0 && null != (scheme = uri.getScheme())) {
                if ("http".equals(scheme)) {
                    port = 80;
                } else if ("https".equals(scheme)) {
                    port = 443;
                }
            }
            return new RxClient.ServerInfo(host, port);
        }
        return globalClient.getDefaultServer();
    }
}

