/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.DefaultMaxMessagesRecvByteBufAllocator;
import io.netty.channel.RecvByteBufAllocator;

public class FixedRecvByteBufAllocator
extends DefaultMaxMessagesRecvByteBufAllocator {
    private final RecvByteBufAllocator.Handle handle;

    public FixedRecvByteBufAllocator(int bufferSize) {
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("bufferSize must greater than 0: " + bufferSize);
        }
        this.handle = new HandleImpl(bufferSize);
    }

    @Override
    public RecvByteBufAllocator.Handle newHandle() {
        return this.handle;
    }

    private final class HandleImpl
    extends DefaultMaxMessagesRecvByteBufAllocator.MaxMessageHandle {
        private final int bufferSize;

        public HandleImpl(int bufferSize) {
            super(FixedRecvByteBufAllocator.this);
            this.bufferSize = bufferSize;
        }

        @Override
        public int guess() {
            return this.bufferSize;
        }
    }
}

