/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.UUID;
import org.ton.java.utils.ByteUtils;
import org.ton.java.utils.HashUtils;

public final class TonUtils {
    private static final long BLN1 = 1000000000L;
    private static final BigInteger BI_BLN1 = BigInteger.valueOf(1000000000L);
    private static final BigDecimal BD_BLN1 = BigDecimal.valueOf(1000000000L);

    private TonUtils() {
    }

    public static BigInteger toNano(double toncoins, Integer precision) {
        return BigDecimal.valueOf(toncoins).multiply(BigDecimal.TEN.pow(precision)).toBigInteger();
    }

    public static BigInteger toNano(BigDecimal toncoins, Integer precision) {
        return toncoins.multiply(BigDecimal.TEN.pow(precision)).toBigInteger();
    }

    public static BigInteger toNano(String toncoins, Integer precision) {
        return new BigDecimal(toncoins).multiply(BigDecimal.TEN.pow(precision)).toBigInteger();
    }

    public static BigInteger toNano(long toncoins, Integer precision) {
        return new BigDecimal(toncoins).multiply(BigDecimal.TEN.pow(precision)).toBigInteger();
    }

    public static BigDecimal fromNano(BigInteger nanoCoins, Integer precision) {
        return new BigDecimal(nanoCoins).divide(BigDecimal.TEN.pow(precision), (int)precision, RoundingMode.FLOOR);
    }

    public static BigDecimal fromNano(BigDecimal nanoCoins, Integer precision) {
        return nanoCoins.divide(BigDecimal.TEN.pow(precision), (int)precision, RoundingMode.FLOOR);
    }

    public static BigDecimal fromNano(String nanoCoins, Integer precision) {
        return new BigDecimal(nanoCoins).divide(BigDecimal.TEN.pow(precision), (int)precision, RoundingMode.FLOOR);
    }

    public static BigDecimal fromNano(long nanoCoins, Integer precision) {
        return new BigDecimal(nanoCoins).divide(BigDecimal.TEN.pow(precision), (int)precision, RoundingMode.FLOOR);
    }

    public static BigInteger toNano(long toncoins) {
        BigInteger result = BigInteger.valueOf(toncoins).multiply(BI_BLN1);
        TonUtils.checkToncoinsOverflow(result);
        return result;
    }

    public static BigInteger toNano(String toncoins) {
        BigInteger result = toncoins.matches("^\\d*\\.\\d+|\\d+\\.\\d*$") ? new BigDecimal(toncoins).multiply(BigDecimal.valueOf(1000000000L)).toBigInteger() : new BigInteger(toncoins).multiply(BigInteger.valueOf(1000000000L));
        TonUtils.checkToncoinsOverflow(result);
        return result;
    }

    public static BigInteger toNano(double toncoins) {
        if (BigDecimal.valueOf(toncoins).scale() > 9) {
            throw new Error("Round the number to 9 decimals first");
        }
        BigInteger result = BigDecimal.valueOf(toncoins).multiply(BigDecimal.valueOf(1000000000L)).toBigInteger();
        TonUtils.checkToncoinsOverflow(result);
        return result;
    }

    public static BigInteger toNano(float toncoins) {
        if (BigDecimal.valueOf(toncoins).scale() > 9) {
            throw new Error("Round the number to 9 decimals first");
        }
        BigInteger result = BigDecimal.valueOf(toncoins).multiply(BigDecimal.valueOf(1000000000L)).toBigInteger();
        TonUtils.checkToncoinsOverflow(result);
        return result;
    }

    public static BigInteger toNano(BigDecimal toncoins) {
        if (toncoins.scale() > 9) {
            throw new Error("Round the number to 9 decimals first");
        }
        BigInteger result = toncoins.multiply(BigDecimal.valueOf(1000000000L)).toBigInteger();
        TonUtils.checkToncoinsOverflow(result);
        return result;
    }

    public static BigDecimal fromNano(BigInteger nanoCoins) {
        TonUtils.checkToncoinsOverflow(nanoCoins);
        return new BigDecimal(nanoCoins).divide(BigDecimal.valueOf(1000000000L), 9, RoundingMode.HALF_UP);
    }

    public static BigDecimal fromNano(String nanoCoins) {
        BigInteger nanoCoinsBI = new BigInteger(nanoCoins);
        TonUtils.checkToncoinsOverflow(nanoCoinsBI);
        return new BigDecimal(nanoCoins).divide(BigDecimal.valueOf(1000000000L), 9, RoundingMode.HALF_UP);
    }

    public static BigDecimal fromNano(long nanoCoins) {
        TonUtils.checkToncoinsOverflow(BigInteger.valueOf(nanoCoins));
        return new BigDecimal(nanoCoins).divide(BigDecimal.valueOf(1000000000L), 9, RoundingMode.HALF_UP);
    }

    public static String formatCoins(BigDecimal toncoins) {
        TonUtils.checkToncoinsOverflow(toncoins.multiply(BigDecimal.valueOf(1000000000L)).toBigInteger());
        if (toncoins.scale() > 9) {
            throw new Error("Round the number to 9 decimals first");
        }
        return String.format("%,.9f", toncoins.multiply(BigDecimal.valueOf(1000000000L)));
    }

    public static String formatCoins(String toncoins) {
        BigInteger nano = TonUtils.toNano(toncoins);
        return TonUtils.formatNanoValue(nano);
    }

    public static String formatCoins(BigDecimal toncoins, int scale) {
        BigInteger nano = TonUtils.toNano(toncoins);
        return TonUtils.formatNanoValue(nano, scale);
    }

    public static String formatCoins(String toncoins, int scale) {
        BigInteger nano = TonUtils.toNano(toncoins);
        return TonUtils.formatNanoValue(nano, scale);
    }

    public static String formatNanoValue(String nanoCoins) {
        TonUtils.checkToncoinsOverflow(new BigInteger(nanoCoins));
        return String.format("%,.9f", new BigDecimal(nanoCoins).divide(BigDecimal.valueOf(1000000000L), 9, RoundingMode.HALF_UP));
    }

    public static String formatNanoValue(long nanoCoins) {
        TonUtils.checkToncoinsOverflow(BigInteger.valueOf(nanoCoins));
        return String.format("%,.9f", new BigDecimal(nanoCoins).divide(BigDecimal.valueOf(1000000000L), 9, RoundingMode.HALF_UP));
    }

    public static String formatNanoValue(BigInteger nanoCoins) {
        TonUtils.checkToncoinsOverflow(nanoCoins);
        return String.format("%,.9f", new BigDecimal(nanoCoins).divide(BigDecimal.valueOf(1000000000L), 9, RoundingMode.HALF_UP));
    }

    public static String formatNanoValueZero(BigInteger nanoCoins) {
        if (Objects.isNull(nanoCoins)) {
            return "N/A";
        }
        TonUtils.checkToncoinsOverflow(nanoCoins);
        if (nanoCoins.compareTo(BigInteger.ZERO) == 0) {
            return "0";
        }
        return String.format("%,.9f", new BigDecimal(nanoCoins).divide(BigDecimal.valueOf(1000000000L), 9, RoundingMode.HALF_UP));
    }

    public static String formatNanoValue(String nanoCoins, int scale) {
        TonUtils.checkToncoinsOverflow(new BigInteger(nanoCoins));
        return String.format("%,." + scale + "f", new BigDecimal(nanoCoins).divide(BigDecimal.valueOf(1000000000L), scale, RoundingMode.HALF_UP));
    }

    public static String formatNanoValue(String nanoCoins, int scale, RoundingMode roundingMode) {
        TonUtils.checkToncoinsOverflow(new BigInteger(nanoCoins));
        return String.format("%,." + scale + "f", new BigDecimal(nanoCoins).divide(BigDecimal.valueOf(1000000000L), scale, roundingMode));
    }

    public static String formatJettonValue(String jettons, int decimals, int scale) {
        return String.format("%,." + scale + "f", new Object[]{new BigDecimal(jettons).divide(BigDecimal.valueOf(Math.pow(10.0, decimals))), scale, RoundingMode.HALF_UP});
    }

    public static String formatJettonValue(BigInteger jettons, int decimals, int scale) {
        return String.format("%,." + scale + "f", new Object[]{new BigDecimal(jettons).divide(BigDecimal.valueOf(Math.pow(10.0, decimals))), scale, RoundingMode.HALF_UP});
    }

    public static String formatNanoValue(BigInteger nanoCoins, int scale) {
        TonUtils.checkToncoinsOverflow(nanoCoins);
        return String.format("%,." + scale + "f", new BigDecimal(nanoCoins).divide(BigDecimal.valueOf(1000000000L), scale, RoundingMode.HALF_UP));
    }

    public static String convertShardIdentToShard(BigInteger shardPrefix, int prefixBits) {
        if (Objects.isNull(shardPrefix)) {
            throw new Error("Shard prefix is null, should be in range 0..60");
        }
        if (shardPrefix.compareTo(BigInteger.valueOf(60L)) > 0) {
            return shardPrefix.toString(16);
        }
        return BigInteger.valueOf(2L).multiply(shardPrefix).add(BigInteger.ONE).shiftLeft(63 - prefixBits).toString(16);
    }

    public static BigInteger longToUnsignedBigInteger(long num) {
        BigInteger b = BigInteger.valueOf(num);
        if (b.compareTo(BigInteger.ZERO) < 0) {
            b = b.add(BigInteger.ONE.shiftLeft(64));
        }
        return b;
    }

    public static BigInteger longToUnsignedBigInteger(String num) {
        BigInteger b = new BigInteger(num);
        if (b.compareTo(BigInteger.ZERO) < 0) {
            b = b.add(BigInteger.ONE.shiftLeft(64));
        }
        return b;
    }

    public static String generateRandomAddress(long workchain) {
        try {
            return workchain + ":" + ByteUtils.bytesToHex(HashUtils.sha256AsArray(UUID.randomUUID().toString().getBytes(StandardCharsets.UTF_8)));
        }
        catch (Throwable e) {
            throw new Error("cannot generate random address. Error " + e.getMessage());
        }
    }

    public static BigInteger signedBytesArrayToBigInteger(int[] intArray) {
        byte[] byteArray = new byte[intArray.length * 4];
        for (int i = 0; i < intArray.length; ++i) {
            byteArray[i * 4] = (byte)(intArray[i] >>> 24);
            byteArray[i * 4 + 1] = (byte)(intArray[i] >>> 16);
            byteArray[i * 4 + 2] = (byte)(intArray[i] >>> 8);
            byteArray[i * 4 + 3] = (byte)intArray[i];
        }
        return new BigInteger(1, byteArray);
    }

    private static void checkToncoinsOverflow(BigInteger amount) {
        int bytesSize = (int)Math.ceil((double)amount.bitLength() / 8.0);
        if (bytesSize >= 16) {
            throw new Error("Value is too big. Maximum value 2^120-1");
        }
    }
}

