/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.utils;

import java.util.Arrays;
import org.ton.java.utils.Utils;

public class SignatureWithRecovery {
    private byte[] r;
    private byte[] s;
    private byte[] v;

    public byte[] getSignature() {
        return Utils.concatBytes(this.r, this.s);
    }

    SignatureWithRecovery(byte[] r, byte[] s, byte[] v) {
        this.r = r;
        this.s = s;
        this.v = v;
    }

    public static SignatureWithRecoveryBuilder builder() {
        return new SignatureWithRecoveryBuilder();
    }

    public byte[] getR() {
        return this.r;
    }

    public byte[] getS() {
        return this.s;
    }

    public byte[] getV() {
        return this.v;
    }

    public void setR(byte[] r) {
        this.r = r;
    }

    public void setS(byte[] s) {
        this.s = s;
    }

    public void setV(byte[] v) {
        this.v = v;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SignatureWithRecovery)) {
            return false;
        }
        SignatureWithRecovery other = (SignatureWithRecovery)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.equals(this.getR(), other.getR())) {
            return false;
        }
        if (!Arrays.equals(this.getS(), other.getS())) {
            return false;
        }
        return Arrays.equals(this.getV(), other.getV());
    }

    protected boolean canEqual(Object other) {
        return other instanceof SignatureWithRecovery;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getR());
        result = result * 59 + Arrays.hashCode(this.getS());
        result = result * 59 + Arrays.hashCode(this.getV());
        return result;
    }

    public String toString() {
        return "SignatureWithRecovery(r=" + Arrays.toString(this.getR()) + ", s=" + Arrays.toString(this.getS()) + ", v=" + Arrays.toString(this.getV()) + ")";
    }

    public static class SignatureWithRecoveryBuilder {
        private byte[] r;
        private byte[] s;
        private byte[] v;

        SignatureWithRecoveryBuilder() {
        }

        public SignatureWithRecoveryBuilder r(byte[] r) {
            this.r = r;
            return this;
        }

        public SignatureWithRecoveryBuilder s(byte[] s) {
            this.s = s;
            return this;
        }

        public SignatureWithRecoveryBuilder v(byte[] v) {
            this.v = v;
            return this;
        }

        public SignatureWithRecovery build() {
            return new SignatureWithRecovery(this.r, this.s, this.v);
        }

        public String toString() {
            return "SignatureWithRecovery.SignatureWithRecoveryBuilder(r=" + Arrays.toString(this.r) + ", s=" + Arrays.toString(this.s) + ", v=" + Arrays.toString(this.v) + ")";
        }
    }
}

