/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tonlib.types;

import com.google.gson.annotations.SerializedName;
import java.io.Serializable;
import org.ton.java.utils.Utils;

public class BlockIdExt
implements Serializable {
    @SerializedName(value="@type")
    final String type = "ton.blockIdExt";
    long workchain;
    long shard;
    long seqno;
    String root_hash;
    String file_hash;

    public String getShortBlockSeqno() {
        return String.format("(%d,%s,%d)", this.workchain, Utils.longToUnsignedBigInteger((long)this.shard).toString(16), this.seqno);
    }

    public String getFullBlockSeqno() {
        return String.format("(%d,%s,%d):%s:%s", this.workchain, Utils.longToUnsignedBigInteger((long)this.shard).toString(16), this.seqno, this.root_hash, this.file_hash);
    }

    BlockIdExt(long workchain, long shard, long seqno, String root_hash, String file_hash) {
        this.workchain = workchain;
        this.shard = shard;
        this.seqno = seqno;
        this.root_hash = root_hash;
        this.file_hash = file_hash;
    }

    public static BlockIdExtBuilder builder() {
        return new BlockIdExtBuilder();
    }

    public String getType() {
        return this.type;
    }

    public long getWorkchain() {
        return this.workchain;
    }

    public long getShard() {
        return this.shard;
    }

    public long getSeqno() {
        return this.seqno;
    }

    public String getRoot_hash() {
        return this.root_hash;
    }

    public String getFile_hash() {
        return this.file_hash;
    }

    public void setWorkchain(long workchain) {
        this.workchain = workchain;
    }

    public void setShard(long shard) {
        this.shard = shard;
    }

    public void setSeqno(long seqno) {
        this.seqno = seqno;
    }

    public void setRoot_hash(String root_hash) {
        this.root_hash = root_hash;
    }

    public void setFile_hash(String file_hash) {
        this.file_hash = file_hash;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BlockIdExt)) {
            return false;
        }
        BlockIdExt other = (BlockIdExt)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getWorkchain() != other.getWorkchain()) {
            return false;
        }
        if (this.getShard() != other.getShard()) {
            return false;
        }
        if (this.getSeqno() != other.getSeqno()) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$root_hash = this.getRoot_hash();
        String other$root_hash = other.getRoot_hash();
        if (this$root_hash == null ? other$root_hash != null : !this$root_hash.equals(other$root_hash)) {
            return false;
        }
        String this$file_hash = this.getFile_hash();
        String other$file_hash = other.getFile_hash();
        return !(this$file_hash == null ? other$file_hash != null : !this$file_hash.equals(other$file_hash));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BlockIdExt;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $workchain = this.getWorkchain();
        result = result * 59 + (int)($workchain >>> 32 ^ $workchain);
        long $shard = this.getShard();
        result = result * 59 + (int)($shard >>> 32 ^ $shard);
        long $seqno = this.getSeqno();
        result = result * 59 + (int)($seqno >>> 32 ^ $seqno);
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $root_hash = this.getRoot_hash();
        result = result * 59 + ($root_hash == null ? 43 : $root_hash.hashCode());
        String $file_hash = this.getFile_hash();
        result = result * 59 + ($file_hash == null ? 43 : $file_hash.hashCode());
        return result;
    }

    public String toString() {
        return "BlockIdExt(type=" + this.getType() + ", workchain=" + this.getWorkchain() + ", shard=" + this.getShard() + ", seqno=" + this.getSeqno() + ", root_hash=" + this.getRoot_hash() + ", file_hash=" + this.getFile_hash() + ")";
    }

    public static class BlockIdExtBuilder {
        private long workchain;
        private long shard;
        private long seqno;
        private String root_hash;
        private String file_hash;

        BlockIdExtBuilder() {
        }

        public BlockIdExtBuilder workchain(long workchain) {
            this.workchain = workchain;
            return this;
        }

        public BlockIdExtBuilder shard(long shard) {
            this.shard = shard;
            return this;
        }

        public BlockIdExtBuilder seqno(long seqno) {
            this.seqno = seqno;
            return this;
        }

        public BlockIdExtBuilder root_hash(String root_hash) {
            this.root_hash = root_hash;
            return this;
        }

        public BlockIdExtBuilder file_hash(String file_hash) {
            this.file_hash = file_hash;
            return this;
        }

        public BlockIdExt build() {
            return new BlockIdExt(this.workchain, this.shard, this.seqno, this.root_hash, this.file_hash);
        }

        public String toString() {
            return "BlockIdExt.BlockIdExtBuilder(workchain=" + this.workchain + ", shard=" + this.shard + ", seqno=" + this.seqno + ", root_hash=" + this.root_hash + ", file_hash=" + this.file_hash + ")";
        }
    }
}

