/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tonlib;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.ToNumberPolicy;
import com.google.gson.ToNumberStrategy;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Objects;
import org.ton.java.tonlib.types.RunResult;
import org.ton.java.tonlib.types.TvmCell;
import org.ton.java.tonlib.types.TvmList;
import org.ton.java.tonlib.types.TvmNumber;
import org.ton.java.tonlib.types.TvmSlice;
import org.ton.java.tonlib.types.TvmStackEntryCell;
import org.ton.java.tonlib.types.TvmStackEntryList;
import org.ton.java.tonlib.types.TvmStackEntryNumber;
import org.ton.java.tonlib.types.TvmStackEntrySlice;
import org.ton.java.tonlib.types.TvmStackEntryTuple;
import org.ton.java.tonlib.types.TvmTuple;

public class RunResultParser {
    private static final Gson customGson;

    RunResultParser() {
    }

    public RunResult parse(String runMethodResult) {
        RunResult result;
        try {
            result = (RunResult)customGson.fromJson(runMethodResult, RunResult.class);
        }
        catch (Throwable e) {
            result = RunResult.builder().exit_code(-1L).build();
        }
        return result;
    }

    private static Object deserializeByType(String type, JsonElement jsonElement, JsonDeserializationContext context) {
        Class clazz;
        switch (type) {
            case "tvm.stackEntryNumber": {
                clazz = TvmStackEntryNumber.class;
                break;
            }
            case "tvm.stackEntryCell": {
                clazz = TvmStackEntryCell.class;
                break;
            }
            case "tvm.stackEntrySlice": {
                clazz = TvmStackEntrySlice.class;
                break;
            }
            case "tvm.stackEntryList": {
                clazz = TvmStackEntryList.class;
                break;
            }
            case "tvm.stackEntryTuple": {
                clazz = TvmStackEntryTuple.class;
                break;
            }
            default: {
                clazz = null;
            }
        }
        return clazz != null ? context.deserialize(jsonElement, clazz) : null;
    }

    static {
        GsonBuilder gsonBuilder = new GsonBuilder();
        JsonDeserializer deserializerStackEntryNumber = (json, typeOfT, context) -> {
            JsonObject i2 = json.getAsJsonObject().get("number").getAsJsonObject();
            String i3 = i2.getAsJsonObject().get("number").getAsString();
            TvmNumber n = TvmNumber.builder().number(i3).build();
            return TvmStackEntryNumber.builder().number(n).build();
        };
        JsonDeserializer deserializerStackEntryCell = (json, typeOfT, context) -> {
            JsonObject i2 = json.getAsJsonObject().get("cell").getAsJsonObject();
            String i3 = i2.getAsJsonObject().get("bytes").getAsString();
            TvmCell n = TvmCell.builder().bytes(i3).build();
            return TvmStackEntryCell.builder().cell(n).build();
        };
        JsonDeserializer deserializerStackEntrySlice = (json, typeOfT, context) -> {
            JsonObject i2 = json.getAsJsonObject().get("slice").getAsJsonObject();
            String i3 = i2.getAsJsonObject().get("bytes").getAsString();
            TvmSlice n = TvmSlice.builder().bytes(i3).build();
            return TvmStackEntrySlice.builder().slice(n).build();
        };
        JsonDeserializer deserializerStackEntryList = (json, typeOfT, context) -> {
            ArrayList<Object> elements;
            JsonElement l = json.getAsJsonObject().get("list");
            JsonArray elementsArray = l.getAsJsonObject().getAsJsonArray("elements");
            ArrayList<Object> arrayList = elements = Objects.nonNull(elementsArray) ? new ArrayList<Object>(elementsArray.size()) : new ArrayList(0);
            if (Objects.nonNull(elementsArray)) {
                for (int j = 0; j < elementsArray.size(); ++j) {
                    JsonElement element = elementsArray.get(j);
                    String elementType = element.getAsJsonObject().get("@type").getAsString();
                    elements.add(RunResultParser.deserializeByType(elementType, element, context));
                }
            }
            TvmList list = TvmList.builder().elements(elements).build();
            return TvmStackEntryList.builder().list(list).build();
        };
        JsonDeserializer deserializerStackEntryTuple = (json, typeOfT, context) -> {
            ArrayList<Object> elements;
            JsonElement l = json.getAsJsonObject().get("tuple");
            JsonArray elementsArray = l.getAsJsonObject().getAsJsonArray("elements");
            ArrayList<Object> arrayList = elements = Objects.nonNull(elementsArray) ? new ArrayList<Object>(elementsArray.size()) : new ArrayList(0);
            if (Objects.nonNull(elementsArray)) {
                for (int j = 0; j < elementsArray.size(); ++j) {
                    JsonElement element = elementsArray.get(j);
                    String elementType = element.getAsJsonObject().get("@type").getAsString();
                    elements.add(RunResultParser.deserializeByType(elementType, element, context));
                }
            }
            TvmTuple tuple = TvmTuple.builder().elements(elements).build();
            return TvmStackEntryTuple.builder().tuple(tuple).build();
        };
        JsonDeserializer deserializer = (json, typeOfT, context) -> {
            JsonObject jsonObject = json.getAsJsonObject();
            String el = jsonObject.get("@type").toString();
            if (!el.contains("smc.runResult")) {
                throw new Error("malformed response from run_method");
            }
            JsonArray stackArray = jsonObject.get("stack").getAsJsonArray();
            ArrayList<Object> stack = new ArrayList<Object>(stackArray.size());
            BigInteger gasUsed = jsonObject.get("gas_used").getAsBigInteger();
            long exitCode = jsonObject.get("exit_code").getAsLong();
            for (int i = 0; i < stackArray.size(); ++i) {
                JsonElement element = stackArray.get(i);
                String elementType = element.getAsJsonObject().get("@type").getAsString();
                stack.add(RunResultParser.deserializeByType(elementType, element, context));
            }
            return RunResult.builder().stack(stack).exit_code(exitCode).gas_used(gasUsed).build();
        };
        gsonBuilder.registerTypeAdapter(RunResult.class, (Object)deserializer);
        gsonBuilder.registerTypeAdapter(TvmStackEntryNumber.class, (Object)deserializerStackEntryNumber);
        gsonBuilder.registerTypeAdapter(TvmStackEntryCell.class, (Object)deserializerStackEntryCell);
        gsonBuilder.registerTypeAdapter(TvmStackEntrySlice.class, (Object)deserializerStackEntrySlice);
        gsonBuilder.registerTypeAdapter(TvmStackEntryList.class, (Object)deserializerStackEntryList);
        gsonBuilder.registerTypeAdapter(TvmStackEntryTuple.class, (Object)deserializerStackEntryTuple);
        customGson = gsonBuilder.setObjectToNumberStrategy((ToNumberStrategy)ToNumberPolicy.BIG_DECIMAL).disableHtmlEscaping().create();
    }
}

