/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.smartcontract.wallet.v4;

import com.iwebpp.crypto.TweetNaclFast;
import java.lang.invoke.CallSite;
import java.math.BigInteger;
import java.time.Instant;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.ton.java.address.Address;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.smartcontract.types.WalletCodes;
import org.ton.java.smartcontract.types.WalletV4R2Config;
import org.ton.java.smartcontract.utils.MsgUtils;
import org.ton.java.smartcontract.wallet.Contract;
import org.ton.java.smartcontract.wallet.v4.SubscriptionInfo;
import org.ton.java.tlb.CommonMsgInfo;
import org.ton.java.tlb.CommonMsgInfoRelaxed;
import org.ton.java.tlb.CurrencyCollection;
import org.ton.java.tlb.ExternalMessageInInfo;
import org.ton.java.tlb.InternalMessageInfo;
import org.ton.java.tlb.InternalMessageInfoRelaxed;
import org.ton.java.tlb.Message;
import org.ton.java.tlb.MessageRelaxed;
import org.ton.java.tlb.MsgAddressInt;
import org.ton.java.tlb.MsgAddressIntStd;
import org.ton.java.tlb.StateInit;
import org.ton.java.tonlib.Tonlib;
import org.ton.java.tonlib.types.ExtMessageInfo;
import org.ton.java.tonlib.types.RawTransaction;
import org.ton.java.tonlib.types.RunResult;
import org.ton.java.tonlib.types.TvmStackEntryList;
import org.ton.java.tonlib.types.TvmStackEntryNumber;
import org.ton.java.tonlib.types.TvmStackEntryTuple;
import org.ton.java.tonlib.types.TvmTuple;
import org.ton.java.utils.Utils;

public class WalletV4R2
implements Contract {
    TweetNaclFast.Signature.KeyPair keyPair;
    long walletId;
    long initialSeqno;
    byte[] publicKey;
    private Tonlib tonlib;
    private long wc;

    public static WalletV4R2Builder builder() {
        return new CustomWalletV4R2Builder();
    }

    @Override
    public Tonlib getTonlib() {
        return this.tonlib;
    }

    @Override
    public void setTonlib(Tonlib pTonlib) {
        this.tonlib = pTonlib;
    }

    @Override
    public long getWorkchain() {
        return this.wc;
    }

    @Override
    public String getName() {
        return "V4R2";
    }

    @Override
    public Cell createDataCell() {
        return CellBuilder.beginCell().storeUint(this.initialSeqno, 32).storeUint(this.walletId, 32).storeBytes(Objects.isNull(this.keyPair) ? this.publicKey : this.keyPair.getPublicKey()).storeUint(0, 1).endCell();
    }

    @Override
    public Cell createCodeCell() {
        return CellBuilder.beginCell().fromBoc(WalletCodes.V4R2.getValue()).endCell();
    }

    public Cell createDeployMessage() {
        return CellBuilder.beginCell().storeUint(this.walletId, 32).storeInt(-1, 32).storeUint(this.initialSeqno, 32).endCell();
    }

    public Cell createTransferBody(WalletV4R2Config config) {
        CellBuilder message = CellBuilder.beginCell();
        message.storeUint(config.getWalletId(), 32);
        message.storeUint(config.getValidUntil() == 0L ? Instant.now().getEpochSecond() + 60L : config.getValidUntil(), 32);
        message.storeUint(config.getSeqno(), 32);
        if (config.getOperation() == 0) {
            Cell order = MessageRelaxed.builder().info((CommonMsgInfoRelaxed)InternalMessageInfoRelaxed.builder().bounce(Boolean.valueOf(config.isBounce())).dstAddr((MsgAddressInt)MsgAddressIntStd.builder().workchainId(config.getDestination().wc).address(config.getDestination().toBigInteger()).build()).value(CurrencyCollection.builder().coins(config.getAmount()).extraCurrencies(this.convertExtraCurrenciesToHashMap(config.getExtraCurrencies())).build()).build()).init(config.getStateInit()).body(Objects.isNull(config.getBody()) && Objects.nonNull(config.getComment()) ? CellBuilder.beginCell().storeUint(0, 32).storeString(config.getComment()).endCell() : config.getBody()).build().toCell();
            message.storeUint(BigInteger.ZERO, 8);
            message.storeUint(config.getMode(), 8);
            message.storeRef(order);
        } else if (config.getOperation() == 1) {
            message.storeUint(1, 8);
            message.storeUint(BigInteger.valueOf(config.getNewPlugin().getPluginWc()), 8);
            message.storeCoins(config.getNewPlugin().getAmount());
            message.storeRef(config.getNewPlugin().getStateInit());
            message.storeRef(config.getNewPlugin().getBody());
        }
        if (config.getOperation() == 2) {
            message.storeUint(2, 8);
            message.storeUint(BigInteger.valueOf(config.getDeployedPlugin().getPluginAddress().wc), 8);
            message.storeBytes(config.getDeployedPlugin().getPluginAddress().hashPart);
            message.storeCoins(BigInteger.valueOf(config.getDeployedPlugin().getAmount().longValue()));
            message.storeUint(BigInteger.valueOf(config.getDeployedPlugin().getQueryId()), 64);
            message.endCell();
        }
        if (config.getOperation() == 3) {
            message.storeUint(3, 8);
            message.storeUint(BigInteger.valueOf(config.getDeployedPlugin().getPluginAddress().wc), 8);
            message.storeBytes(config.getDeployedPlugin().getPluginAddress().hashPart);
            message.storeCoins(BigInteger.valueOf(config.getDeployedPlugin().getAmount().longValue()));
            message.storeUint(BigInteger.valueOf(config.getDeployedPlugin().getQueryId()), 64);
            message.endCell();
        }
        return message.endCell();
    }

    public ExtMessageInfo deploy() {
        return this.tonlib.sendRawMessage(this.prepareDeployMsg().toCell().toBase64());
    }

    public ExtMessageInfo deploy(byte[] signedBody) {
        return this.tonlib.sendRawMessage(this.prepareDeployMsg(signedBody).toCell().toBase64());
    }

    public Message prepareDeployMsg(byte[] signedBodyHash) {
        Cell body = this.createDeployMessage();
        return Message.builder().info((CommonMsgInfo)ExternalMessageInInfo.builder().dstAddr((MsgAddressInt)this.getAddressIntStd()).build()).init(this.getStateInit()).body(CellBuilder.beginCell().storeBytes(signedBodyHash).storeCell(body).endCell()).build();
    }

    public ExtMessageInfo send(WalletV4R2Config config, byte[] signedBodyHash) {
        return this.tonlib.sendRawMessage(this.prepareExternalMsg(config, signedBodyHash).toCell().toBase64());
    }

    public Message prepareExternalMsg(WalletV4R2Config config, byte[] signedBodyHash) {
        Cell body = this.createTransferBody(config);
        return MsgUtils.createExternalMessageWithSignedBody(signedBodyHash, this.getAddress(), null, body);
    }

    public ExtMessageInfo send(WalletV4R2Config config) {
        return this.tonlib.sendRawMessage(this.prepareExternalMsg(config).toCell().toBase64());
    }

    public Message prepareExternalMsg(WalletV4R2Config config) {
        Cell body = this.createTransferBody(config);
        return MsgUtils.createExternalMessageWithSignedBody(this.keyPair, this.getAddress(), null, body);
    }

    @Override
    public Message prepareDeployMsg() {
        Cell body = this.createDeployMessage();
        return Message.builder().info((CommonMsgInfo)ExternalMessageInInfo.builder().dstAddr((MsgAddressInt)this.getAddressIntStd()).build()).init(this.getStateInit()).body(CellBuilder.beginCell().storeBytes(Utils.signData((byte[])this.keyPair.getPublicKey(), (byte[])this.keyPair.getSecretKey(), (byte[])body.hash())).storeCell(body).endCell()).build();
    }

    public Cell createPluginStateInit(SubscriptionInfo subscriptionInfo) {
        Cell code = CellBuilder.beginCell().fromBoc("B5EE9C7241020F01000262000114FF00F4A413F4BCF2C80B0102012002030201480405036AF230DB3C5335A127A904F82327A128A90401BC5135A0F823B913B0F29EF800725210BE945387F0078E855386DB3CA4E2F82302DB3C0B0C0D0202CD06070121A0D0C9B67813F488DE0411F488DE0410130B048FD6D9E05E8698198FD201829846382C74E2F841999E98F9841083239BA395D497803F018B841083AB735BBED9E702984E382D9C74688462F863841083AB735BBED9E70156BA4E09040B0A0A080269F10FD22184093886D9E7C12C1083239BA39384008646582A803678B2801FD010A65B5658F89659FE4B9FD803FC1083239BA396D9E40E0A04F08E8D108C5F0C708210756E6B77DB3CE00AD31F308210706C7567831EB15210BA8F48305324A126A904F82326A127A904BEF27109FA4430A619F833D078D721D70B3F5260A11BBE8E923036F82370708210737562732759DB3C5077DE106910581047103645135042DB3CE0395F076C2232821064737472BA0A0A0D09011A8E897F821064737472DB3CE0300A006821B39982100400000072FB02DE70F8276F118010C8CB055005CF1621FA0214F40013CB6912CB1F830602948100A032DEC901FB000030ED44D0FA40FA40FA00D31FD31FD31FD31FD31FD307D31F30018021FA443020813A98DB3C01A619F833D078D721D70B3FA070F8258210706C7567228018C8CB055007CF165004FA0215CB6A12CB1F13CB3F01FA02CB00C973FB000E0040C8500ACF165008CF165006FA0214CB1F12CB1FCB1FCB1FCB1FCB07CB1FC9ED54005801A615F833D020D70B078100D1BA95810088D721DED307218100DDBA028100DEBA12B1F2E047D33F30A8AB0FE5855AB4").endCell();
        Cell data = WalletV4R2.createPluginDataCell(this.getAddress(), subscriptionInfo.getBeneficiary(), subscriptionInfo.getSubscriptionFee(), subscriptionInfo.getPeriod(), subscriptionInfo.getStartTime(), subscriptionInfo.getTimeOut(), subscriptionInfo.getLastPaymentTime(), subscriptionInfo.getLastRequestTime(), subscriptionInfo.getFailedAttempts(), subscriptionInfo.getSubscriptionId());
        return StateInit.builder().code(code).data(data).build().toCell();
    }

    public Cell createPluginBody() {
        return CellBuilder.beginCell().storeUint(new BigInteger("706c7567", 16).add(new BigInteger("80000000", 16)), 32).endCell();
    }

    public Cell createPluginSelfDestructBody() {
        return CellBuilder.beginCell().storeUint(1685288050, 32).endCell();
    }

    public ExtMessageInfo installPlugin(Tonlib tonlib, WalletV4R2Config config) {
        Address ownAddress = this.getAddress();
        config.setOperation(2);
        Cell body = this.createTransferBody(config);
        Cell extMsg = MsgUtils.createExternalMessageWithSignedBody(this.keyPair, ownAddress, this.getStateInit(), body).toCell();
        return tonlib.sendRawMessage(extMsg.toBase64());
    }

    public ExtMessageInfo uninstallPlugin(WalletV4R2Config config) {
        Address ownAddress = this.getAddress();
        config.setOperation(3);
        Cell body = this.createTransferBody(config);
        Cell extMsg = MsgUtils.createExternalMessageWithSignedBody(this.keyPair, ownAddress, this.getStateInit(), body).toCell();
        return this.tonlib.sendRawMessage(extMsg.toBase64());
    }

    public long getWalletId() {
        RunResult result = this.tonlib.runMethod(this.getAddress(), "get_subwallet_id");
        TvmStackEntryNumber subWalletId = (TvmStackEntryNumber)result.getStack().get(0);
        return subWalletId.getNumber().longValue();
    }

    public byte[] getPublicKey() {
        RunResult result = this.tonlib.runMethod(this.getAddress(), "get_public_key");
        TvmStackEntryNumber pubKey = (TvmStackEntryNumber)result.getStack().get(0);
        return pubKey.getNumber().toByteArray();
    }

    public boolean isPluginInstalled(Address pluginAddress) {
        String hashPart = new BigInteger(pluginAddress.hashPart).toString();
        Address myAddress = this.getAddress();
        ArrayDeque<CallSite> stack = new ArrayDeque<CallSite>();
        stack.offer((CallSite)((Object)("[num, " + pluginAddress.wc + "]")));
        stack.offer((CallSite)((Object)("[num, " + hashPart + "]")));
        RunResult result = this.tonlib.runMethod(myAddress, "is_plugin_installed", stack);
        TvmStackEntryNumber resultNumber = (TvmStackEntryNumber)result.getStack().get(0);
        return resultNumber.getNumber().longValue() != 0L;
    }

    public List<String> getPluginsList() {
        ArrayList<String> r = new ArrayList<String>();
        Address myAddress = this.getAddress();
        RunResult result = this.tonlib.runMethod(myAddress, "get_plugin_list");
        TvmStackEntryList list = (TvmStackEntryList)result.getStack().get(0);
        for (Object o : list.getList().getElements()) {
            TvmStackEntryTuple t = (TvmStackEntryTuple)o;
            TvmTuple tuple = t.getTuple();
            TvmStackEntryNumber wc = (TvmStackEntryNumber)tuple.getElements().get(0);
            TvmStackEntryNumber addr = (TvmStackEntryNumber)tuple.getElements().get(1);
            r.add(String.valueOf(wc.getNumber()) + ":" + addr.getNumber().toString(16).toUpperCase());
        }
        return r;
    }

    public SubscriptionInfo getSubscriptionData(Address pluginAddress) {
        RunResult result = this.tonlib.runMethod(pluginAddress, "get_subscription_data");
        if (result.getExit_code() == 0L) {
            return this.parseSubscriptionData(result.getStack());
        }
        throw new Error("Error executing get_subscription_data. Exit code " + result.getExit_code());
    }

    public static Cell createPluginDataCell(Address wallet, Address beneficiary, BigInteger amount, long period, long startTime, long timeOut, long lastPaymentTime, long lastRequestTime, long failedAttempts, long subscriptionId) {
        return CellBuilder.beginCell().storeAddress(wallet).storeAddress(beneficiary).storeCoins(amount).storeUint(BigInteger.valueOf(period), 32).storeUint(BigInteger.valueOf(startTime), 32).storeUint(BigInteger.valueOf(timeOut), 32).storeUint(BigInteger.valueOf(lastPaymentTime), 32).storeUint(BigInteger.valueOf(lastRequestTime), 32).storeUint(BigInteger.valueOf(failedAttempts), 8).storeUint(BigInteger.valueOf(subscriptionId), 32).endCell();
    }

    private SubscriptionInfo parseSubscriptionData(List subscriptionData) {
        TvmStackEntryTuple walletAddr = (TvmStackEntryTuple)subscriptionData.get(0);
        TvmStackEntryNumber wc = (TvmStackEntryNumber)walletAddr.getTuple().getElements().get(0);
        TvmStackEntryNumber hash = (TvmStackEntryNumber)walletAddr.getTuple().getElements().get(1);
        TvmStackEntryTuple beneficiaryAddr = (TvmStackEntryTuple)subscriptionData.get(1);
        TvmStackEntryNumber beneficiaryAddrWc = (TvmStackEntryNumber)beneficiaryAddr.getTuple().getElements().get(0);
        TvmStackEntryNumber beneficiaryAddrHash = (TvmStackEntryNumber)beneficiaryAddr.getTuple().getElements().get(1);
        TvmStackEntryNumber amount = (TvmStackEntryNumber)subscriptionData.get(2);
        TvmStackEntryNumber period = (TvmStackEntryNumber)subscriptionData.get(3);
        TvmStackEntryNumber startTime = (TvmStackEntryNumber)subscriptionData.get(4);
        TvmStackEntryNumber timeOut = (TvmStackEntryNumber)subscriptionData.get(5);
        TvmStackEntryNumber lastPaymentTime = (TvmStackEntryNumber)subscriptionData.get(6);
        TvmStackEntryNumber lastRequestTime = (TvmStackEntryNumber)subscriptionData.get(7);
        long now = System.currentTimeMillis() / 1000L;
        boolean isPaid = now - lastPaymentTime.getNumber().longValue() < period.getNumber().longValue();
        boolean paymentReady = !isPaid & now - lastRequestTime.getNumber().longValue() > timeOut.getNumber().longValue();
        TvmStackEntryNumber failedAttempts = (TvmStackEntryNumber)subscriptionData.get(8);
        TvmStackEntryNumber subscriptionId = (TvmStackEntryNumber)subscriptionData.get(9);
        return SubscriptionInfo.builder().walletAddress(Address.of((String)(String.valueOf(wc.getNumber()) + ":" + hash.getNumber().toString(16)))).beneficiary(Address.of((String)(String.valueOf(beneficiaryAddrWc.getNumber()) + ":" + beneficiaryAddrHash.getNumber().toString(16)))).subscriptionFee(amount.getNumber()).period(period.getNumber().longValue()).startTime(startTime.getNumber().longValue()).timeOut(timeOut.getNumber().longValue()).lastPaymentTime(lastPaymentTime.getNumber().longValue()).lastRequestTime(lastRequestTime.getNumber().longValue()).isPaid(isPaid).isPaymentReady(paymentReady).failedAttempts(failedAttempts.getNumber().longValue()).subscriptionId(subscriptionId.getNumber().longValue()).build();
    }

    public RawTransaction sendWithConfirmation(WalletV4R2Config config) {
        return this.tonlib.sendRawMessageWithConfirmation(this.prepareExternalMsg(config).toCell().toBase64(), this.getAddress());
    }

    public Cell createInternalSignedBody(WalletV4R2Config config) {
        Cell body = this.createTransferBody(config);
        byte[] signature = Utils.signData((byte[])this.keyPair.getPublicKey(), (byte[])this.keyPair.getSecretKey(), (byte[])body.hash());
        return CellBuilder.beginCell().storeCell(body).storeBytes(signature).endCell();
    }

    public Message prepareInternalMsg(WalletV4R2Config config) {
        Cell body = this.createInternalSignedBody(config);
        return Message.builder().info((CommonMsgInfo)InternalMessageInfo.builder().srcAddr((MsgAddressInt)this.getAddressIntStd()).dstAddr((MsgAddressInt)this.getAddressIntStd()).value(CurrencyCollection.builder().coins(config.getAmount()).build()).build()).body(body).build();
    }

    public MessageRelaxed prepareInternalMsgRelaxed(WalletV4R2Config config) {
        Cell body = this.createInternalSignedBody(config);
        return MessageRelaxed.builder().info((CommonMsgInfoRelaxed)InternalMessageInfoRelaxed.builder().dstAddr((MsgAddressInt)this.getAddressIntStd()).value(CurrencyCollection.builder().coins(config.getAmount()).build()).build()).body(body).build();
    }

    WalletV4R2(TweetNaclFast.Signature.KeyPair keyPair, long walletId, long initialSeqno, byte[] publicKey, Tonlib tonlib, long wc) {
        this.keyPair = keyPair;
        this.walletId = walletId;
        this.initialSeqno = initialSeqno;
        this.publicKey = publicKey;
        this.tonlib = tonlib;
        this.wc = wc;
    }

    public TweetNaclFast.Signature.KeyPair getKeyPair() {
        return this.keyPair;
    }

    public long getInitialSeqno() {
        return this.initialSeqno;
    }

    public long getWc() {
        return this.wc;
    }

    private static class CustomWalletV4R2Builder
    extends WalletV4R2Builder {
        private CustomWalletV4R2Builder() {
        }

        @Override
        public WalletV4R2 build() {
            if (Objects.isNull(this.publicKey) && Objects.isNull(this.keyPair)) {
                this.keyPair = Utils.generateSignatureKeyPair();
            }
            return super.build();
        }
    }

    public static class WalletV4R2Builder {
        private TweetNaclFast.Signature.KeyPair keyPair;
        private long walletId;
        private long initialSeqno;
        private byte[] publicKey;
        private Tonlib tonlib;
        private long wc;

        WalletV4R2Builder() {
        }

        public WalletV4R2Builder keyPair(TweetNaclFast.Signature.KeyPair keyPair) {
            this.keyPair = keyPair;
            return this;
        }

        public WalletV4R2Builder walletId(long walletId) {
            this.walletId = walletId;
            return this;
        }

        public WalletV4R2Builder initialSeqno(long initialSeqno) {
            this.initialSeqno = initialSeqno;
            return this;
        }

        public WalletV4R2Builder publicKey(byte[] publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        public WalletV4R2Builder tonlib(Tonlib tonlib) {
            this.tonlib = tonlib;
            return this;
        }

        public WalletV4R2Builder wc(long wc) {
            this.wc = wc;
            return this;
        }

        public WalletV4R2 build() {
            return new WalletV4R2(this.keyPair, this.walletId, this.initialSeqno, this.publicKey, this.tonlib, this.wc);
        }

        public String toString() {
            return "WalletV4R2.WalletV4R2Builder(keyPair=" + String.valueOf(this.keyPair) + ", walletId=" + this.walletId + ", initialSeqno=" + this.initialSeqno + ", publicKey=" + Arrays.toString(this.publicKey) + ", tonlib=" + String.valueOf(this.tonlib) + ", wc=" + this.wc + ")";
        }
    }
}

