/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.smartcontract.wallet.v2;

import com.iwebpp.crypto.TweetNaclFast;
import java.math.BigInteger;
import java.time.Instant;
import java.util.Arrays;
import java.util.Objects;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.smartcontract.types.WalletCodes;
import org.ton.java.smartcontract.types.WalletV2R1Config;
import org.ton.java.smartcontract.utils.MsgUtils;
import org.ton.java.smartcontract.wallet.Contract;
import org.ton.java.tlb.CommonMsgInfo;
import org.ton.java.tlb.CommonMsgInfoRelaxed;
import org.ton.java.tlb.CurrencyCollection;
import org.ton.java.tlb.ExternalMessageInInfo;
import org.ton.java.tlb.InternalMessageInfo;
import org.ton.java.tlb.InternalMessageInfoRelaxed;
import org.ton.java.tlb.Message;
import org.ton.java.tlb.MessageRelaxed;
import org.ton.java.tlb.MsgAddressInt;
import org.ton.java.tonlib.Tonlib;
import org.ton.java.tonlib.types.ExtMessageInfo;
import org.ton.java.tonlib.types.RawTransaction;
import org.ton.java.utils.Utils;

public class WalletV2R1
implements Contract {
    public TweetNaclFast.Signature.KeyPair keyPair;
    long initialSeqno;
    byte[] publicKey;
    private Tonlib tonlib;
    private long wc;

    public static WalletV2R1Builder builder() {
        return new CustomWalletV2R1Builder();
    }

    @Override
    public Tonlib getTonlib() {
        return this.tonlib;
    }

    @Override
    public void setTonlib(Tonlib pTonlib) {
        this.tonlib = pTonlib;
    }

    @Override
    public long getWorkchain() {
        return this.wc;
    }

    @Override
    public String getName() {
        return "V2R1";
    }

    @Override
    public Cell createCodeCell() {
        return CellBuilder.beginCell().fromBoc(WalletCodes.V2R1.getValue()).endCell();
    }

    @Override
    public Cell createDataCell() {
        return CellBuilder.beginCell().storeUint(this.initialSeqno, 32).storeBytes(Objects.isNull(this.keyPair) ? this.publicKey : this.keyPair.getPublicKey()).endCell();
    }

    public Cell createDeployMessage() {
        return CellBuilder.beginCell().storeUint(0, 32).storeInt(-1, 32).endCell();
    }

    public Cell createTransferBody(WalletV2R1Config config) {
        MessageRelaxed order;
        CellBuilder message = CellBuilder.beginCell();
        message.storeUint(BigInteger.valueOf(config.getSeqno()), 32);
        message.storeUint(config.getValidUntil() == 0L ? Instant.now().getEpochSecond() + 60L : config.getValidUntil(), 32);
        if (Objects.nonNull(config.getDestination1())) {
            order = MsgUtils.createInternalMessageRelaxed(config.getDestination1(), config.getAmount1(), config.getExtraCurrencies1(), config.getStateInit(), config.getBody(), config.getBounce());
            message.storeUint(config.getMode() == 0 ? 3 : config.getMode(), 8);
            message.storeRef(order.toCell());
        }
        if (Objects.nonNull(config.getDestination2())) {
            order = MsgUtils.createInternalMessageRelaxed(config.getDestination2(), config.getAmount2(), config.getExtraCurrencies2(), config.getStateInit(), config.getBody(), config.getBounce());
            message.storeUint(config.getMode() == 0 ? 3 : config.getMode(), 8);
            message.storeRef(order.toCell());
        }
        if (Objects.nonNull(config.getDestination3())) {
            order = MsgUtils.createInternalMessageRelaxed(config.getDestination3(), config.getAmount3(), config.getExtraCurrencies3(), config.getStateInit(), config.getBody(), config.getBounce());
            message.storeUint(config.getMode() == 0 ? 3 : config.getMode(), 8);
            message.storeRef(order.toCell());
        }
        if (Objects.nonNull(config.getDestination4())) {
            order = MsgUtils.createInternalMessageRelaxed(config.getDestination4(), config.getAmount3(), config.getExtraCurrencies4(), config.getStateInit(), config.getBody(), config.getBounce());
            message.storeUint(config.getMode() == 0 ? 3 : config.getMode(), 8);
            message.storeRef(order.toCell());
        }
        return message.endCell();
    }

    public ExtMessageInfo send(WalletV2R1Config config) {
        return this.tonlib.sendRawMessage(this.prepareExternalMsg(config).toCell().toBase64());
    }

    public RawTransaction sendWithConfirmation(WalletV2R1Config config) {
        return this.tonlib.sendRawMessageWithConfirmation(this.prepareExternalMsg(config).toCell().toBase64(), this.getAddress());
    }

    public Message prepareExternalMsg(WalletV2R1Config config) {
        Cell body = this.createTransferBody(config);
        return MsgUtils.createExternalMessageWithSignedBody(this.keyPair, this.getAddress(), null, body);
    }

    public ExtMessageInfo deploy() {
        return this.tonlib.sendRawMessage(this.prepareDeployMsg().toCell().toBase64());
    }

    public ExtMessageInfo deploy(byte[] signedBody) {
        return this.tonlib.sendRawMessage(this.prepareDeployMsg(signedBody).toCell().toBase64());
    }

    public Message prepareDeployMsg(byte[] signedBodyHash) {
        Cell body = this.createDeployMessage();
        return Message.builder().info((CommonMsgInfo)ExternalMessageInInfo.builder().dstAddr((MsgAddressInt)this.getAddressIntStd()).build()).init(this.getStateInit()).body(CellBuilder.beginCell().storeBytes(signedBodyHash).storeCell(body).endCell()).build();
    }

    public ExtMessageInfo send(WalletV2R1Config config, byte[] signedBodyHash) {
        return this.tonlib.sendRawMessage(this.prepareExternalMsg(config, signedBodyHash).toCell().toBase64());
    }

    public Message prepareExternalMsg(WalletV2R1Config config, byte[] signedBodyHash) {
        Cell body = this.createTransferBody(config);
        return MsgUtils.createExternalMessageWithSignedBody(signedBodyHash, this.getAddress(), null, body);
    }

    @Override
    public Message prepareDeployMsg() {
        Cell body = this.createDeployMessage();
        return Message.builder().info((CommonMsgInfo)ExternalMessageInInfo.builder().dstAddr((MsgAddressInt)this.getAddressIntStd()).build()).init(this.getStateInit()).body(CellBuilder.beginCell().storeBytes(Utils.signData((byte[])this.keyPair.getPublicKey(), (byte[])this.keyPair.getSecretKey(), (byte[])body.hash())).storeCell(body).endCell()).build();
    }

    public Cell createInternalSignedBody(WalletV2R1Config config) {
        Cell body = this.createTransferBody(config);
        byte[] signature = Utils.signData((byte[])this.keyPair.getPublicKey(), (byte[])this.keyPair.getSecretKey(), (byte[])body.hash());
        return CellBuilder.beginCell().storeCell(body).storeBytes(signature).endCell();
    }

    public Message prepareInternalMsg(WalletV2R1Config config) {
        Cell body = this.createInternalSignedBody(config);
        return Message.builder().info((CommonMsgInfo)InternalMessageInfo.builder().srcAddr((MsgAddressInt)this.getAddressIntStd()).dstAddr((MsgAddressInt)this.getAddressIntStd()).value(CurrencyCollection.builder().coins(config.getAmount()).build()).build()).body(body).build();
    }

    public MessageRelaxed prepareInternalMsgRelaxed(WalletV2R1Config config) {
        Cell body = this.createInternalSignedBody(config);
        return MessageRelaxed.builder().info((CommonMsgInfoRelaxed)InternalMessageInfoRelaxed.builder().dstAddr((MsgAddressInt)this.getAddressIntStd()).value(CurrencyCollection.builder().coins(config.getAmount()).build()).build()).body(body).build();
    }

    WalletV2R1(TweetNaclFast.Signature.KeyPair keyPair, long initialSeqno, byte[] publicKey, Tonlib tonlib, long wc) {
        this.keyPair = keyPair;
        this.initialSeqno = initialSeqno;
        this.publicKey = publicKey;
        this.tonlib = tonlib;
        this.wc = wc;
    }

    public TweetNaclFast.Signature.KeyPair getKeyPair() {
        return this.keyPair;
    }

    public long getInitialSeqno() {
        return this.initialSeqno;
    }

    public byte[] getPublicKey() {
        return this.publicKey;
    }

    public long getWc() {
        return this.wc;
    }

    private static class CustomWalletV2R1Builder
    extends WalletV2R1Builder {
        private CustomWalletV2R1Builder() {
        }

        @Override
        public WalletV2R1 build() {
            if (Objects.isNull(this.publicKey) && Objects.isNull(this.keyPair)) {
                this.keyPair = Utils.generateSignatureKeyPair();
            }
            return super.build();
        }
    }

    public static class WalletV2R1Builder {
        private TweetNaclFast.Signature.KeyPair keyPair;
        private long initialSeqno;
        private byte[] publicKey;
        private Tonlib tonlib;
        private long wc;

        WalletV2R1Builder() {
        }

        public WalletV2R1Builder keyPair(TweetNaclFast.Signature.KeyPair keyPair) {
            this.keyPair = keyPair;
            return this;
        }

        public WalletV2R1Builder initialSeqno(long initialSeqno) {
            this.initialSeqno = initialSeqno;
            return this;
        }

        public WalletV2R1Builder publicKey(byte[] publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        public WalletV2R1Builder tonlib(Tonlib tonlib) {
            this.tonlib = tonlib;
            return this;
        }

        public WalletV2R1Builder wc(long wc) {
            this.wc = wc;
            return this;
        }

        public WalletV2R1 build() {
            return new WalletV2R1(this.keyPair, this.initialSeqno, this.publicKey, this.tonlib, this.wc);
        }

        public String toString() {
            return "WalletV2R1.WalletV2R1Builder(keyPair=" + String.valueOf(this.keyPair) + ", initialSeqno=" + this.initialSeqno + ", publicKey=" + Arrays.toString(this.publicKey) + ", tonlib=" + String.valueOf(this.tonlib) + ", wc=" + this.wc + ")";
        }
    }
}

