/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.smartcontract.types;

import java.util.Arrays;

public class MultisigSignature {
    long pubKeyPosition;
    byte[] signature;

    MultisigSignature(long pubKeyPosition, byte[] signature) {
        this.pubKeyPosition = pubKeyPosition;
        this.signature = signature;
    }

    public static MultisigSignatureBuilder builder() {
        return new MultisigSignatureBuilder();
    }

    public long getPubKeyPosition() {
        return this.pubKeyPosition;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public String toString() {
        return "MultisigSignature(pubKeyPosition=" + this.getPubKeyPosition() + ", signature=" + Arrays.toString(this.getSignature()) + ")";
    }

    public static class MultisigSignatureBuilder {
        private long pubKeyPosition;
        private byte[] signature;

        MultisigSignatureBuilder() {
        }

        public MultisigSignatureBuilder pubKeyPosition(long pubKeyPosition) {
            this.pubKeyPosition = pubKeyPosition;
            return this;
        }

        public MultisigSignatureBuilder signature(byte[] signature) {
            this.signature = signature;
            return this;
        }

        public MultisigSignature build() {
            return new MultisigSignature(this.pubKeyPosition, this.signature);
        }

        public String toString() {
            return "MultisigSignature.MultisigSignatureBuilder(pubKeyPosition=" + this.pubKeyPosition + ", signature=" + Arrays.toString(this.signature) + ")";
        }
    }
}

