/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.smartcontract.payments;

import com.iwebpp.crypto.TweetNaclFast;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Objects;
import org.ton.java.address.Address;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.mnemonic.Ed25519;
import org.ton.java.smartcontract.payments.ClosingConfig;
import org.ton.java.smartcontract.payments.PaymentsUtils;
import org.ton.java.smartcontract.payments.Signature;
import org.ton.java.smartcontract.token.nft.NftUtils;
import org.ton.java.smartcontract.types.ChannelConfig;
import org.ton.java.smartcontract.types.ChannelData;
import org.ton.java.smartcontract.types.ChannelState;
import org.ton.java.smartcontract.types.WalletCodes;
import org.ton.java.smartcontract.wallet.Contract;
import org.ton.java.tonlib.Tonlib;
import org.ton.java.tonlib.types.RunResult;
import org.ton.java.tonlib.types.TvmStackEntryCell;
import org.ton.java.tonlib.types.TvmStackEntryList;
import org.ton.java.tonlib.types.TvmStackEntryNumber;
import org.ton.java.tonlib.types.TvmStackEntrySlice;
import org.ton.java.tonlib.types.TvmStackEntryTuple;
import org.ton.java.utils.Utils;

public class PaymentChannel
implements Contract {
    public static final long STATE_UNINITED = 0L;
    public static final long STATE_OPEN = 1L;
    public static final long STATE_CLOSURE_STARTED = 2L;
    public static final long STATE_SETTLING_CONDITIONALS = 3L;
    public static final long STATE_AWAITING_FINALIZATION = 4L;
    boolean isA;
    BigInteger channelId;
    TweetNaclFast.Signature.KeyPair myKeyPair;
    byte[] hisPublicKey;
    byte[] publicKeyA;
    byte[] publicKeyB;
    BigInteger initBalanceA;
    BigInteger initBalanceB;
    Address addressA;
    Address addressB;
    BigInteger excessFee;
    ChannelConfig channelConfig;
    ClosingConfig closingChannelConfig;
    private Tonlib tonlib;
    private long wc;

    public static PaymentChannelBuilder builder() {
        return new CustomPaymentChannelBuilder();
    }

    @Override
    public Tonlib getTonlib() {
        return this.tonlib;
    }

    @Override
    public void setTonlib(Tonlib pTonlib) {
        this.tonlib = pTonlib;
    }

    @Override
    public long getWorkchain() {
        return this.wc;
    }

    @Override
    public String getName() {
        return "payments";
    }

    @Override
    public Cell createDataCell() {
        CellBuilder cell = CellBuilder.beginCell();
        cell.storeBit(Boolean.valueOf(false));
        cell.storeCoins(BigInteger.ZERO);
        cell.storeCoins(BigInteger.ZERO);
        cell.storeBytes(this.publicKeyA);
        cell.storeBytes(this.publicKeyB);
        cell.storeUint(this.channelConfig.getChannelId(), 128);
        CellBuilder closingConfig = CellBuilder.beginCell();
        if (Objects.nonNull(this.closingChannelConfig)) {
            closingConfig.storeUint(this.closingChannelConfig.getQuarantineDuration(), 32);
            closingConfig.storeCoins(Objects.isNull(this.closingChannelConfig.getMisbehaviorFine()) ? BigInteger.ZERO : this.closingChannelConfig.getMisbehaviorFine());
            closingConfig.storeUint(this.closingChannelConfig.getConditionalCloseDuration(), 32);
        } else {
            closingConfig.storeUint(0, 32);
            closingConfig.storeCoins(BigInteger.ZERO);
            closingConfig.storeUint(0, 32);
        }
        cell.storeRef(closingConfig.endCell());
        cell.storeUint(0, 32);
        cell.storeUint(0, 32);
        cell.storeBit(Boolean.valueOf(false));
        CellBuilder paymentConfig = CellBuilder.beginCell().storeCoins(Objects.isNull(this.excessFee) ? BigInteger.ZERO : this.excessFee).storeAddress(this.channelConfig.getAddressA()).storeAddress(this.channelConfig.getAddressB());
        cell.storeRef(paymentConfig.endCell());
        return cell.endCell();
    }

    @Override
    public Cell createCodeCell() {
        return CellBuilder.beginCell().fromBoc(WalletCodes.payments.getValue()).endCell();
    }

    public Signature createCooperativeCommit(byte[] hisSignature, BigInteger seqnoA, BigInteger seqnoB) {
        if (hisSignature.length != 0) {
            hisSignature = new byte[64];
        }
        return this.createTwoSignature(1433884798L, hisSignature, PaymentsUtils.createCooperativeCommitBody(this.channelConfig.getChannelId(), seqnoA, seqnoB));
    }

    public Signature createCooperativeCloseChannel(byte[] hisSignature, ChannelState channelState) {
        if (Objects.isNull(hisSignature)) {
            hisSignature = new byte[64];
        }
        return this.createTwoSignature(1433884798L, hisSignature, PaymentsUtils.createCooperativeCloseChannelBody(this.channelConfig.getChannelId(), channelState.getBalanceA(), channelState.getBalanceB(), channelState.getSeqnoA(), channelState.getSeqnoB()));
    }

    public Signature createStartUncooperativeClose(Cell signedSemiChannelStateA, Cell signedSemiChannelStateB) {
        return this.createOneSignature(521476815L, PaymentsUtils.createStartUncooperativeCloseBody(this.channelConfig.getChannelId(), signedSemiChannelStateA, signedSemiChannelStateB));
    }

    public Signature createChallengeQuarantinedState(Cell signedSemiChannelStateA, Cell signedSemiChannelStateB) {
        return this.createOneSignature(143567410L, PaymentsUtils.createChallengeQuarantinedStateBody(this.channelConfig.getChannelId(), signedSemiChannelStateA, signedSemiChannelStateB));
    }

    public Signature createSettleConditionals(Cell conditionalsToSettle) {
        return this.createOneSignature(1727459433L, PaymentsUtils.createSettleConditionalsBody(this.channelConfig.getChannelId(), conditionalsToSettle));
    }

    public Cell createInitChannel(BigInteger balanceA, BigInteger balanceB) {
        return this.createOneSignature(235282626L, PaymentsUtils.createInitChannelBody(this.channelConfig.getChannelId(), balanceA, balanceB)).getCell();
    }

    public Signature createOneSignature(long op, Cell cellForSigning) {
        byte[] signature = new TweetNaclFast.Signature(this.myKeyPair.getPublicKey(), this.myKeyPair.getSecretKey()).detached(cellForSigning.hash());
        Cell cell = PaymentsUtils.createOneSignature(op, this.isA, signature, cellForSigning);
        return Signature.builder().cell(cell).signature(signature).build();
    }

    public Signature createTwoSignature(long op, byte[] hisSignature, Cell cellForSigning) {
        byte[] signature = new TweetNaclFast.Signature(this.myKeyPair.getPublicKey(), this.myKeyPair.getSecretKey()).detached(cellForSigning.hash());
        byte[] signatureA = this.isA ? signature : hisSignature;
        byte[] signatureB = !this.isA ? signature : hisSignature;
        Cell cell = PaymentsUtils.createTwoSignature(op, signatureA, signatureB, cellForSigning);
        return Signature.builder().cell(cell).signature(signature).build();
    }

    public Signature createSignedSemiChannelState(BigInteger mySeqNo, BigInteger mySentCoins, BigInteger hisSeqno, BigInteger hisSentCoins) {
        Cell state = PaymentsUtils.createSemiChannelState(this.channelConfig.getChannelId(), PaymentsUtils.createSemiChannelBody(mySeqNo, mySentCoins, null), Objects.isNull(hisSeqno) ? null : PaymentsUtils.createSemiChannelBody(hisSeqno, hisSentCoins, null));
        byte[] signature = new TweetNaclFast.Signature(this.myKeyPair.getPublicKey(), this.myKeyPair.getSecretKey()).detached(state.hash());
        Cell cell = PaymentsUtils.createSignedSemiChannelState(signature, state);
        return Signature.builder().signature(signature).cell(cell).build();
    }

    public byte[] signState(ChannelState channelState) {
        BigInteger mySeqno = this.isA ? channelState.getSeqnoA() : channelState.getSeqnoB();
        BigInteger hisSeqno = !this.isA ? channelState.getSeqnoA() : channelState.getSeqnoB();
        BigInteger sentCoinsA = this.channelConfig.getInitBalanceA().compareTo(channelState.getBalanceA()) > 0 ? this.channelConfig.getInitBalanceA().subtract(channelState.getBalanceA()) : BigInteger.ZERO;
        BigInteger sentCoinsB = this.channelConfig.getInitBalanceB().compareTo(channelState.getBalanceB()) > 0 ? this.channelConfig.getInitBalanceB().subtract(channelState.getBalanceB()) : BigInteger.ZERO;
        BigInteger mySentCoins = this.isA ? sentCoinsA : sentCoinsB;
        BigInteger hisSentCoins = !this.isA ? sentCoinsA : sentCoinsB;
        Signature s = this.createSignedSemiChannelState(mySeqno, mySentCoins, hisSeqno, hisSentCoins);
        return s.signature;
    }

    public boolean verifyState(ChannelState channelState, byte[] hisSignature) {
        BigInteger mySeqno = !this.isA ? channelState.getSeqnoA() : channelState.getSeqnoB();
        BigInteger hisSeqno = this.isA ? channelState.getSeqnoA() : channelState.getSeqnoB();
        BigInteger sentCoinsA = this.channelConfig.getInitBalanceA().compareTo(channelState.getBalanceA()) > 0 ? this.channelConfig.getInitBalanceA().subtract(channelState.getBalanceA()) : BigInteger.ZERO;
        BigInteger sentCoinsB = this.channelConfig.getInitBalanceB().compareTo(channelState.getBalanceB()) > 0 ? this.channelConfig.getInitBalanceB().subtract(channelState.getBalanceB()) : BigInteger.ZERO;
        BigInteger mySentCoins = !this.isA ? sentCoinsA : sentCoinsB;
        BigInteger hisSentCoins = this.isA ? sentCoinsA : sentCoinsB;
        Cell state = PaymentsUtils.createSemiChannelState(this.channelConfig.getChannelId(), PaymentsUtils.createSemiChannelBody(mySeqno, mySentCoins, null), Objects.isNull(hisSeqno) ? null : PaymentsUtils.createSemiChannelBody(hisSeqno, hisSentCoins, null));
        return Ed25519.verify((byte[])(this.isA ? this.publicKeyB : this.publicKeyA), (byte[])state.hash(), (byte[])hisSignature);
    }

    public byte[] signClose(ChannelState channelState) {
        Signature s = this.createCooperativeCloseChannel(null, channelState);
        return s.signature;
    }

    public boolean verifyClose(ChannelState channelState, byte[] hisSignature) {
        Cell cell = PaymentsUtils.createCooperativeCloseChannelBody(this.channelConfig.getChannelId(), channelState.getBalanceA(), channelState.getBalanceB(), channelState.getSeqnoA(), channelState.getSeqnoB());
        return Ed25519.verify((byte[])(this.isA ? this.publicKeyB : this.publicKeyA), (byte[])cell.hash(), (byte[])hisSignature);
    }

    public Cell createFinishUncooperativeClose() {
        return PaymentsUtils.createFinishUncooperativeClose();
    }

    public BigInteger getChannelState() {
        RunResult result = this.tonlib.runMethod(this.getAddress(), "get_channel_state");
        if (result.getExit_code() != 0L) {
            throw new Error("method get_channel_state, returned an exit code " + result.getExit_code());
        }
        TvmStackEntryNumber addr = (TvmStackEntryNumber)result.getStack().get(0);
        return addr.getNumber();
    }

    public ChannelData getData() {
        RunResult result = this.tonlib.runMethod(this.getAddress(), "get_channel_data");
        if (result.getExit_code() != 0L) {
            throw new Error("method get_channel_data, returned an exit code " + result.getExit_code());
        }
        TvmStackEntryNumber stateNumber = (TvmStackEntryNumber)result.getStack().get(0);
        TvmStackEntryTuple balanceTuple = (TvmStackEntryTuple)result.getStack().get(1);
        TvmStackEntryNumber balanceA = (TvmStackEntryNumber)balanceTuple.getTuple().getElements().get(0);
        TvmStackEntryNumber balanceB = (TvmStackEntryNumber)balanceTuple.getTuple().getElements().get(1);
        TvmStackEntryTuple keyTuple = (TvmStackEntryTuple)result.getStack().get(2);
        TvmStackEntryNumber publicKeyA = (TvmStackEntryNumber)keyTuple.getTuple().getElements().get(0);
        TvmStackEntryNumber publicKeyB = (TvmStackEntryNumber)keyTuple.getTuple().getElements().get(1);
        TvmStackEntryNumber channelIdNumber = (TvmStackEntryNumber)result.getStack().get(3);
        TvmStackEntryTuple closureConfigTuple = (TvmStackEntryTuple)result.getStack().get(4);
        TvmStackEntryNumber quarantineDuration = (TvmStackEntryNumber)closureConfigTuple.getTuple().getElements().get(0);
        TvmStackEntryNumber misbehaviourFine = (TvmStackEntryNumber)closureConfigTuple.getTuple().getElements().get(1);
        TvmStackEntryNumber conditionalCloseDuration = (TvmStackEntryNumber)closureConfigTuple.getTuple().getElements().get(2);
        TvmStackEntryTuple commitedSeqnoTuple = (TvmStackEntryTuple)result.getStack().get(5);
        TvmStackEntryNumber seqnoA = (TvmStackEntryNumber)commitedSeqnoTuple.getTuple().getElements().get(0);
        TvmStackEntryNumber seqnoB = (TvmStackEntryNumber)commitedSeqnoTuple.getTuple().getElements().get(1);
        Cell quarantine = null;
        TvmStackEntryList quarantineList = (TvmStackEntryList)result.getStack().get(6);
        for (Object o : quarantineList.getList().getElements()) {
            TvmStackEntryCell t = (TvmStackEntryCell)o;
            quarantine = CellBuilder.beginCell().fromBoc(t.getCell().getBytes()).endCell();
        }
        TvmStackEntryTuple trippleTuple = (TvmStackEntryTuple)result.getStack().get(7);
        TvmStackEntryNumber excessFee = (TvmStackEntryNumber)trippleTuple.getTuple().getElements().get(0);
        TvmStackEntrySlice addressACell = (TvmStackEntrySlice)trippleTuple.getTuple().getElements().get(1);
        Address addressA = NftUtils.parseAddress(CellBuilder.beginCell().fromBoc(Utils.base64ToBytes((String)addressACell.getSlice().getBytes())).endCell());
        TvmStackEntrySlice AddressBCell = (TvmStackEntrySlice)trippleTuple.getTuple().getElements().get(2);
        Address addressB = NftUtils.parseAddress(CellBuilder.beginCell().fromBoc(Utils.base64ToBytes((String)AddressBCell.getSlice().getBytes())).endCell());
        return ChannelData.builder().state(stateNumber.getNumber().longValue()).balanceA(balanceA.getNumber()).balanceB(balanceB.getNumber()).publicKeyA(publicKeyA.getNumber().toByteArray()).publicKeyB(publicKeyB.getNumber().toByteArray()).channelId(channelIdNumber.getNumber()).quarantineDuration(quarantineDuration.getNumber().longValue()).misbehaviorFine(misbehaviourFine.getNumber()).conditionalCloseDuration(conditionalCloseDuration.getNumber().longValue()).seqnoA(seqnoA.getNumber()).seqnoB(seqnoB.getNumber()).quarantine(quarantine).excessFee(excessFee.getNumber()).addressA(addressA).addressB(addressB).build();
    }

    PaymentChannel(boolean isA, BigInteger channelId, TweetNaclFast.Signature.KeyPair myKeyPair, byte[] hisPublicKey, byte[] publicKeyA, byte[] publicKeyB, BigInteger initBalanceA, BigInteger initBalanceB, Address addressA, Address addressB, BigInteger excessFee, ChannelConfig channelConfig, ClosingConfig closingChannelConfig, Tonlib tonlib, long wc) {
        this.isA = isA;
        this.channelId = channelId;
        this.myKeyPair = myKeyPair;
        this.hisPublicKey = hisPublicKey;
        this.publicKeyA = publicKeyA;
        this.publicKeyB = publicKeyB;
        this.initBalanceA = initBalanceA;
        this.initBalanceB = initBalanceB;
        this.addressA = addressA;
        this.addressB = addressB;
        this.excessFee = excessFee;
        this.channelConfig = channelConfig;
        this.closingChannelConfig = closingChannelConfig;
        this.tonlib = tonlib;
        this.wc = wc;
    }

    public boolean isA() {
        return this.isA;
    }

    public BigInteger getChannelId() {
        return this.channelId;
    }

    public TweetNaclFast.Signature.KeyPair getMyKeyPair() {
        return this.myKeyPair;
    }

    public byte[] getHisPublicKey() {
        return this.hisPublicKey;
    }

    public byte[] getPublicKeyA() {
        return this.publicKeyA;
    }

    public byte[] getPublicKeyB() {
        return this.publicKeyB;
    }

    public BigInteger getInitBalanceA() {
        return this.initBalanceA;
    }

    public BigInteger getInitBalanceB() {
        return this.initBalanceB;
    }

    public Address getAddressA() {
        return this.addressA;
    }

    public Address getAddressB() {
        return this.addressB;
    }

    public BigInteger getExcessFee() {
        return this.excessFee;
    }

    public ChannelConfig getChannelConfig() {
        return this.channelConfig;
    }

    public ClosingConfig getClosingChannelConfig() {
        return this.closingChannelConfig;
    }

    public long getWc() {
        return this.wc;
    }

    private static class CustomPaymentChannelBuilder
    extends PaymentChannelBuilder {
        private CustomPaymentChannelBuilder() {
        }

        @Override
        public PaymentChannel build() {
            this.publicKeyA = this.isA ? this.myKeyPair.getPublicKey() : this.hisPublicKey;
            this.publicKeyB = !this.isA ? this.myKeyPair.getPublicKey() : this.hisPublicKey;
            return super.build();
        }
    }

    public static class PaymentChannelBuilder {
        private boolean isA;
        private BigInteger channelId;
        private TweetNaclFast.Signature.KeyPair myKeyPair;
        private byte[] hisPublicKey;
        private byte[] publicKeyA;
        private byte[] publicKeyB;
        private BigInteger initBalanceA;
        private BigInteger initBalanceB;
        private Address addressA;
        private Address addressB;
        private BigInteger excessFee;
        private ChannelConfig channelConfig;
        private ClosingConfig closingChannelConfig;
        private Tonlib tonlib;
        private long wc;

        PaymentChannelBuilder() {
        }

        public PaymentChannelBuilder isA(boolean isA) {
            this.isA = isA;
            return this;
        }

        public PaymentChannelBuilder channelId(BigInteger channelId) {
            this.channelId = channelId;
            return this;
        }

        public PaymentChannelBuilder myKeyPair(TweetNaclFast.Signature.KeyPair myKeyPair) {
            this.myKeyPair = myKeyPair;
            return this;
        }

        public PaymentChannelBuilder hisPublicKey(byte[] hisPublicKey) {
            this.hisPublicKey = hisPublicKey;
            return this;
        }

        public PaymentChannelBuilder publicKeyA(byte[] publicKeyA) {
            this.publicKeyA = publicKeyA;
            return this;
        }

        public PaymentChannelBuilder publicKeyB(byte[] publicKeyB) {
            this.publicKeyB = publicKeyB;
            return this;
        }

        public PaymentChannelBuilder initBalanceA(BigInteger initBalanceA) {
            this.initBalanceA = initBalanceA;
            return this;
        }

        public PaymentChannelBuilder initBalanceB(BigInteger initBalanceB) {
            this.initBalanceB = initBalanceB;
            return this;
        }

        public PaymentChannelBuilder addressA(Address addressA) {
            this.addressA = addressA;
            return this;
        }

        public PaymentChannelBuilder addressB(Address addressB) {
            this.addressB = addressB;
            return this;
        }

        public PaymentChannelBuilder excessFee(BigInteger excessFee) {
            this.excessFee = excessFee;
            return this;
        }

        public PaymentChannelBuilder channelConfig(ChannelConfig channelConfig) {
            this.channelConfig = channelConfig;
            return this;
        }

        public PaymentChannelBuilder closingChannelConfig(ClosingConfig closingChannelConfig) {
            this.closingChannelConfig = closingChannelConfig;
            return this;
        }

        public PaymentChannelBuilder tonlib(Tonlib tonlib) {
            this.tonlib = tonlib;
            return this;
        }

        public PaymentChannelBuilder wc(long wc) {
            this.wc = wc;
            return this;
        }

        public PaymentChannel build() {
            return new PaymentChannel(this.isA, this.channelId, this.myKeyPair, this.hisPublicKey, this.publicKeyA, this.publicKeyB, this.initBalanceA, this.initBalanceB, this.addressA, this.addressB, this.excessFee, this.channelConfig, this.closingChannelConfig, this.tonlib, this.wc);
        }

        public String toString() {
            return "PaymentChannel.PaymentChannelBuilder(isA=" + this.isA + ", channelId=" + String.valueOf(this.channelId) + ", myKeyPair=" + String.valueOf(this.myKeyPair) + ", hisPublicKey=" + Arrays.toString(this.hisPublicKey) + ", publicKeyA=" + Arrays.toString(this.publicKeyA) + ", publicKeyB=" + Arrays.toString(this.publicKeyB) + ", initBalanceA=" + String.valueOf(this.initBalanceA) + ", initBalanceB=" + String.valueOf(this.initBalanceB) + ", addressA=" + String.valueOf(this.addressA) + ", addressB=" + String.valueOf(this.addressB) + ", excessFee=" + String.valueOf(this.excessFee) + ", channelConfig=" + String.valueOf(this.channelConfig) + ", closingChannelConfig=" + String.valueOf(this.closingChannelConfig) + ", tonlib=" + String.valueOf(this.tonlib) + ", wc=" + this.wc + ")";
        }
    }
}

