/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.smartcontract.payments;

import java.math.BigInteger;

public class ClosingConfig {
    long quarantineDuration;
    BigInteger misbehaviorFine;
    long conditionalCloseDuration;

    ClosingConfig(long quarantineDuration, BigInteger misbehaviorFine, long conditionalCloseDuration) {
        this.quarantineDuration = quarantineDuration;
        this.misbehaviorFine = misbehaviorFine;
        this.conditionalCloseDuration = conditionalCloseDuration;
    }

    public static ClosingConfigBuilder builder() {
        return new ClosingConfigBuilder();
    }

    public long getQuarantineDuration() {
        return this.quarantineDuration;
    }

    public BigInteger getMisbehaviorFine() {
        return this.misbehaviorFine;
    }

    public long getConditionalCloseDuration() {
        return this.conditionalCloseDuration;
    }

    public String toString() {
        return "ClosingConfig(quarantineDuration=" + this.getQuarantineDuration() + ", misbehaviorFine=" + String.valueOf(this.getMisbehaviorFine()) + ", conditionalCloseDuration=" + this.getConditionalCloseDuration() + ")";
    }

    public static class ClosingConfigBuilder {
        private long quarantineDuration;
        private BigInteger misbehaviorFine;
        private long conditionalCloseDuration;

        ClosingConfigBuilder() {
        }

        public ClosingConfigBuilder quarantineDuration(long quarantineDuration) {
            this.quarantineDuration = quarantineDuration;
            return this;
        }

        public ClosingConfigBuilder misbehaviorFine(BigInteger misbehaviorFine) {
            this.misbehaviorFine = misbehaviorFine;
            return this;
        }

        public ClosingConfigBuilder conditionalCloseDuration(long conditionalCloseDuration) {
            this.conditionalCloseDuration = conditionalCloseDuration;
            return this;
        }

        public ClosingConfig build() {
            return new ClosingConfig(this.quarantineDuration, this.misbehaviorFine, this.conditionalCloseDuration);
        }

        public String toString() {
            return "ClosingConfig.ClosingConfigBuilder(quarantineDuration=" + this.quarantineDuration + ", misbehaviorFine=" + String.valueOf(this.misbehaviorFine) + ", conditionalCloseDuration=" + this.conditionalCloseDuration + ")";
        }
    }
}

