/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.fift;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import net.lingala.zip4j.ZipFile;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ton.java.utils.Utils;

public class FiftRunner {
    private static final Logger log = LoggerFactory.getLogger(FiftRunner.class);
    String fiftAsmLibraryPath;
    String fiftSmartcontLibraryPath;
    public String fiftExecutablePath;
    private Boolean printInfo;
    public static String fiftExecutable = "";

    public static FiftRunnerBuilder builder() {
        return new CustomFiftRunnerBuilder();
    }

    public String run(String workdir, String ... params) {
        Object[] withInclude = Utils.getOS() == Utils.OS.WINDOWS ? new String[]{"-I", "\"" + this.fiftAsmLibraryPath + "@" + this.fiftSmartcontLibraryPath + "\""} : new String[]{"-I", this.fiftAsmLibraryPath + ":" + this.fiftSmartcontLibraryPath};
        String[] all = (String[])ArrayUtils.addAll((Object[])withInclude, (Object[])params);
        Pair<Process, String> result = this.execute(fiftExecutable, workdir, all);
        if (Objects.nonNull(result)) {
            try {
                return (String)result.getRight();
            }
            catch (Exception e) {
                log.error("executeFift error " + e.getMessage());
                return null;
            }
        }
        return null;
    }

    public String runStdIn(String workdir, String stdin) {
        String withInclude = Utils.getOS() == Utils.OS.WINDOWS ? "-I\"" + this.fiftAsmLibraryPath + "@" + this.fiftSmartcontLibraryPath + "\" -s -" : "-I" + this.fiftAsmLibraryPath + ":" + this.fiftSmartcontLibraryPath + " -s -";
        Pair<Process, String> result = this.executeStdIn(fiftExecutable, workdir, stdin, withInclude);
        if (Objects.nonNull(result)) {
            try {
                return (String)result.getRight();
            }
            catch (Exception e) {
                log.error("executeFift error " + e.getMessage());
                return null;
            }
        }
        return null;
    }

    public String getLibsPath() {
        if (Utils.getOS() == Utils.OS.WINDOWS) {
            return this.fiftAsmLibraryPath + "@" + this.fiftSmartcontLibraryPath;
        }
        return this.fiftAsmLibraryPath + ":" + this.fiftSmartcontLibraryPath;
    }

    public String getFiftPath() {
        return Utils.detectAbsolutePath((String)"fift", (boolean)false);
    }

    public Pair<Process, String> execute(String pathToBinary, String workDir, String ... command) {
        Object[] withBinaryCommand = new String[]{pathToBinary};
        withBinaryCommand = (String[])ArrayUtils.addAll((Object[])withBinaryCommand, (Object[])command);
        try {
            if (this.printInfo.booleanValue()) {
                log.info("execute: {}", (Object)String.join((CharSequence)" ", (CharSequence[])withBinaryCommand));
            }
            ProcessBuilder pb = new ProcessBuilder((String[])withBinaryCommand).redirectErrorStream(true);
            pb.directory(new File(workDir));
            Process p = pb.start();
            p.waitFor(1L, TimeUnit.SECONDS);
            String resultInput = IOUtils.toString((InputStream)p.getInputStream(), (Charset)Charset.defaultCharset());
            p.getInputStream().close();
            p.getErrorStream().close();
            p.getOutputStream().close();
            if (p.exitValue() == 2 || p.exitValue() == 0) {
                return Pair.of((Object)p, (Object)resultInput);
            }
            log.error("exit value {}", (Object)p.exitValue());
            log.error(resultInput);
            throw new Exception("Error running " + Arrays.toString(withBinaryCommand));
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return null;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public Pair<Process, String> executeStdIn(String pathToBinary, String workDir, String stdin, String include) {
        try {
            ProcessBuilder pb;
            String cmd = "";
            if (Utils.getOS() == Utils.OS.WINDOWS) {
                pb = new ProcessBuilder("powershell", "-c", "'" + stdin + "' | " + pathToBinary + " " + include).redirectErrorStream(true);
                cmd = String.join((CharSequence)" ", "powershell", "-c", "'" + stdin + "' | " + pathToBinary + " " + include);
            } else {
                pb = new ProcessBuilder("/bin/bash", "-c", "echo", "\"" + stdin + "\" | " + pathToBinary + " " + include).redirectErrorStream(true);
                cmd = String.join((CharSequence)" ", "/bin/bash", "-c", "\"echo", "'", stdin, "'|", pathToBinary + " " + include + "\"");
            }
            if (this.printInfo.booleanValue()) {
                log.info("execute: {}", (Object)cmd);
            }
            pb.directory(new File(workDir));
            Process p = pb.start();
            p.waitFor(1L, TimeUnit.SECONDS);
            String resultInput = IOUtils.toString((InputStream)p.getInputStream(), (Charset)Charset.defaultCharset());
            p.getInputStream().close();
            p.getErrorStream().close();
            p.getOutputStream().close();
            if (p.exitValue() == 2 || p.exitValue() == 0) {
                return Pair.of((Object)p, (Object)resultInput);
            }
            log.error("exit value {}", (Object)p.exitValue());
            log.error(resultInput);
            throw new Exception("Error running " + cmd);
        }
        catch (IOException e) {
            log.info(e.getMessage());
            return null;
        }
        catch (Exception e) {
            log.info(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    FiftRunner(String fiftAsmLibraryPath, String fiftSmartcontLibraryPath, String fiftExecutablePath, Boolean printInfo) {
        this.fiftAsmLibraryPath = fiftAsmLibraryPath;
        this.fiftSmartcontLibraryPath = fiftSmartcontLibraryPath;
        this.fiftExecutablePath = fiftExecutablePath;
        this.printInfo = printInfo;
    }

    private static class CustomFiftRunnerBuilder
    extends FiftRunnerBuilder {
        private String fiftAbsolutePath;

        private CustomFiftRunnerBuilder() {
        }

        @Override
        public FiftRunner build() {
            if (Objects.isNull(this.printInfo)) {
                this.printInfo = true;
            }
            if (StringUtils.isEmpty((CharSequence)this.fiftExecutablePath)) {
                if (this.printInfo.booleanValue()) {
                    log.info("Checking if Fift is installed...");
                }
                String errorMsg = "You can specify full path via FiftRunner.builder().fiftExecutablePath(Utils.getFiftGithubUrl()).\nOr make sure you have Fift installed. See https://github.com/ton-blockchain/packages for instructions.";
                try {
                    ProcessBuilder pb = new ProcessBuilder("fift", "-h").redirectErrorStream(true);
                    Process p = pb.start();
                    p.waitFor(1L, TimeUnit.SECONDS);
                    if (p.exitValue() != 2) {
                        throw new Error("Cannot execute simple Fift command.\n" + errorMsg);
                    }
                    this.fiftAbsolutePath = Utils.detectAbsolutePath((String)"fift", (boolean)false);
                    if (this.printInfo.booleanValue()) {
                        log.info("Fift found at " + this.fiftAbsolutePath);
                    }
                    fiftExecutable = "fift";
                }
                catch (Exception e) {
                    throw new Error("Cannot execute simple Fift command.\n" + errorMsg);
                }
            }
            if (this.fiftExecutablePath.contains("http") && this.fiftExecutablePath.contains("://")) {
                try {
                    String smartcont = StringUtils.substringBeforeLast((String)this.fiftExecutablePath, (String)"/") + "/smartcont_lib.zip";
                    File tmpFileSmartcont = new File(System.getProperty("user.dir") + "/smartcont/stdlib.fc");
                    if (!tmpFileSmartcont.exists()) {
                        String smartcontPath = Utils.getLocalOrDownload((String)smartcont);
                        ZipFile zipFile = new ZipFile(smartcontPath);
                        zipFile.extractAll(new File(smartcontPath).getParent());
                        Files.delete(Paths.get(smartcontPath, new String[0]));
                    }
                }
                catch (Exception e) {
                    log.error("cannot download smartcont_lib.zip");
                }
            }
            this.fiftExecutablePath = Utils.getLocalOrDownload((String)this.fiftExecutablePath);
            if (StringUtils.isEmpty((CharSequence)this.fiftAsmLibraryPath)) {
                this.fiftAsmLibraryPath = new File(this.fiftExecutablePath).getParent() + "/lib";
            }
            if (StringUtils.isEmpty((CharSequence)this.fiftSmartcontLibraryPath)) {
                this.fiftSmartcontLibraryPath = new File(this.fiftExecutablePath).getParent() + "/smartcont";
            }
            if (this.printInfo.booleanValue()) {
                log.info("Using {}", (Object)this.fiftExecutablePath);
            }
            fiftExecutable = this.fiftExecutablePath;
            if (Objects.isNull(this.fiftAbsolutePath)) {
                this.fiftAbsolutePath = this.fiftExecutablePath;
            }
            if (StringUtils.isEmpty((CharSequence)this.fiftAsmLibraryPath)) {
                this.fiftAsmLibraryPath = this.getFiftSystemLibPath();
            }
            if (StringUtils.isEmpty((CharSequence)this.fiftSmartcontLibraryPath)) {
                this.fiftSmartcontLibraryPath = this.getFiftSystemSmartcontPath();
            }
            if (this.printInfo.booleanValue()) {
                log.info("Using include dirs: {}, {}", (Object)this.fiftAsmLibraryPath, (Object)this.fiftSmartcontLibraryPath);
            }
            return super.build();
        }

        private String getFiftSystemLibPath() {
            if (Utils.getOS() == Utils.OS.WINDOWS) {
                return new File(this.fiftAbsolutePath).getParent() + File.separator + "lib";
            }
            if (Utils.getOS() == Utils.OS.LINUX || Utils.getOS() == Utils.OS.LINUX_ARM) {
                return "/usr/lib/fift";
            }
            if (new File("/usr/local/lib/fift").exists()) {
                return "/usr/local/lib/fift";
            }
            if (new File("/opt/homebrew/lib/fift").exists()) {
                return "/opt/homebrew/lib/fift";
            }
            return null;
        }

        private String getFiftSystemSmartcontPath() {
            if (Utils.getOS() == Utils.OS.WINDOWS) {
                return new File(this.fiftAbsolutePath).getParent() + File.separator + "smartcont";
            }
            if (Utils.getOS() == Utils.OS.LINUX || Utils.getOS() == Utils.OS.LINUX_ARM) {
                return "/usr/share/ton/smartcont";
            }
            if (new File("/usr/local/share/ton/ton/smartcont").exists()) {
                return "/usr/local/share/ton/ton/smartcont";
            }
            if (new File("/opt/homebrew/share/ton/ton/smartcont").exists()) {
                return "/opt/homebrew/share/ton/ton/smartcont";
            }
            return null;
        }
    }

    public static class FiftRunnerBuilder {
        private String fiftAsmLibraryPath;
        private String fiftSmartcontLibraryPath;
        private String fiftExecutablePath;
        private Boolean printInfo;

        FiftRunnerBuilder() {
        }

        public FiftRunnerBuilder fiftAsmLibraryPath(String fiftAsmLibraryPath) {
            this.fiftAsmLibraryPath = fiftAsmLibraryPath;
            return this;
        }

        public FiftRunnerBuilder fiftSmartcontLibraryPath(String fiftSmartcontLibraryPath) {
            this.fiftSmartcontLibraryPath = fiftSmartcontLibraryPath;
            return this;
        }

        public FiftRunnerBuilder fiftExecutablePath(String fiftExecutablePath) {
            this.fiftExecutablePath = fiftExecutablePath;
            return this;
        }

        public FiftRunnerBuilder printInfo(Boolean printInfo) {
            this.printInfo = printInfo;
            return this;
        }

        public FiftRunner build() {
            return new FiftRunner(this.fiftAsmLibraryPath, this.fiftSmartcontLibraryPath, this.fiftExecutablePath, this.printInfo);
        }

        public String toString() {
            return "FiftRunner.FiftRunnerBuilder(fiftAsmLibraryPath=" + this.fiftAsmLibraryPath + ", fiftSmartcontLibraryPath=" + this.fiftSmartcontLibraryPath + ", fiftExecutablePath=" + this.fiftExecutablePath + ", printInfo=" + this.printInfo + ")";
        }
    }
}

