/*
 * Decompiled with CFR 0.152.
 */
package io.github.nambach.excelutil.validator.builtin;

import io.github.nambach.excelutil.validator.Constraint;
import io.github.nambach.excelutil.validator.builtin.IntegerConstraint;
import io.github.nambach.excelutil.validator.builtin.TypeValidator;

public class IntegerValidator
extends TypeValidator {
    IntegerValidator() {
        Constraint.Set temp = new Constraint.Set();
        temp.add(IntegerConstraint.IsInteger);
        temp.addAll(this.constraints);
        this.constraints = temp;
    }

    @Override
    public IntegerValidator notNull() {
        super.notNull();
        return this;
    }

    @Override
    public IntegerValidator notNull(String message) {
        super.notNull(message);
        return this;
    }

    public IntegerValidator min(long min) {
        this.constraints.add(IntegerConstraint.MinInteger.apply(min));
        return this;
    }

    public IntegerValidator min(long min, String message) {
        this.constraints.add(IntegerConstraint.MinInteger.apply(min).withMessage(message));
        return this;
    }

    public IntegerValidator max(long max) {
        this.constraints.add(IntegerConstraint.MaxInteger.apply(max));
        return this;
    }

    public IntegerValidator max(long max, String message) {
        this.constraints.add(IntegerConstraint.MaxInteger.apply(max).withMessage(message));
        return this;
    }

    public IntegerValidator between(long min, long max) {
        this.constraints.add(IntegerConstraint.BetweenInteger.apply(min, max));
        return this;
    }

    public IntegerValidator between(long min, long max, String message) {
        this.constraints.add(IntegerConstraint.BetweenInteger.apply(min, max).withMessage(message));
        return this;
    }

    public IntegerValidator greaterThan(long min) {
        this.constraints.add(IntegerConstraint.GreaterThanInteger.apply(min));
        return this;
    }

    public IntegerValidator greaterThan(long min, String message) {
        this.constraints.add(IntegerConstraint.GreaterThanInteger.apply(min).withMessage(message));
        return this;
    }

    public IntegerValidator lessThan(long min) {
        this.constraints.add(IntegerConstraint.LessThanInteger.apply(min));
        return this;
    }

    public IntegerValidator lessThan(long min, String message) {
        this.constraints.add(IntegerConstraint.LessThanInteger.apply(min).withMessage(message));
        return this;
    }

    public IntegerValidator betweenExclusive(long min, long max) {
        this.constraints.add(IntegerConstraint.BetweenIntegerExclusive.apply(min, max));
        return this;
    }

    public IntegerValidator betweenExclusive(long min, long max, String message) {
        this.constraints.add(IntegerConstraint.BetweenIntegerExclusive.apply(min, max).withMessage(message));
        return this;
    }
}

