/*
 * Decompiled with CFR 0.152.
 */
package io.github.nambach.excelutil.validator;

import io.github.nambach.excelutil.util.ListUtil;
import io.github.nambach.excelutil.validator.Field;
import io.github.nambach.excelutil.validator.FieldError;
import io.github.nambach.excelutil.validator.ObjectError;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;

public class Validator<T> {
    private final Class<T> clazz;
    private final Map<String, Field<T>> fields;

    Validator(Class<T> clazz) {
        this.clazz = clazz;
        this.fields = new LinkedHashMap<String, Field<T>>();
    }

    public static <T> Validator<T> fromClass(Class<T> clazz) {
        return new Validator<T>(clazz);
    }

    public Field<T> getField(String fieldName) {
        return this.fields.get(fieldName);
    }

    public Validator<T> on(UnaryOperator<Field<T>> fieldBuilder) {
        Field field = (Field)fieldBuilder.apply(new Field<T>(this.clazz));
        String fieldName = field.getFieldName();
        if (fieldName == null) {
            throw new RuntimeException("Field name must be provided.");
        }
        if (this.fields.containsKey(fieldName)) {
            throw new RuntimeException(String.format("Field '%s' already existed.", fieldName));
        }
        if (field.getExtractor() == null) {
            field.bindField();
        }
        if (field.getTypeValidator() == null) {
            throw new RuntimeException("Validator rule must be provided.");
        }
        this.fields.put(fieldName, field);
        return this;
    }

    public ObjectError validate(T object) {
        ObjectError objectError = new ObjectError(this.clazz);
        for (Field<T> field : this.fields.values()) {
            Object value = field.extract(object);
            List<String> messages = field.getTypeValidator().test(value);
            if (!ListUtil.hasMember(messages)) continue;
            objectError.appendError(field.getFieldName(), messages);
        }
        return objectError;
    }

    public FieldError quickValidate(T object) {
        for (Field<T> field : this.fields.values()) {
            Object value = field.extract(object);
            String message = field.getTypeValidator().quickTest(value);
            if (message == null) continue;
            FieldError fieldError = new FieldError(field.getFieldName());
            fieldError.append(message);
            return fieldError;
        }
        return null;
    }
}

