/*
 * Decompiled with CFR 0.152.
 */
package io.github.nambach.excelutil.validator;

import io.github.nambach.excelutil.util.ListUtil;
import io.github.nambach.excelutil.validator.FieldError;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ObjectError
implements Iterable<FieldError> {
    private final Class<?> clazz;
    private final String className;
    private final List<FieldError> fieldErrors = new ArrayList<FieldError>();

    public ObjectError(Class<?> clazz) {
        this.clazz = clazz;
        this.className = clazz.getName();
    }

    public boolean noError() {
        return this.fieldErrors.isEmpty();
    }

    public boolean hasErrors() {
        return !this.fieldErrors.isEmpty();
    }

    public void appendError(String fieldName, List<String> messages) {
        FieldError current = ListUtil.findElse(this.fieldErrors, e -> Objects.equals(e.getFieldName(), fieldName), new FieldError(fieldName));
        current.append(messages);
    }

    public String getInlineMessage() {
        return this.fieldErrors.stream().map(FieldError::toInlineMessage).collect(Collectors.joining("; "));
    }

    public String getMessage() {
        return this.fieldErrors.stream().map(FieldError::toString).collect(Collectors.joining("\n"));
    }

    public String toString() {
        return this.getMessage();
    }

    @Override
    public Iterator<FieldError> iterator() {
        return this.fieldErrors.iterator();
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public String getClassName() {
        return this.className;
    }

    public List<FieldError> getFieldErrors() {
        return this.fieldErrors;
    }
}

