/*
 * Decompiled with CFR 0.152.
 */
package io.github.nambach.excelutil.validator;

import io.github.nambach.excelutil.util.ReflectUtil;
import io.github.nambach.excelutil.validator.builtin.TypeValidator;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Field<T> {
    private static final Logger log = LogManager.getLogger(Field.class);
    private final Class<T> tClass;
    private Function<T, ?> extractor;
    private String fieldName;
    private TypeValidator typeValidator;

    Field(Class<T> tClass) {
        this.tClass = tClass;
    }

    public Field<T> field(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    public Field<T> customExtract(Function<T, ?> extractor) {
        this.extractor = extractor;
        return this;
    }

    public Field<T> validate(TypeValidator validator) {
        this.typeValidator = validator;
        return this;
    }

    public Field<T> validate(UnaryOperator<TypeValidator> builder) {
        this.typeValidator = (TypeValidator)builder.apply(TypeValidator.init());
        return this;
    }

    protected void bindField() {
        PropertyDescriptor pd = ReflectUtil.getField(this.fieldName, this.tClass);
        if (pd == null) {
            throw new Exception(String.format("Could not found field '%s' in class %s", this.fieldName, this.tClass.getName()));
        }
        this.extractor = o -> {
            try {
                return pd.getReadMethod().invoke(o, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                log.error("Cannot read field '" + this.fieldName + "' of class '" + this.tClass.getName() + "'.", (Throwable)e);
                return null;
            }
        };
    }

    protected Object extract(T object) {
        return this.extractor.apply(object);
    }

    Class<T> getTClass() {
        return this.tClass;
    }

    Function<T, ?> getExtractor() {
        return this.extractor;
    }

    String getFieldName() {
        return this.fieldName;
    }

    public TypeValidator getTypeValidator() {
        return this.typeValidator;
    }
}

