/*
 * Decompiled with CFR 0.152.
 */
package io.github.nambach.excelutil.style;

import io.github.nambach.excelutil.style.StyleColor;
import java.awt.Color;
import java.util.HashMap;
import org.apache.poi.xssf.usermodel.IndexedColorMap;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class XSSFColorCache
extends HashMap<Integer, XSSFColor> {
    private final transient XSSFWorkbook workbook;

    public XSSFColorCache(XSSFWorkbook workbook) {
        this.workbook = workbook;
    }

    public XSSFColor getColor(StyleColor color) {
        int key = color.getRGB();
        if (this.containsKey(key)) {
            return (XSSFColor)this.get(key);
        }
        IndexedColorMap colorMap = this.workbook.getStylesSource().getIndexedColors();
        XSSFColor rs = new XSSFColor((Color)color, colorMap);
        this.put(key, rs);
        return rs;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XSSFColorCache)) {
            return false;
        }
        XSSFColorCache other = (XSSFColorCache)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(Object other) {
        return other instanceof XSSFColorCache;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

