/*
 * Decompiled with CFR 0.152.
 */
package io.github.nambach.excelutil.style;

import io.github.nambach.excelutil.style.Border;
import io.github.nambach.excelutil.style.Style;
import io.github.nambach.excelutil.style.StyleColor;
import io.github.nambach.excelutil.style.StyleProperty;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.FontUnderline;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;

abstract class StyleHandler {
    StyleHandler() {
    }

    abstract Workbook getWorkbook();

    public CellStyle renderCellStyle(Style style) {
        CellStyle cellStyle = this.getWorkbook().createCellStyle();
        DataFormat format = this.getWorkbook().createDataFormat();
        Font font = this.renderFont(style);
        cellStyle.setFont(font);
        this.processBorder(style, cellStyle);
        style.getProperty(StyleProperty.Indentation).getShort().ifPresent(arg_0 -> ((CellStyle)cellStyle).setIndention(arg_0));
        style.getProperty(StyleProperty.WrapText).getBoolean().ifPresent(arg_0 -> ((CellStyle)cellStyle).setWrapText(arg_0));
        style.getProperty(StyleProperty.DataFormat).getString().ifPresent(pattern -> cellStyle.setDataFormat(format.getFormat(pattern)));
        style.getProperty(StyleProperty.BackgroundColor).getAny(StyleColor.class).ifPresent(color -> {
            if (color.isPreset()) {
                cellStyle.setFillForegroundColor(color.toIndexedColor().index);
            }
            cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        });
        style.getProperty(StyleProperty.Alignments).getAny(ArrayList.class).ifPresent(list -> {
            for (Object o : list) {
                if (o instanceof VerticalAlignment) {
                    cellStyle.setVerticalAlignment((VerticalAlignment)o);
                    continue;
                }
                if (!(o instanceof HorizontalAlignment)) continue;
                cellStyle.setAlignment((HorizontalAlignment)o);
            }
        });
        return cellStyle;
    }

    protected Font renderFont(Style style) {
        Font font = this.getWorkbook().createFont();
        style.getProperty(StyleProperty.FontName).getString().ifPresent(arg_0 -> ((Font)font).setFontName(arg_0));
        style.getProperty(StyleProperty.FontSize).getShort().ifPresent(arg_0 -> ((Font)font).setFontHeightInPoints(arg_0));
        style.getProperty(StyleProperty.Bold).getBoolean().ifPresent(arg_0 -> ((Font)font).setBold(arg_0));
        style.getProperty(StyleProperty.Underline).getBoolean().ifPresent(bool -> font.setUnderline(FontUnderline.SINGLE.getByteValue()));
        style.getProperty(StyleProperty.FontColor).getAny(StyleColor.class).ifPresent(color -> {
            if (color.isPreset()) {
                font.setColor(color.toIndexedColor().index);
            }
        });
        return font;
    }

    abstract void setBorderTop(Border var1, CellStyle var2);

    abstract void setBorderBottom(Border var1, CellStyle var2);

    abstract void setBorderLeft(Border var1, CellStyle var2);

    abstract void setBorderRight(Border var1, CellStyle var2);

    protected void processBorder(Style style, CellStyle cellStyle) {
        List borders = style.getProperty(StyleProperty.Borders).getAny(List.class).orElse(null);
        if (borders == null) {
            return;
        }
        for (Border border : borders) {
            switch (border.getSide()) {
                case NONE: {
                    cellStyle.setBorderTop(BorderStyle.NONE);
                    cellStyle.setBorderBottom(BorderStyle.NONE);
                    cellStyle.setBorderLeft(BorderStyle.NONE);
                    cellStyle.setBorderRight(BorderStyle.NONE);
                    return;
                }
                case TOP: {
                    this.setBorderTop(border, cellStyle);
                    break;
                }
                case BOTTOM: {
                    this.setBorderBottom(border, cellStyle);
                    break;
                }
                case LEFT: {
                    this.setBorderLeft(border, cellStyle);
                    break;
                }
                case RIGHT: {
                    this.setBorderRight(border, cellStyle);
                    break;
                }
                case FULL: {
                    this.setBorderTop(border, cellStyle);
                    this.setBorderBottom(border, cellStyle);
                    this.setBorderLeft(border, cellStyle);
                    this.setBorderRight(border, cellStyle);
                }
            }
        }
    }

    public abstract int countColors();
}

