/*
 * Decompiled with CFR 0.152.
 */
package io.github.nambach.excelutil.style;

import io.github.nambach.excelutil.style.Border;
import io.github.nambach.excelutil.style.HSSFColorCache;
import io.github.nambach.excelutil.style.Style;
import io.github.nambach.excelutil.style.StyleColor;
import io.github.nambach.excelutil.style.StyleHandler;
import io.github.nambach.excelutil.style.StyleProperty;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Workbook;

public class HSSFStyleHandler
extends StyleHandler {
    protected final HSSFColorCache colorCache;
    private final HSSFWorkbook workbook;

    public HSSFStyleHandler(HSSFWorkbook workbook, HSSFColorCache colorCache) {
        this.workbook = workbook;
        this.colorCache = colorCache;
    }

    @Override
    Workbook getWorkbook() {
        return this.workbook;
    }

    @Override
    public CellStyle renderCellStyle(Style style) {
        if (style == null) {
            return null;
        }
        HSSFCellStyle cellStyle = (HSSFCellStyle)super.renderCellStyle(style);
        style.getProperty(StyleProperty.BackgroundColor).getAny(StyleColor.class).ifPresent(color -> cellStyle.setFillForegroundColor(this.colorCache.getIndex((StyleColor)color)));
        return cellStyle;
    }

    @Override
    protected Font renderFont(Style style) {
        HSSFFont font = (HSSFFont)super.renderFont(style);
        style.getProperty(StyleProperty.FontColor).getAny(StyleColor.class).ifPresent(color -> font.setColor(this.colorCache.getIndex((StyleColor)color)));
        return font;
    }

    @Override
    void setBorderTop(Border border, CellStyle cellStyle) {
        cellStyle.setBorderTop(border.getBorderStyle());
        cellStyle.setTopBorderColor(this.colorCache.getIndex(border.getColor()));
    }

    @Override
    void setBorderBottom(Border border, CellStyle cellStyle) {
        cellStyle.setBorderBottom(border.getBorderStyle());
        cellStyle.setBottomBorderColor(this.colorCache.getIndex(border.getColor()));
    }

    @Override
    void setBorderLeft(Border border, CellStyle cellStyle) {
        cellStyle.setBorderLeft(border.getBorderStyle());
        cellStyle.setLeftBorderColor(this.colorCache.getIndex(border.getColor()));
    }

    @Override
    void setBorderRight(Border border, CellStyle cellStyle) {
        cellStyle.setBorderRight(border.getBorderStyle());
        cellStyle.setRightBorderColor(this.colorCache.getIndex(border.getColor()));
    }

    @Override
    public int countColors() {
        return this.colorCache.size();
    }
}

