/*
 * Decompiled with CFR 0.152.
 */
package io.github.nambach.excelutil.style;

import io.github.nambach.excelutil.style.HSSFColorCache;
import io.github.nambach.excelutil.style.HSSFStyleHandler;
import io.github.nambach.excelutil.style.Node;
import io.github.nambach.excelutil.style.Style;
import io.github.nambach.excelutil.style.StyleHandler;
import io.github.nambach.excelutil.style.XSSFColorCache;
import io.github.nambach.excelutil.style.XSSFStyleHandler;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class CacheStyle {
    private final Node<CellStyle> root = new Node<Object>("root", null);
    private final Workbook workbook;
    private final StyleHandler handler;

    public CacheStyle(Workbook workbook) {
        this.workbook = workbook;
        if (workbook instanceof XSSFWorkbook) {
            XSSFWorkbook wb = (XSSFWorkbook)workbook;
            this.handler = new XSSFStyleHandler(wb, new XSSFColorCache(wb));
        } else if (workbook instanceof HSSFWorkbook) {
            HSSFWorkbook wb = (HSSFWorkbook)workbook;
            this.handler = new HSSFStyleHandler(wb, new HSSFColorCache(wb, HSSFColorCache.Policy.USE_MOST_SIMILAR));
        } else if (workbook instanceof SXSSFWorkbook) {
            SXSSFWorkbook wb = (SXSSFWorkbook)workbook;
            this.handler = new XSSFStyleHandler(wb.getXSSFWorkbook(), new XSSFColorCache(wb.getXSSFWorkbook()));
        } else {
            throw new RuntimeException("Unsupported workbook type");
        }
    }

    public void setHSSFColorPolicy(HSSFColorCache.Policy policy) {
        if (this.handler instanceof HSSFStyleHandler) {
            ((HSSFStyleHandler)this.handler).colorCache.setPolicy(policy);
        }
    }

    public String printTotalStyle() {
        int total = this.root.countAllChildren();
        String report = String.format("%d %s created.", total, total > 1 ? "styles were" : "style was");
        int totalColors = this.handler.countColors();
        String colorReport = String.format("%d %s created.", totalColors, totalColors > 1 ? "colors were" : "color was");
        report = report + "\n" + colorReport;
        return report;
    }

    public CellStyle accumulate(Style ... styles) {
        return this.accumulate(Arrays.asList(styles));
    }

    public CellStyle accumulate(Collection<Style> src) {
        if (src == null) {
            return null;
        }
        List styles = src.stream().filter(Objects::nonNull).collect(Collectors.toList());
        if (styles.isEmpty()) {
            return null;
        }
        List<String> idPath = styles.stream().map(Style::getUuid).collect(Collectors.toList());
        Node<CellStyle> node = this.root.lookup(idPath);
        if (node != null && node.getData() != null) {
            return node.getData();
        }
        Style combinedStyle = styles.stream().reduce(Style::accumulate).orElse(null);
        CellStyle style = this.handler.renderCellStyle(combinedStyle);
        this.root.updatePath(idPath, style);
        return style;
    }

    public Node<CellStyle> getRoot() {
        return this.root;
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public StyleHandler getHandler() {
        return this.handler;
    }
}

