/*
 * Decompiled with CFR 0.152.
 */
package io.github.nambach.excelutil.core;

import io.github.nambach.excelutil.constraint.Constraint;
import io.github.nambach.excelutil.core.Editor;
import io.github.nambach.excelutil.core.FreestyleWriter;
import io.github.nambach.excelutil.core.PointerNavigation;
import io.github.nambach.excelutil.core.WriterCell;
import io.github.nambach.excelutil.core.WriterComment;
import io.github.nambach.excelutil.style.Style;
import java.io.ByteArrayInputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.apache.poi.ss.util.CellAddress;

public class Template
implements Iterable<WriterCell>,
FreestyleWriter<Template> {
    private final Map<String, WriterCell> cells = new HashMap<String, WriterCell>();
    private final PointerNavigation navigation = new PointerNavigation();
    private Style tempStyle;

    int calculateIndex(Function<WriterCell, Integer> mapper, BinaryOperator<Integer> type) {
        return this.cells.values().stream().map(mapper).reduce(type).orElse(0);
    }

    int[] getRowIndexRange() {
        int min = this.calculateIndex(WriterCell::getRowAt, Math::min);
        int max = this.calculateIndex(WriterCell::getRowAt, Math::max);
        return new int[]{min, max};
    }

    int[] getColIndexRange() {
        int min = this.calculateIndex(WriterCell::getColAt, Math::min);
        int max = this.calculateIndex(WriterCell::getColAt, Math::max);
        return new int[]{min, max};
    }

    public Template makeCopy() {
        Template clone = new Template();
        clone.cells.putAll(this.cells);
        clone.navigation.sync(this.navigation);
        clone.tempStyle = this.tempStyle;
        return clone;
    }

    @Override
    public Template goToCell(String address) {
        this.navigation.goToCell(address);
        return this;
    }

    @Override
    public Template goToCell(int row, int col) {
        this.navigation.goToCell(row, col);
        return this;
    }

    @Override
    public Template next() {
        this.navigation.next();
        return this;
    }

    @Override
    public Template next(int steps) {
        this.navigation.next(steps);
        return this;
    }

    @Override
    public Template down() {
        this.navigation.down();
        return this;
    }

    @Override
    public Template down(int steps) {
        this.navigation.down(steps);
        return this;
    }

    @Override
    public Template enter() {
        this.navigation.enter();
        return this;
    }

    @Override
    public Template enter(int steps) {
        this.navigation.enter(steps);
        return this;
    }

    private WriterCell updateCell(CellAddress cellAddress, UnaryOperator<WriterCell> builder) {
        String address = cellAddress.formatAsString();
        WriterCell current = this.cells.getOrDefault(address, new WriterCell(cellAddress, this.tempStyle));
        WriterCell newCell = (WriterCell)builder.apply(current);
        this.cells.put(address, newCell);
        return newCell;
    }

    @Override
    public Template writeCell(UnaryOperator<WriterCell> builder) {
        WriterCell cell = this.updateCell(this.navigation.getCellAddress(), builder);
        this.navigation.updatePivotRight(cell.getColSpan() - 1);
        this.navigation.updatePivotDown(cell.getRowSpan() - 1);
        return this;
    }

    @Override
    public Template useStyle(Style style) {
        this.tempStyle = style;
        return this;
    }

    @Override
    public Template applyStyle() {
        this.updateCell(this.navigation.getCellAddress(), c -> c.replaceStyle(this.tempStyle));
        return this;
    }

    @Override
    public Template applyStyle(Style style, String ... address) {
        if (address == null || address.length == 0) {
            this.updateCell(this.navigation.getCellAddress(), c -> c.replaceStyle(style));
        } else {
            this.applyStyle(style, Arrays.asList(address));
        }
        return this;
    }

    @Override
    public Template applyStyle(Style style, Collection<String> addresses) {
        UnaryOperator builder = c -> c.replaceStyle(style);
        Collection<CellAddress> cellAddresses = this.parseAddress(addresses);
        for (CellAddress cellAddress : cellAddresses) {
            this.updateCell(cellAddress, builder);
        }
        return this;
    }

    @Override
    public Template applyConstraint(Constraint constraint, String ... address) {
        if (address == null || address.length == 0) {
            this.updateCell(this.navigation.getCellAddress(), c -> c.constraint(constraint));
        } else {
            this.applyConstraint(constraint, Arrays.asList(address));
        }
        return this;
    }

    @Override
    public Template applyConstraint(Constraint constraint, Collection<String> addresses) {
        UnaryOperator builder = c -> c.constraint(constraint);
        Collection<CellAddress> cellAddresses = this.parseAddress(addresses);
        for (CellAddress cellAddress : cellAddresses) {
            this.updateCell(cellAddress, builder);
        }
        return this;
    }

    @Override
    public Template writeComment(UnaryOperator<WriterComment> builder) {
        this.updateCell(this.navigation.getCellAddress(), c -> c.comment(builder));
        return this;
    }

    @Override
    public Iterator<WriterCell> iterator() {
        return this.cells.values().iterator();
    }

    public ByteArrayInputStream getFile() {
        try (Editor editor = new Editor();){
            editor.goToSheet(0);
            editor.writeTemplate(this);
            ByteArrayInputStream byteArrayInputStream = editor.exportToFile();
            return byteArrayInputStream;
        }
    }

    Map<String, WriterCell> getCells() {
        return this.cells;
    }

    PointerNavigation getNavigation() {
        return this.navigation;
    }

    Style getTempStyle() {
        return this.tempStyle;
    }

    void setTempStyle(Style tempStyle) {
        this.tempStyle = tempStyle;
    }
}

