/*
 * Decompiled with CFR 0.152.
 */
package io.github.nambach.excelutil.core;

import io.github.nambach.excelutil.core.ColumnMapper;
import io.github.nambach.excelutil.core.ColumnTemplate;
import io.github.nambach.excelutil.core.Editor;
import io.github.nambach.excelutil.core.FlatData;
import io.github.nambach.excelutil.core.ReaderConfig;
import io.github.nambach.excelutil.style.Style;
import io.github.nambach.excelutil.style.StyleConstant;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.ss.util.CellAddress;

public class DataTemplate<T>
extends ColumnTemplate<T> {
    private static final Logger log = LogManager.getLogger(DataTemplate.class);
    private int rowAt;
    private int colAt;
    private boolean autoSizeColumns;
    private boolean noHeader;
    private transient Style headerStyle = StyleConstant.HEADER_STYLE;
    private transient Style dataStyle = StyleConstant.DATA_STYLE;
    private transient Function<T, Style> conditionalRowStyle;

    DataTemplate(Class<T> tClass) {
        super(tClass);
    }

    public static <T> DataTemplate<T> fromClass(Class<T> tClass) {
        return new DataTemplate<T>(tClass);
    }

    public DataTemplate<T> config(UnaryOperator<Builder<T>> configBuilder) {
        Objects.requireNonNull(configBuilder);
        Builder cf = new Builder(this);
        configBuilder.apply(cf);
        return this;
    }

    @Override
    public DataTemplate<T> filter(Predicate<ColumnMapper<T>> condition) {
        DataTemplate<T> clone = this.makeCopy();
        this.internalFilter(clone, condition);
        return clone;
    }

    @Override
    public DataTemplate<T> concat(DataTemplate<T> other) {
        if (other == null || other == this) {
            return this;
        }
        DataTemplate<T> clone = this.makeCopy();
        clone.addAll(other);
        return clone;
    }

    @Override
    public DataTemplate<T> includeFields(String ... fieldNames) {
        super.includeFields(fieldNames);
        return this;
    }

    @Override
    public DataTemplate<T> includeAllFields() {
        super.includeAllFields();
        return this;
    }

    @Override
    public DataTemplate<T> excludeFields(String ... fieldNames) {
        super.excludeFields(fieldNames);
        return this;
    }

    @Override
    public DataTemplate<T> column(UnaryOperator<ColumnMapper<T>> builder) {
        super.column(builder);
        return this;
    }

    public DataTemplate<T> makeCopy() {
        DataTemplate<T> clone = new DataTemplate<T>(this.tClass);
        clone.addAll(this);
        super.copyConfig(this);
        clone.conditionalRowStyle = this.conditionalRowStyle;
        return clone;
    }

    private void copyConfig(DataTemplate<?> other) {
        this.rowAt = other.rowAt;
        this.colAt = other.colAt;
        this.autoSizeColumns = other.autoSizeColumns;
        this.noHeader = other.noHeader;
        this.headerStyle = other.headerStyle;
        this.dataStyle = other.dataStyle;
    }

    Style applyConditionalRowStyle(T object) {
        if (this.conditionalRowStyle == null) {
            return null;
        }
        return this.conditionalRowStyle.apply(object);
    }

    public ByteArrayInputStream getFileForImport() {
        try (Editor editor = new Editor();){
            DataTemplate<T> clone = this.makeCopy();
            ByteArrayInputStream byteArrayInputStream = editor.goToSheet(0).goToCell(this.rowAt, this.colAt).writeData(clone, null).exportToFile();
            return byteArrayInputStream;
        }
    }

    public ByteArrayInputStream writeData(Collection<T> data) {
        try (Editor editor = new Editor();){
            ByteArrayInputStream byteArrayInputStream = editor.goToSheet(0).goToCell(this.rowAt, this.colAt).writeData(this, data).exportToFile();
            return byteArrayInputStream;
        }
    }

    public ByteArrayInputStream writeData(Collection<T> data, String sheetName) {
        try (Editor editor = new Editor();){
            ByteArrayInputStream byteArrayInputStream = editor.goToSheet(sheetName).goToCell(this.rowAt, this.colAt).writeData(this, data).exportToFile();
            return byteArrayInputStream;
        }
    }

    public ReaderConfig<T> getReaderConfigByColumnIndex() {
        ReaderConfig config = ReaderConfig.fromClass(this.tClass);
        int i = 0;
        for (ColumnMapper mapper : this) {
            if (mapper.getFieldName() == null) continue;
            config.column(i++, mapper.getFieldName());
        }
        if (this.noHeader) {
            config.dataFromRow(0);
        } else {
            config.titleAtRow(0);
            config.dataFromRow(1);
        }
        return config.translate(this.rowAt, this.colAt);
    }

    public ReaderConfig<T> getReaderConfig() {
        if (this.noHeader) {
            log.error("WARNING: Source file must include header row; 'noHeader=true' found.");
        }
        ReaderConfig config = ReaderConfig.fromClass(this.tClass);
        config.titleAtRow(this.rowAt);
        config.dataFromRow(this.rowAt + 1);
        for (ColumnMapper mapper : this) {
            if (mapper.getTitle() == null) {
                throw new RuntimeException("Title of field '" + mapper.getFieldName() + "' must be provided.");
            }
            if (mapper.getFieldName() == null) continue;
            config.column(mapper.getTitle(), mapper.getFieldName());
        }
        return config;
    }

    DataTemplate<FlatData> getFlatTemplate() {
        DataTemplate<FlatData> result = new DataTemplate<FlatData>(FlatData.class);
        super.copyConfig(this);
        for (ColumnMapper mapper : this) {
            if (mapper.isListField()) {
                this.collectDeepMapper(mapper, 1, result);
                continue;
            }
            Function<FlatData, Object> selector = datum -> datum.get(0);
            ColumnMapper<FlatData> newMapper = mapper.compose(selector);
            result.add(newMapper);
        }
        return result;
    }

    private void collectDeepMapper(ColumnMapper<?> fieldList, int deepLevel, DataTemplate<FlatData> result) {
        if (fieldList.isListField()) {
            for (ColumnMapper columnMapper : fieldList.fieldTemplate) {
                if (columnMapper.isListField()) {
                    this.collectDeepMapper(columnMapper, deepLevel + 1, result);
                    continue;
                }
                Function<FlatData, Object> selector = datum -> datum.get(deepLevel);
                ColumnMapper<FlatData> newMapper = columnMapper.compose(selector);
                result.add(newMapper);
            }
        }
    }

    Collection<FlatData> flattenData(Collection<?> data) {
        ArrayList<FlatData> result = new ArrayList<FlatData>();
        ColumnMapper deepField = this.getDeepField();
        for (Object datum : data) {
            FlatData seed = new FlatData();
            seed.add(datum);
            result.addAll(this.flattenData(seed, deepField));
        }
        return result;
    }

    private Collection<FlatData> flattenData(FlatData seed, ColumnMapper<?> field) {
        ArrayList<FlatData> result = new ArrayList<FlatData>();
        Object datum = seed.getLast();
        Function<?, ?> mapper = field.getMapper();
        Object collection = mapper.apply(datum);
        if (collection instanceof Collection) {
            ColumnMapper<?> deepField = field.fieldTemplate.getDeepField();
            for (Object element : (Collection)collection) {
                FlatData item = seed.makeCopy();
                item.add(element);
                if (deepField != null) {
                    result.addAll(this.flattenData(item, deepField));
                    continue;
                }
                result.add(item);
            }
        }
        return result;
    }

    int getRowAt() {
        return this.rowAt;
    }

    int getColAt() {
        return this.colAt;
    }

    boolean isAutoSizeColumns() {
        return this.autoSizeColumns;
    }

    boolean isNoHeader() {
        return this.noHeader;
    }

    Style getHeaderStyle() {
        return this.headerStyle;
    }

    Style getDataStyle() {
        return this.dataStyle;
    }

    Function<T, Style> getConditionalRowStyle() {
        return this.conditionalRowStyle;
    }

    void setRowAt(int rowAt) {
        this.rowAt = rowAt;
    }

    void setColAt(int colAt) {
        this.colAt = colAt;
    }

    void setAutoSizeColumns(boolean autoSizeColumns) {
        this.autoSizeColumns = autoSizeColumns;
    }

    void setNoHeader(boolean noHeader) {
        this.noHeader = noHeader;
    }

    void setHeaderStyle(Style headerStyle) {
        this.headerStyle = headerStyle;
    }

    void setDataStyle(Style dataStyle) {
        this.dataStyle = dataStyle;
    }

    void setConditionalRowStyle(Function<T, Style> conditionalRowStyle) {
        this.conditionalRowStyle = conditionalRowStyle;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataTemplate)) {
            return false;
        }
        DataTemplate other = (DataTemplate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getRowAt() != other.getRowAt()) {
            return false;
        }
        if (this.getColAt() != other.getColAt()) {
            return false;
        }
        if (this.isAutoSizeColumns() != other.isAutoSizeColumns()) {
            return false;
        }
        return this.isNoHeader() == other.isNoHeader();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DataTemplate;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getRowAt();
        result = result * 59 + this.getColAt();
        result = result * 59 + (this.isAutoSizeColumns() ? 79 : 97);
        result = result * 59 + (this.isNoHeader() ? 79 : 97);
        return result;
    }

    public static class Builder<T> {
        private final DataTemplate<T> template;

        public Builder(DataTemplate<T> template) {
            this.template = template;
        }

        public Builder<T> startAtCell(int rowAt, int colAt) {
            if (rowAt < 0 || colAt < 0) {
                throw new RuntimeException("Cell coordinate must be from (0, 0)");
            }
            ((DataTemplate)this.template).rowAt = rowAt;
            ((DataTemplate)this.template).colAt = colAt;
            return this;
        }

        public Builder<T> startAtCell(String address) {
            try {
                CellAddress cellAddress = new CellAddress(address);
                return this.startAtCell(cellAddress.getRow(), cellAddress.getColumn());
            }
            catch (Exception e) {
                throw new RuntimeException("Error while parsing cell address", e);
            }
        }

        public Builder<T> autoSizeColumns(boolean b) {
            ((DataTemplate)this.template).autoSizeColumns = b;
            return this;
        }

        public Builder<T> noHeader(boolean b) {
            ((DataTemplate)this.template).noHeader = b;
            return this;
        }

        public Builder<T> headerStyle(Style style) {
            ((DataTemplate)this.template).headerStyle = style;
            return this;
        }

        public Builder<T> dataStyle(Style style) {
            ((DataTemplate)this.template).dataStyle = style;
            return this;
        }

        public Builder<T> conditionalRowStyle(Function<T, Style> function) {
            Objects.requireNonNull(function);
            ((DataTemplate)this.template).conditionalRowStyle = function;
            return this;
        }
    }
}

