/*
 * Decompiled with CFR 0.152.
 */
package io.github.nambach.excelutil.core;

import io.github.nambach.excelutil.core.ColumnMapper;
import io.github.nambach.excelutil.util.ListUtil;
import io.github.nambach.excelutil.util.ReflectUtil;
import io.github.nambach.excelutil.util.TextUtil;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;

public class ColumnTemplate<T>
extends ArrayList<ColumnMapper<T>> {
    protected Class<T> tClass;

    protected ColumnTemplate(Class<T> tClass) {
        this.tClass = tClass;
    }

    public ColumnTemplate<T> filter(Predicate<ColumnMapper<T>> condition) {
        return this.internalFilter(new ColumnTemplate<T>(this.tClass), condition);
    }

    protected ColumnTemplate<T> internalFilter(ColumnTemplate<T> clone, Predicate<ColumnMapper<T>> condition) {
        Objects.requireNonNull(condition);
        clone.removeIf(condition.negate());
        return clone;
    }

    public ColumnTemplate<T> concat(ColumnTemplate<T> other) {
        if (other == null || other == this) {
            return this;
        }
        ColumnTemplate<T> clone = new ColumnTemplate<T>(this.tClass);
        clone.addAll(this);
        clone.addAll(other);
        return clone;
    }

    public ColumnTemplate<T> includeFields(String ... fieldNames) {
        List list = Arrays.stream(fieldNames).map(s -> new ColumnMapper().field((String)s)).filter(this::validateMapper).filter((? super T mapper) -> this.stream().noneMatch(current -> Objects.equals(current.getFieldName(), mapper.getFieldName()))).collect(Collectors.toList());
        this.addAll(list);
        return this;
    }

    public ColumnTemplate<T> includeAllFields() {
        Field[] fields = this.tClass.getDeclaredFields();
        String[] fieldNames = (String[])Arrays.stream(fields).map(Field::getName).toArray(String[]::new);
        return this.includeFields(fieldNames);
    }

    public ColumnTemplate<T> excludeFields(String ... fieldNames) {
        List<String> fields = ListUtil.fromArray(fieldNames);
        this.removeIf(m -> fields.contains(m.getFieldName()));
        return this;
    }

    public ColumnTemplate<T> column(UnaryOperator<ColumnMapper<T>> builder) {
        ColumnMapper mapper = (ColumnMapper)builder.apply(new ColumnMapper());
        if (this.validateMapper(mapper)) {
            this.add(mapper);
        }
        return this;
    }

    protected boolean validateMapper(ColumnMapper<T> mapper) {
        String fieldName = mapper.getFieldName();
        String title = mapper.getDisplayName();
        if (mapper.getMapper() != null) {
            if (title == null) {
                mapper.setDisplayName(String.format("Column %s", fieldName));
            }
        } else if (fieldName != null) {
            PropertyDescriptor pd = ReflectUtil.getField(fieldName, this.tClass);
            if (pd == null) {
                return false;
            }
            if (title == null) {
                mapper.setDisplayName(TextUtil.splitCamelCase(fieldName));
            }
            Function<Object, Object> getter = obj -> {
                try {
                    return pd.getReadMethod().invoke(obj, new Object[0]);
                }
                catch (Exception e) {
                    return null;
                }
            };
            mapper.setMapper(getter);
        } else {
            return false;
        }
        return true;
    }

    protected boolean hasDeepLevel() {
        return this.stream().anyMatch(ColumnMapper::isListField);
    }

    protected ColumnMapper<T> getDeepField() {
        return this.stream().filter(ColumnMapper::isListField).findFirst().orElse(null);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ColumnTemplate)) {
            return false;
        }
        ColumnTemplate other = (ColumnTemplate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Class<T> this$tClass = this.tClass;
        Class<T> other$tClass = other.tClass;
        return !(this$tClass == null ? other$tClass != null : !this$tClass.equals(other$tClass));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ColumnTemplate;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Class<T> $tClass = this.tClass;
        result = result * 59 + ($tClass == null ? 43 : $tClass.hashCode());
        return result;
    }
}

