/*
 * Decompiled with CFR 0.152.
 */
package io.github.nambach.excelutil.constraint;

import io.github.nambach.excelutil.constraint.ConstraintProperty;
import io.github.nambach.excelutil.util.Copyable;
import io.github.nambach.excelutil.util.CopyableList;
import io.github.nambach.excelutil.util.Readable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class Constraint
implements Copyable<Constraint> {
    private final String uuid;
    private final Map<String, ConstraintProperty> map = new HashMap<String, ConstraintProperty>();

    private Constraint(String uuid) {
        this.uuid = uuid;
    }

    private static Constraint newRandom() {
        return new Constraint(UUID.randomUUID().toString());
    }

    public static ConstraintBuilder builder() {
        return new ConstraintBuilder(Constraint.newRandom());
    }

    public static ConstraintBuilder builder(Constraint constraint) {
        if (constraint != null) {
            return new ConstraintBuilder(constraint.makeCopy());
        }
        return Constraint.builder();
    }

    void put(ConstraintProperty property) {
        this.map.put(property.getName(), property);
    }

    ConstraintProperty getProperty(ConstraintProperty any) {
        return this.map.getOrDefault(any.getName(), any);
    }

    ConstraintProperty getOrDefault(ConstraintProperty any) {
        ConstraintProperty property = this.map.get(any.getName());
        if (property == null) {
            this.put(any);
            property = any;
        }
        return property;
    }

    boolean hasNoProperty() {
        return this.map.isEmpty() || this.map.values().stream().allMatch(Readable::isNullOrEmpty);
    }

    @Override
    public Constraint makeCopy() {
        Constraint copy = Constraint.newRandom();
        this.map.forEach((name, property) -> copy.map.put((String)name, property.makeCopy()));
        return copy;
    }

    Constraint accumulate(Constraint other) {
        if (this == other || other == null || other.hasNoProperty()) {
            return this;
        }
        Constraint accumulated = this.makeCopy();
        other.map.values().stream().filter(Readable::hasValue).forEach(accumulated::put);
        return accumulated;
    }

    public String getUuid() {
        return this.uuid;
    }

    public static class ConstraintBuilder {
        private final Constraint constraint;

        private ConstraintBuilder(Constraint constraint) {
            this.constraint = constraint;
        }

        public ConstraintBuilder dropdown(String ... values) {
            if (values != null) {
                this.constraint.getOrDefault(ConstraintProperty.Dropdown.withValue(new CopyableList())).getAny(CopyableList.class).ifPresent(l -> Collections.addAll(l, values));
            }
            return this;
        }

        public ConstraintBuilder dropdown(Collection<String> values) {
            this.constraint.getOrDefault(ConstraintProperty.Dropdown.withValue(new CopyableList())).getAny(CopyableList.class).ifPresent(l -> l.addAll(values));
            return this;
        }

        public Constraint build() {
            return this.constraint;
        }
    }
}

