/*
 * Decompiled with CFR 0.152.
 */
package org.socialsignin.spring.data.dynamodb.repository.util;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapper;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteTableRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeTableResult;
import com.amazonaws.services.dynamodbv2.model.Projection;
import com.amazonaws.services.dynamodbv2.model.ProjectionType;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.TableDescription;
import com.amazonaws.services.dynamodbv2.util.TableUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.socialsignin.spring.data.dynamodb.repository.support.DynamoDBEntityInformation;
import org.socialsignin.spring.data.dynamodb.repository.util.Entity2DDL;
import org.socialsignin.spring.data.dynamodb.repository.util.EntityInformationProxyPostProcessor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ApplicationContextEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.ContextStoppedEvent;
import org.springframework.data.repository.core.support.RepositoryProxyPostProcessor;

public class Entity2DynamoDBTableSynchronizer<T, ID>
extends EntityInformationProxyPostProcessor<T, ID>
implements RepositoryProxyPostProcessor,
ApplicationListener<ApplicationContextEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Entity2DynamoDBTableSynchronizer.class);
    private static final String CONFIGURATION_KEY_entity2ddl_auto = "${spring.data.dynamodb.entity2ddl.auto:none}";
    private static final String CONFIGURATION_KEY_entity2ddl_gsiProjectionType = "${spring.data.dynamodb.entity2ddl.gsiProjectionType:ALL}";
    private static final String CONFIGURATION_KEY_entity2ddl_lsiProjectionType = "${spring.data.dynamodb.entity2ddl.lsiProjectionType:ALL}";
    private static final String CONFIGURATION_KEY_entity2ddl_readCapacity = "${spring.data.dynamodb.entity2ddl.readCapacity:10}";
    private static final String CONFIGURATION_KEY_entity2ddl_writeCapacity = "${spring.data.dynamodb.entity2ddl.writeCapacity:1}";
    private final AmazonDynamoDB amazonDynamoDB;
    private final DynamoDBMapper mapper;
    private final Entity2DDL mode;
    private final ProjectionType gsiProjectionType;
    private final ProjectionType lsiProjectionType;
    private final ProvisionedThroughput pt;
    private final Collection<DynamoDBEntityInformation<T, ID>> registeredEntities = new ArrayList<DynamoDBEntityInformation<T, ID>>();

    public Entity2DynamoDBTableSynchronizer(AmazonDynamoDB amazonDynamoDB, DynamoDBMapper mapper, Entity2DDL mode) {
        this(amazonDynamoDB, mapper, mode.getConfigurationValue(), ProjectionType.ALL.name(), ProjectionType.ALL.name(), 10L, 10L);
    }

    @Autowired
    public Entity2DynamoDBTableSynchronizer(AmazonDynamoDB amazonDynamoDB, DynamoDBMapper mapper, @Value(value="${spring.data.dynamodb.entity2ddl.auto:none}") String mode, @Value(value="${spring.data.dynamodb.entity2ddl.gsiProjectionType:ALL}") String gsiProjectionType, @Value(value="${spring.data.dynamodb.entity2ddl.lsiProjectionType:ALL}") String lsiProjectionType, @Value(value="${spring.data.dynamodb.entity2ddl.readCapacity:10}") long readCapacity, @Value(value="${spring.data.dynamodb.entity2ddl.writeCapacity:1}") long writeCapacity) {
        this.amazonDynamoDB = amazonDynamoDB;
        this.mapper = mapper;
        this.mode = Entity2DDL.fromValue(mode);
        this.pt = new ProvisionedThroughput(Long.valueOf(readCapacity), Long.valueOf(writeCapacity));
        this.gsiProjectionType = ProjectionType.fromValue((String)gsiProjectionType);
        this.lsiProjectionType = ProjectionType.fromValue((String)lsiProjectionType);
    }

    @Override
    protected void registeredEntity(DynamoDBEntityInformation<T, ID> entityInformation) {
        this.registeredEntities.add(entityInformation);
    }

    public void onApplicationEvent(ApplicationContextEvent event) {
        LOGGER.info("Checking repository classes with DynamoDB tables {} for {}", (Object)this.registeredEntities.stream().map(e -> e.getDynamoDBTableName()).collect(Collectors.joining(", ")), (Object)event.getClass().getSimpleName());
        for (DynamoDBEntityInformation<T, ID> entityInformation : this.registeredEntities) {
            try {
                this.synchronize(entityInformation, event);
            }
            catch (TableUtils.TableNeverTransitionedToStateException | InterruptedException e2) {
                throw new RuntimeException("Could not perform Entity2DDL operation " + String.valueOf((Object)this.mode) + " on " + entityInformation.getDynamoDBTableName(), e2);
            }
        }
    }

    protected void synchronize(DynamoDBEntityInformation<T, ID> entityInformation, ApplicationContextEvent event) throws TableUtils.TableNeverTransitionedToStateException, InterruptedException {
        if (event instanceof ContextRefreshedEvent) {
            switch (this.mode) {
                case CREATE_DROP: 
                case CREATE: {
                    this.performDrop(entityInformation);
                }
                case CREATE_ONLY: {
                    this.performCreate(entityInformation);
                    break;
                }
                case VALIDATE: {
                    this.performValidate(entityInformation);
                    break;
                }
                default: {
                    LOGGER.debug("No auto table DDL performed on start");
                    break;
                }
            }
        } else if (event instanceof ContextStoppedEvent) {
            switch (this.mode) {
                case CREATE_DROP: 
                case DROP: {
                    this.performDrop(entityInformation);
                    this.performCreate(entityInformation);
                    break;
                }
                default: {
                    LOGGER.debug("No auto table DDL performed on stop");
                    break;
                }
            }
        } else {
            LOGGER.trace("Ignored ApplicationContextEvent: {}", (Object)event);
        }
    }

    private boolean performCreate(DynamoDBEntityInformation<T, ID> entityInformation) throws TableUtils.TableNeverTransitionedToStateException, InterruptedException {
        boolean result;
        Class domainType = entityInformation.getJavaType();
        CreateTableRequest ctr = this.mapper.generateCreateTableRequest(domainType);
        LOGGER.trace("Creating table {} for entity {}", (Object)ctr.getTableName(), (Object)domainType);
        ctr.setProvisionedThroughput(this.pt);
        if (ctr.getGlobalSecondaryIndexes() != null) {
            ctr.getGlobalSecondaryIndexes().forEach(gsi -> {
                gsi.setProjection(new Projection().withProjectionType(this.gsiProjectionType));
                gsi.setProvisionedThroughput(this.pt);
            });
        }
        if (ctr.getLocalSecondaryIndexes() != null) {
            ctr.getLocalSecondaryIndexes().forEach(lsi -> lsi.setProjection(new Projection().withProjectionType(this.lsiProjectionType)));
        }
        if (result = TableUtils.createTableIfNotExists((AmazonDynamoDB)this.amazonDynamoDB, (CreateTableRequest)ctr)) {
            TableUtils.waitUntilActive((AmazonDynamoDB)this.amazonDynamoDB, (String)ctr.getTableName());
            LOGGER.debug("Created table {} for entity {}", (Object)ctr.getTableName(), (Object)domainType);
        }
        return result;
    }

    private boolean performDrop(DynamoDBEntityInformation<T, ID> entityInformation) {
        Class domainType = entityInformation.getJavaType();
        DeleteTableRequest dtr = this.mapper.generateDeleteTableRequest(domainType);
        LOGGER.trace("Dropping table {} for entity {}", (Object)dtr.getTableName(), (Object)domainType);
        boolean result = TableUtils.deleteTableIfExists((AmazonDynamoDB)this.amazonDynamoDB, (DeleteTableRequest)dtr);
        if (result) {
            LOGGER.debug("Deleted table {} for entity {}", (Object)dtr.getTableName(), (Object)domainType);
        }
        return result;
    }

    private DescribeTableResult performValidate(DynamoDBEntityInformation<T, ID> entityInformation) throws IllegalStateException {
        Class domainType = entityInformation.getJavaType();
        CreateTableRequest expected = this.mapper.generateCreateTableRequest(domainType);
        DescribeTableResult result = this.amazonDynamoDB.describeTable(expected.getTableName());
        TableDescription actual = result.getTable();
        if (!expected.getKeySchema().equals(actual.getKeySchema())) {
            throw new IllegalStateException("KeySchema is not as expected. Expected: <" + String.valueOf(expected.getKeySchema()) + "> but found <" + String.valueOf(actual.getKeySchema()) + ">");
        }
        LOGGER.debug("KeySchema is valid");
        if (expected.getGlobalSecondaryIndexes() != null && !Arrays.deepEquals(expected.getGlobalSecondaryIndexes().toArray(), actual.getGlobalSecondaryIndexes().toArray())) {
            throw new IllegalStateException("Global Secondary Indexes are not as expected. Expected: <" + String.valueOf(expected.getGlobalSecondaryIndexes()) + "> but found <" + String.valueOf(actual.getGlobalSecondaryIndexes()) + ">");
        }
        LOGGER.debug("Global Secondary Indexes are valid");
        LOGGER.info("Validated table {} for entity{}", (Object)expected.getTableName(), (Object)domainType);
        return result;
    }
}

