/*
 * Decompiled with CFR 0.152.
 */
package io.github.mweirauch.micrometer.jvm.extras.procfs;

import io.github.mweirauch.micrometer.jvm.extras.procfs.ProcfsEntry;
import io.github.mweirauch.micrometer.jvm.extras.procfs.ProcfsReader;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ProcfsStatus
extends ProcfsEntry {
    private static final Pattern LINE_PATTERN = Pattern.compile("^\\w+:\\s+(\\d+)$");

    public ProcfsStatus() {
        super(ProcfsReader.getInstance("status"));
    }

    ProcfsStatus(ProcfsReader reader) {
        super(reader);
    }

    @Override
    protected void handle(Map<ProcfsEntry.ValueKey, Double> values, String line) {
        Objects.requireNonNull(values);
        Objects.requireNonNull(line);
        if (line.startsWith("Threads:")) {
            values.put(KEY.THREADS, ProcfsStatus.parseValue(line));
        }
    }

    private static Double parseValue(String line) {
        Objects.requireNonNull(line);
        Matcher matcher = LINE_PATTERN.matcher(line);
        if (!matcher.matches()) {
            return Double.NaN;
        }
        return Double.parseDouble(matcher.group(1));
    }

    public static enum KEY implements ProcfsEntry.ValueKey
    {
        THREADS;

    }
}

