/*
 * Decompiled with CFR 0.152.
 */
package io.github.mweirauch.micrometer.jvm.extras.procfs;

import io.github.mweirauch.micrometer.jvm.extras.procfs.ProcfsEntry;
import io.github.mweirauch.micrometer.jvm.extras.procfs.ProcfsReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ProcfsSmaps
extends ProcfsEntry {
    private static final int KILOBYTE = 1024;

    public ProcfsSmaps() {
        super(ProcfsReader.getInstance("smaps"));
    }

    ProcfsSmaps(ProcfsReader reader) {
        super(reader);
    }

    @Override
    protected Map<ProcfsEntry.ValueKey, Double> handle(Collection<String> lines) {
        Objects.requireNonNull(lines);
        HashMap<ProcfsEntry.ValueKey, Double> values = new HashMap<ProcfsEntry.ValueKey, Double>();
        for (String line : lines) {
            KEY valueKey = null;
            if (line.startsWith("Size:")) {
                valueKey = KEY.VSS;
            } else if (line.startsWith("Rss:")) {
                valueKey = KEY.RSS;
            } else if (line.startsWith("Pss:")) {
                valueKey = KEY.PSS;
            } else if (line.startsWith("Swap:")) {
                valueKey = KEY.SWAP;
            } else if (line.startsWith("SwapPss:")) {
                valueKey = KEY.SWAPPSS;
            }
            if (valueKey == null) continue;
            Double kiloBytes = ProcfsSmaps.parseKiloBytes(line) * 1024.0;
            values.compute(valueKey, (key, value) -> value == null ? kiloBytes : value + kiloBytes);
        }
        return values;
    }

    private static Double parseKiloBytes(String line) {
        Objects.requireNonNull(line);
        return Double.parseDouble(line.split("\\s+")[1]);
    }

    public static enum KEY implements ProcfsEntry.ValueKey
    {
        VSS,
        RSS,
        PSS,
        SWAP,
        SWAPPSS;

    }
}

