/*
 * Decompiled with CFR 0.152.
 */
package io.github.mweirauch.micrometer.jvm.extras.procfs;

import io.github.mweirauch.micrometer.jvm.extras.procfs.ProcfsEntry;
import io.github.mweirauch.micrometer.jvm.extras.procfs.ProcfsReader;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongUnaryOperator;

public class ProcfsSmaps
extends ProcfsEntry {
    private static final int KILOBYTE = 1024;
    private final Map<KEY, AtomicLong> values = new HashMap<KEY, AtomicLong>();

    public ProcfsSmaps() {
        super(ProcfsReader.getInstance("smaps"));
    }

    ProcfsSmaps(ProcfsReader reader) {
        super(reader);
    }

    @Override
    protected void reset() {
        EnumSet.allOf(KEY.class).forEach(key -> this.values.put((KEY)((Object)key), new AtomicLong(-1L)));
    }

    @Override
    protected void handle(Collection<String> lines) {
        Objects.requireNonNull(lines);
        for (String line : lines) {
            if (line.startsWith("Size:")) {
                this.inc(KEY.VSS, ProcfsSmaps.parseKiloBytes(line) * 1024L);
                continue;
            }
            if (line.startsWith("Rss:")) {
                this.inc(KEY.RSS, ProcfsSmaps.parseKiloBytes(line) * 1024L);
                continue;
            }
            if (line.startsWith("Pss:")) {
                this.inc(KEY.PSS, ProcfsSmaps.parseKiloBytes(line) * 1024L);
                continue;
            }
            if (line.startsWith("Swap:")) {
                this.inc(KEY.SWAP, ProcfsSmaps.parseKiloBytes(line) * 1024L);
                continue;
            }
            if (!line.startsWith("SwapPss:")) continue;
            this.inc(KEY.SWAPPSS, ProcfsSmaps.parseKiloBytes(line) * 1024L);
        }
    }

    public Long get(KEY key) {
        Objects.requireNonNull(key);
        this.collect();
        return this.values.get((Object)key).longValue();
    }

    private void inc(KEY key, final long increment) {
        Objects.requireNonNull(key);
        this.values.get((Object)key).getAndUpdate(new LongUnaryOperator(){

            @Override
            public long applyAsLong(long currentValue) {
                return currentValue + increment + (long)(currentValue == -1L ? 1 : 0);
            }
        });
    }

    private static long parseKiloBytes(String line) {
        Objects.requireNonNull(line);
        return Long.parseLong(line.split("\\s+")[1]);
    }

    public static enum KEY {
        VSS,
        RSS,
        PSS,
        SWAP,
        SWAPPSS;

    }
}

