/*
 * Decompiled with CFR 0.152.
 */
package io.github.mweirauch.micrometer.jvm.extras.procfs;

import io.github.mweirauch.micrometer.jvm.extras.procfs.ProcfsReader;
import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ProcfsEntry {
    private static final Logger log = LoggerFactory.getLogger(ProcfsEntry.class);
    private final Object lock = new Object();
    private final ProcfsReader reader;
    private long lastHandle = -1L;

    protected ProcfsEntry(ProcfsReader reader) {
        this.reader = Objects.requireNonNull(reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void collect() {
        Object object = this.lock;
        synchronized (object) {
            try {
                ProcfsReader.ReadResult result = this.reader.read();
                if (result != null && (this.lastHandle == -1L || this.lastHandle != result.getReadTime())) {
                    this.reset();
                    this.handle(result.getLines());
                    this.lastHandle = result.getReadTime();
                }
            }
            catch (IOException e) {
                this.reset();
                log.warn("Failed reading '" + this.reader.getEntryPath() + "'!", (Throwable)e);
            }
        }
    }

    protected abstract void reset();

    protected abstract void handle(Collection<String> var1);
}

