/*
 * Decompiled with CFR 0.152.
 */
package io.github.mightguy.spellcheck.symspell.impl;

import io.github.mightguy.spellcheck.symspell.api.DataHolder;
import io.github.mightguy.spellcheck.symspell.api.SpellChecker;
import io.github.mightguy.spellcheck.symspell.api.StringDistance;
import io.github.mightguy.spellcheck.symspell.common.Composition;
import io.github.mightguy.spellcheck.symspell.common.SpellCheckSettings;
import io.github.mightguy.spellcheck.symspell.common.SpellHelper;
import io.github.mightguy.spellcheck.symspell.common.SuggestionItem;
import io.github.mightguy.spellcheck.symspell.common.Verbosity;
import io.github.mightguy.spellcheck.symspell.exception.SpellCheckException;
import io.github.mightguy.spellcheck.symspell.exception.SpellCheckExceptionCode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class SymSpellCheck
extends SpellChecker {
    private static Long nMax = 1024908267229L;

    public SymSpellCheck(DataHolder dataHolder, StringDistance stringDistance, SpellCheckSettings spellCheckSettings) {
        super(dataHolder, stringDistance, spellCheckSettings);
    }

    @Override
    public List<SuggestionItem> lookupCompound(String phrase, double maxEditDistance, boolean tokenizeOnWhiteSpace) throws SpellCheckException {
        if (maxEditDistance > this.spellCheckSettings.getMaxEditDistance()) {
            throw new SpellCheckException(SpellCheckExceptionCode.LOOKUP_ERROR, "max Edit distance should be less than  global Max i.e" + this.spellCheckSettings.getMaxEditDistance());
        }
        if (StringUtils.isEmpty((CharSequence)phrase)) {
            throw new SpellCheckException(SpellCheckExceptionCode.LOOKUP_ERROR, "Invalid input of string");
        }
        if (this.spellCheckSettings.isLowerCaseTerms()) {
            phrase = phrase.toLowerCase();
        }
        String[] items = tokenizeOnWhiteSpace ? SpellHelper.tokenizeOnWhiteSpace(phrase) : new String[]{phrase};
        List<SuggestionItem> suggestions = new ArrayList<SuggestionItem>();
        ArrayList<SuggestionItem> suggestionParts = new ArrayList<SuggestionItem>();
        boolean isLastCombi = false;
        if (StringUtils.isNotEmpty((CharSequence)this.dataHolder.getExclusionItem(phrase))) {
            return SpellHelper.earlyExit(suggestions, this.dataHolder.getExclusionItem(phrase), maxEditDistance, false);
        }
        for (int i = 0; i < items.length; ++i) {
            suggestions = this.lookup(items[i], Verbosity.TOP, maxEditDistance);
            if (i > 0 && !isLastCombi && this.lookupCombineWords(items[i], items[i - 1], suggestions, suggestionParts, maxEditDistance)) {
                isLastCombi = true;
                continue;
            }
            isLastCombi = false;
            if (CollectionUtils.isNotEmpty(suggestions) && (suggestions.get(0).getDistance() == 0.0 || items[i].length() == 1)) {
                suggestionParts.add(suggestions.get(0));
                continue;
            }
            this.lookupSplitWords(suggestionParts, suggestions, items[i], maxEditDistance);
        }
        String joinedTerm = "";
        double joinedCount = Double.MAX_VALUE;
        for (SuggestionItem si : suggestionParts) {
            joinedTerm = joinedTerm.concat(si.getTerm()).concat(" ");
            joinedCount = Math.min(joinedCount, si.getCount());
        }
        joinedTerm = joinedTerm.trim();
        double dist = this.stringDistance.getDistance(joinedTerm, phrase, Math.pow(2.0, 31.0) - 1.0);
        SuggestionItem suggestionItem = new SuggestionItem(joinedTerm, dist, joinedCount);
        return Collections.singletonList(suggestionItem);
    }

    private boolean lookupCombineWords(String token, String previousToken, List<SuggestionItem> suggestions, List<SuggestionItem> suggestionParts, double maxEditDistance) throws SpellCheckException {
        List<SuggestionItem> suggestionsCombi = this.lookup(previousToken + token, Verbosity.TOP, maxEditDistance);
        if (CollectionUtils.isEmpty(suggestionsCombi)) {
            return false;
        }
        SuggestionItem best1 = suggestionParts.get(suggestionParts.size() - 1);
        SuggestionItem best2 = CollectionUtils.isNotEmpty(suggestions) ? suggestions.get(0) : new SuggestionItem(token, maxEditDistance + 1.0, 0.0);
        double editDistance = this.stringDistance.getDistance(best1.getTerm().concat(" ").concat(best2.getTerm()), previousToken.concat(" ").concat(token), maxEditDistance);
        if (editDistance >= 0.0 && suggestionsCombi.get(0).getDistance() < editDistance) {
            suggestionsCombi.get(0).setDistance(suggestionsCombi.get(0).getDistance() + 1.0);
            suggestionParts.remove(suggestionParts.size() - 1);
            suggestionParts.add(suggestionsCombi.get(0));
            return true;
        }
        return false;
    }

    private void lookupSplitWords(List<SuggestionItem> suggestionParts, List<SuggestionItem> suggestions, String word, double maxEditDistance) throws SpellCheckException {
        SuggestionItem suggestionSplitBest = null;
        if (CollectionUtils.isNotEmpty(suggestions)) {
            suggestionSplitBest = suggestions.get(0);
        }
        if (word.length() <= 1) {
            suggestionParts.add(new SuggestionItem(word, maxEditDistance + 1.0, 0.0));
            return;
        }
        for (int j = 1; j < word.length(); ++j) {
            double count;
            Double bigramFreq;
            List<SuggestionItem> suggestions2;
            String part1 = word.substring(0, j);
            String part2 = word.substring(j);
            List<SuggestionItem> suggestions1 = this.lookup(part1, Verbosity.TOP, maxEditDistance);
            if (SpellHelper.continueConditionIfHeadIsSame(suggestions, suggestions1) || SpellHelper.continueConditionIfHeadIsSame(suggestions, suggestions2 = this.lookup(part2, Verbosity.TOP, maxEditDistance))) continue;
            String split = suggestions1.get(0).getTerm() + " " + suggestions2.get(0).getTerm();
            double splitDistance = this.stringDistance.getDistance(word, split, maxEditDistance);
            if (splitDistance < 0.0) {
                splitDistance = maxEditDistance + 1.0;
            }
            if (suggestionSplitBest != null) {
                if (splitDistance > suggestionSplitBest.getDistance()) continue;
                if (splitDistance < suggestionSplitBest.getDistance()) {
                    suggestionSplitBest = null;
                }
            }
            if ((bigramFreq = this.dataHolder.getItemFrequencyBiGram(split)) != null) {
                count = bigramFreq;
                if (CollectionUtils.isNotEmpty(suggestions)) {
                    if ((suggestions1.get(0).getTerm() + suggestions2.get(0).getTerm()).equals(word)) {
                        count = Math.max(count, suggestions.get(0).getCount() + 2.0);
                    } else if (suggestions1.get(0).getTerm() == suggestions.get(0).getTerm() || suggestions2.get(0).getTerm().equals(suggestions.get(0).getTerm())) {
                        count = Math.max(count, suggestions.get(0).getCount() + 1.0);
                    }
                } else if ((suggestions1.get(0).getTerm() + suggestions2.get(0).getTerm()).equals(word)) {
                    count = Math.max(count, Math.max(suggestions1.get(0).getCount(), suggestions2.get(0).getCount()));
                }
            } else {
                count = Math.min(this.spellCheckSettings.getBigramCountMin(), suggestions1.get(0).getCount() / (double)nMax.longValue() * suggestions2.get(0).getCount());
            }
            SuggestionItem suggestionSplit = new SuggestionItem(split, splitDistance, count);
            if (suggestionSplitBest != null && !(suggestionSplit.getCount() > suggestionSplitBest.getCount())) continue;
            suggestionSplitBest = suggestionSplit;
        }
        if (suggestionSplitBest != null) {
            suggestionParts.add(suggestionSplitBest);
        } else {
            suggestionParts.add(new SuggestionItem(word, maxEditDistance + 1.0, 0.0));
        }
    }

    @Override
    public List<SuggestionItem> lookup(String phrase, Verbosity verbosity, double maxEditDistance) throws SpellCheckException {
        int phrasePrefixLen;
        if (maxEditDistance <= 0.0) {
            maxEditDistance = this.spellCheckSettings.getMaxEditDistance();
        }
        if (maxEditDistance > this.spellCheckSettings.getMaxEditDistance()) {
            throw new SpellCheckException(SpellCheckExceptionCode.LOOKUP_ERROR, "max Edit distance should be less than  global Max i.e" + this.spellCheckSettings.getMaxEditDistance());
        }
        int phraseLen = phrase.length();
        if (this.spellCheckSettings.isLowerCaseTerms()) {
            phrase = phrase.toLowerCase();
        }
        double suggestionCount = 0.0;
        HashSet<String> consideredDeletes = new HashSet<String>();
        HashSet<String> consideredSuggestions = new HashSet<String>();
        ArrayList<SuggestionItem> suggestionItems = new ArrayList<SuggestionItem>(this.spellCheckSettings.getTopK());
        if (StringUtils.isNotEmpty((CharSequence)this.dataHolder.getExclusionItem(phrase))) {
            return SpellHelper.earlyExit(suggestionItems, this.dataHolder.getExclusionItem(phrase), maxEditDistance, false);
        }
        if ((double)phraseLen - maxEditDistance > (double)this.spellCheckSettings.getMaxLength()) {
            return SpellHelper.earlyExit(suggestionItems, phrase, maxEditDistance, this.spellCheckSettings.isIgnoreUnknown());
        }
        Double frequency = this.dataHolder.getItemFrequency(phrase);
        if (frequency != null) {
            suggestionCount = frequency;
            suggestionItems.add(new SuggestionItem(phrase, 0.0, suggestionCount));
            if (verbosity != Verbosity.ALL) {
                return SpellHelper.earlyExit(suggestionItems, phrase, maxEditDistance, this.spellCheckSettings.isIgnoreUnknown());
            }
        }
        consideredSuggestions.add(phrase);
        double maxEditDistance2 = maxEditDistance;
        ArrayList<String> candidates = new ArrayList<String>();
        if (phraseLen > this.spellCheckSettings.getPrefixLength()) {
            phrasePrefixLen = this.spellCheckSettings.getPrefixLength();
            candidates.add(phrase.substring(0, phrasePrefixLen));
        } else {
            phrasePrefixLen = phraseLen;
        }
        candidates.add(phrase);
        while (CollectionUtils.isNotEmpty(candidates)) {
            String candidate = (String)candidates.remove(0);
            int candidateLen = candidate.length();
            int lenDiff = phraseLen - candidateLen;
            if ((double)lenDiff > maxEditDistance2) {
                if (verbosity != Verbosity.ALL) break;
                continue;
            }
            String[] deletes = this.dataHolder.getDeletes(candidate);
            if (deletes != null && deletes.length > 0) {
                for (String suggestion : deletes) {
                    if (this.filterOnEquivalance(suggestion, phrase, candidate, maxEditDistance2) || this.filterOnPrefixLen(suggestion.length(), this.spellCheckSettings.getPrefixLength(), phrasePrefixLen, candidate.length(), maxEditDistance2)) continue;
                    double distance = 0.0;
                    int minDistance = 0;
                    if (candidateLen == 0) {
                        distance = Math.max(phraseLen, suggestion.length());
                        if (distance > maxEditDistance2 || !consideredSuggestions.add(suggestion)) {
                            continue;
                        }
                    } else if (suggestion.length() == 1) {
                        double d = distance = phrase.indexOf(suggestion.charAt(0)) < 0 ? (double)phraseLen : (double)(phraseLen - 1);
                        if (distance > maxEditDistance2 || !consideredSuggestions.add(suggestion)) {
                            continue;
                        }
                    } else {
                        minDistance = this.getMinDistanceOnPrefixbasis(maxEditDistance, candidate, phrase, suggestion);
                        if (this.isDistanceCalculationRequired(phrase, maxEditDistance, minDistance, suggestion, candidate) || verbosity != Verbosity.ALL && !this.deleteInSuggestionPrefix(candidate, candidateLen, suggestion, suggestion.length()) || !consideredSuggestions.add(suggestion) || (distance = this.stringDistance.getDistance(phrase, suggestion, maxEditDistance2)) < 0.0) continue;
                    }
                    if (!SpellHelper.isLessOrEqualDouble(distance, maxEditDistance2, 0.01)) continue;
                    suggestionCount = this.dataHolder.getItemFrequency(suggestion);
                    SuggestionItem si = new SuggestionItem(suggestion, distance, suggestionCount);
                    if (CollectionUtils.isNotEmpty(suggestionItems)) {
                        if (verbosity == Verbosity.CLOSEST && distance < maxEditDistance2) {
                            suggestionItems.clear();
                        } else if (verbosity == Verbosity.TOP) {
                            if (!SpellHelper.isLessDouble(distance, maxEditDistance2, 0.01) && !(suggestionCount > ((SuggestionItem)suggestionItems.get(0)).getCount())) continue;
                            maxEditDistance2 = distance;
                            suggestionItems.set(0, si);
                            continue;
                        }
                    }
                    if (verbosity != Verbosity.ALL) {
                        maxEditDistance2 = distance;
                    }
                    suggestionItems.add(si);
                }
            }
            if (!((double)lenDiff < maxEditDistance) || candidateLen > this.spellCheckSettings.getPrefixLength() || verbosity != Verbosity.ALL && (double)lenDiff >= maxEditDistance2) continue;
            for (int i = 0; i < candidateLen; ++i) {
                String delete = candidate.substring(0, i) + candidate.substring(i + 1, candidateLen);
                if (!consideredDeletes.add(delete)) continue;
                candidates.add(delete);
            }
        }
        return suggestionItems;
    }

    private int getMinDistanceOnPrefixbasis(double maxEditDistance, String candidate, String phrase, String suggestion) {
        if ((double)this.spellCheckSettings.getPrefixLength() - maxEditDistance == (double)candidate.length()) {
            return Math.min(phrase.length(), suggestion.length()) - this.spellCheckSettings.getPrefixLength();
        }
        return 0;
    }

    private boolean filterOnPrefixLen(int suggestionLen, int prefixLen, int phrasePrefixLen, int candidateLen, double maxEditDistance2) {
        int suggestionPrefixLen = Math.min(suggestionLen, prefixLen);
        return suggestionPrefixLen > phrasePrefixLen && (double)(suggestionPrefixLen - candidateLen) > maxEditDistance2;
    }

    private boolean filterOnEquivalance(String delete, String phrase, String candidate, double maxEditDistance2) {
        return delete.equals(phrase) || (double)Math.abs(delete.length() - phrase.length()) > maxEditDistance2 || delete.length() < candidate.length() || delete.length() == candidate.length() && !delete.equals(candidate);
    }

    private boolean deleteInSuggestionPrefix(String delete, int deleteLen, String suggestion, int suggestionLen) {
        if (deleteLen == 0) {
            return true;
        }
        if (this.spellCheckSettings.getPrefixLength() < suggestionLen) {
            suggestionLen = this.spellCheckSettings.getPrefixLength();
        }
        int j = 0;
        for (int i = 0; i < deleteLen; ++i) {
            char delChar = delete.charAt(i);
            while (j < suggestionLen && delChar != suggestion.charAt(j)) {
                ++j;
            }
            if (j != suggestionLen) continue;
            return false;
        }
        return true;
    }

    private boolean isDistanceCalculationRequired(String phrase, double maxEditDistance, int min, String suggestion, String candidate) {
        return (double)phrase.length() - maxEditDistance == (double)candidate.length() && min > 1 && !phrase.substring(phrase.length() + 1 - min).equals(suggestion.substring(suggestion.length() + 1 - min)) || min > 0 && phrase.charAt(phrase.length() - min) != suggestion.charAt(suggestion.length() - min) && phrase.charAt(phrase.length() - min - 1) != suggestion.charAt(suggestion.length() - min) && phrase.charAt(phrase.length() - min) != suggestion.charAt(suggestion.length() - min - 1);
    }

    @Override
    public Composition wordBreakSegmentation(String phrase, int maxSegmentationWordLength, double maxEditDistance) throws SpellCheckException {
        if (phrase.isEmpty()) {
            return new Composition();
        }
        if (this.spellCheckSettings.isLowerCaseTerms()) {
            phrase = phrase.toLowerCase();
        }
        if (StringUtils.isNotEmpty((CharSequence)this.dataHolder.getExclusionItem(phrase))) {
            return new Composition(phrase, this.dataHolder.getExclusionItem(phrase), 0, 0.0);
        }
        int arraySize = Math.min(maxSegmentationWordLength, phrase.length());
        Composition[] compositions = new Composition[arraySize];
        for (int i = 0; i < arraySize; ++i) {
            compositions[i] = new Composition();
        }
        int circularIndex = -1;
        for (int j = 0; j < phrase.length(); ++j) {
            int imax = Math.min(phrase.length() - j, maxSegmentationWordLength);
            for (int i = 1; i <= imax; ++i) {
                double topProbabilityLog;
                String topResult;
                String part = phrase.substring(j, j + i);
                int separatorLength = 0;
                int topEd = 0;
                if (Character.isWhitespace(part.charAt(0))) {
                    part = part.substring(1);
                } else {
                    separatorLength = 1;
                }
                topEd += part.length();
                part = part.replace(" ", "");
                topEd -= part.length();
                List<SuggestionItem> results = this.lookup(part, Verbosity.TOP, maxEditDistance);
                if (CollectionUtils.isNotEmpty(results)) {
                    topResult = results.get(0).getTerm();
                    topEd = (int)((double)topEd + results.get(0).getDistance());
                    topProbabilityLog = Math.log10(results.get(0).getCount() / (double)nMax.longValue());
                } else {
                    topResult = part;
                    topEd += part.length();
                    topProbabilityLog = Math.log10(10.0 / ((double)nMax.longValue() * Math.pow(10.0, part.length())));
                }
                int destinationIndex = (i + circularIndex) % arraySize;
                if (j == 0) {
                    compositions[destinationIndex].setSegmentedString(part);
                    compositions[destinationIndex].setCorrectedString(topResult);
                    compositions[destinationIndex].setDistanceSum(topEd);
                    compositions[destinationIndex].setLogProbSum(topProbabilityLog);
                    continue;
                }
                if (i != maxSegmentationWordLength && (compositions[circularIndex].getDistanceSum() + topEd != compositions[destinationIndex].getDistanceSum() && compositions[circularIndex].getDistanceSum() + separatorLength + topEd != compositions[destinationIndex].getDistanceSum() || !(compositions[destinationIndex].getLogProbSum() < compositions[circularIndex].getLogProbSum() + topProbabilityLog)) && compositions[circularIndex].getDistanceSum() + separatorLength + topEd >= compositions[destinationIndex].getDistanceSum()) continue;
                compositions[destinationIndex].setSegmentedString(compositions[circularIndex].getSegmentedString() + " " + part);
                compositions[destinationIndex].setCorrectedString(compositions[circularIndex].getCorrectedString() + " " + topResult);
                compositions[destinationIndex].setDistanceSum(compositions[circularIndex].getDistanceSum() + topEd);
                compositions[destinationIndex].setLogProbSum(compositions[circularIndex].getLogProbSum() + topProbabilityLog);
            }
            if (++circularIndex < arraySize) continue;
            circularIndex = 0;
        }
        return compositions[circularIndex];
    }
}

