/*
 * Decompiled with CFR 0.152.
 */
package io.github.mightguy.spellcheck.symspell.common;

import io.github.mightguy.spellcheck.symspell.common.SuggestionItem;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;

public final class SpellHelper {
    private SpellHelper() {
    }

    public static Set<String> getEditDeletes(String key, double maxEditDistance, int prefixLength, double editFactor) {
        HashSet<String> deletedWords = new HashSet<String>();
        if ((double)key.length() <= maxEditDistance) {
            deletedWords.add("");
        }
        if ((double)key.length() > maxEditDistance) {
            deletedWords.add(key.substring(0, prefixLength < key.length() ? prefixLength : key.length()));
        }
        return SpellHelper.edits(key, 0.0, deletedWords, SpellHelper.getEdistance(maxEditDistance, key.length(), editFactor));
    }

    private static Double getEdistance(double maxEditDistance, int length, double factor) {
        double computedEd = Math.round(factor * (double)length);
        if (Math.min(maxEditDistance, computedEd) == maxEditDistance) {
            return maxEditDistance;
        }
        return computedEd;
    }

    public static Set<String> edits(String word, double editDistance, Set<String> deletedWords, Double maxEd) {
        editDistance += 1.0;
        if (word.length() < 1) {
            return deletedWords;
        }
        for (int i = 0; i < word.length(); ++i) {
            String delete = word.substring(0, i) + word.substring(i + 1, word.length());
            if (!deletedWords.add(delete) || !(editDistance < maxEd)) continue;
            SpellHelper.edits(delete, editDistance, deletedWords, maxEd);
        }
        deletedWords.add(word);
        return deletedWords;
    }

    public static List<SuggestionItem> earlyExit(List<SuggestionItem> suggestionItems, String phrase, double maxEditDistance, boolean ignoreUnknown) {
        if (CollectionUtils.isEmpty(suggestionItems) && !ignoreUnknown) {
            suggestionItems.add(new SuggestionItem(phrase, maxEditDistance + 1.0, 0.0));
        }
        return suggestionItems;
    }

    public static String[] tokenizeOnWhiteSpace(String word) {
        return word.split("\\s+");
    }

    public static boolean isLessOrEqualDouble(double d1, double d2, double threshold) {
        return Math.abs(d1 - d2) < threshold || d1 < d2;
    }

    public static boolean isLessDouble(double d1, double d2, double threshold) {
        return !SpellHelper.isEqualDouble(d1, d2, threshold) && d1 < d2;
    }

    public static boolean isEqualDouble(double d1, double d2, double threshold) {
        return Math.abs(d1 - d2) < threshold;
    }

    public static boolean continueConditionIfHeadIsSame(List<SuggestionItem> suggestions, List<SuggestionItem> suggestions1) {
        return CollectionUtils.isEmpty(suggestions1) || CollectionUtils.isNotEmpty(suggestions) && CollectionUtils.isNotEmpty(suggestions1) && suggestions.get(0).equals(suggestions1.get(0));
    }
}

