/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.openapi;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.github.microcks.util.JsonSchemaValidator;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

public class OpenAPISchemaBuilder {
    public static final String JSON_SCHEMA_TYPE = "type";
    public static final String JSON_SCHEMA_ITEMS = "items";
    public static final String JSON_SCHEMA_OBJECT_TYPE = "object";
    public static final String JSON_SCHEMA_ARRAY_TYPE = "array";
    public static final String JSON_SCHEMA_PROPERTIES = "properties";

    public static JsonNode buildTypeSchemaFromJson(String jsonText) throws IOException {
        return OpenAPISchemaBuilder.buildTypeSchemaFromJson(JsonSchemaValidator.getJsonNode(jsonText));
    }

    public static JsonNode buildTypeSchemaFromJson(JsonNode node) {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode schemaNode = mapper.createObjectNode();
        OpenAPISchemaBuilder.traverseNode(node, schemaNode, mapper);
        return schemaNode;
    }

    private static void traverseNode(JsonNode currentNode, ObjectNode parentNodeSchemaNode, ObjectMapper mapper) {
        switch (currentNode.getNodeType()) {
            case OBJECT: {
                parentNodeSchemaNode.put(JSON_SCHEMA_TYPE, JSON_SCHEMA_OBJECT_TYPE);
                ObjectNode propertiesNodeSchemaNode = parentNodeSchemaNode.putObject(JSON_SCHEMA_PROPERTIES);
                Iterator fieldsNodes = currentNode.fields();
                while (fieldsNodes.hasNext()) {
                    Map.Entry fieldsNode = (Map.Entry)fieldsNodes.next();
                    ObjectNode fieldNodeSchemaNode = propertiesNodeSchemaNode.putObject((String)fieldsNode.getKey());
                    OpenAPISchemaBuilder.traverseNode((JsonNode)fieldsNode.getValue(), fieldNodeSchemaNode, mapper);
                }
                break;
            }
            case ARRAY: {
                parentNodeSchemaNode.put(JSON_SCHEMA_TYPE, JSON_SCHEMA_ARRAY_TYPE);
                ObjectNode itemsNodeSchemaNode = parentNodeSchemaNode.putObject(JSON_SCHEMA_ITEMS);
                JsonNode firstChild = (JsonNode)((ArrayNode)currentNode).elements().next();
                OpenAPISchemaBuilder.traverseNode(firstChild, itemsNodeSchemaNode, mapper);
                break;
            }
            default: {
                parentNodeSchemaNode.put(JSON_SCHEMA_TYPE, OpenAPISchemaBuilder.getJsonSchemaScalarType(currentNode.getNodeType()));
            }
        }
    }

    private static String getJsonSchemaScalarType(JsonNodeType nodeType) {
        switch (nodeType) {
            case STRING: {
                return "string";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case NUMBER: {
                return "number";
            }
        }
        return nodeType.toString().toLowerCase();
    }
}

