/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util;

import io.github.microcks.util.MalformedXmlException;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlUtil {
    public static final String XML_SCHEMA_NS = "http://www.w3.org/2001/XMLSchema";
    public static final String WSDL_NS = "http://schemas.xmlsoap.org/wsdl/";

    private XmlUtil() {
    }

    public static List<Element> getDirectChildren(Element parent, String namespace, String tag) {
        ArrayList<Element> directChildren = new ArrayList<Element>();
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !namespace.equals(child.getNamespaceURI()) || !tag.equals(child.getLocalName())) continue;
            directChildren.add((Element)child);
        }
        return directChildren;
    }

    public static Element getUniqueDirectChild(Element parent, String namespace, String tag) throws MalformedXmlException {
        NodeList children = parent.getElementsByTagNameNS(namespace, tag);
        if (children.getLength() == 0) {
            throw new MalformedXmlException("Element " + tag + " is missing under " + parent.getTagName());
        }
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || child.getParentNode() != parent) continue;
            return (Element)child;
        }
        throw new MalformedXmlException("Element " + tag + " was expected directly under " + parent.getTagName());
    }

    public static boolean hasDirectChild(Element parent, String namespace, String tag) {
        NodeList children = parent.getElementsByTagNameNS(namespace, tag);
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || child.getParentNode() != parent) continue;
            return true;
        }
        return false;
    }
}

