/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.graphql;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import graphql.analysis.QueryVisitor;
import graphql.analysis.QueryVisitorFieldEnvironment;
import graphql.analysis.QueryVisitorFragmentSpreadEnvironment;
import graphql.analysis.QueryVisitorInlineFragmentEnvironment;
import graphql.language.Type;
import graphql.language.TypeName;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLEnumValueDefinition;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.idl.ScalarInfo;
import graphql.schema.idl.TypeInfo;
import graphql.schema.idl.TypeUtil;

public class JsonSchemaBuilderQueryVisitor
implements QueryVisitor {
    public static final String JSON_SCHEMA_TYPE = "type";
    public static final String JSON_SCHEMA_ENUM = "enum";
    public static final String JSON_SCHEMA_ITEMS = "items";
    public static final String JSON_SCHEMA_OBJECT_TYPE = "object";
    public static final String JSON_SCHEMA_ARRAY_TYPE = "array";
    public static final String JSON_SCHEMA_STRING_TYPE = "string";
    public static final String JSON_SCHEMA_REQUIRED = "required";
    public static final String JSON_SCHEMA_PROPERTIES = "properties";
    public static final String JSON_SCHEMA_ADDITIONAL_PROPERTIES = "additionalProperties";
    private ObjectNode parentNode;
    private ObjectNode currentNode;

    public JsonSchemaBuilderQueryVisitor(ObjectNode jsonSchemaData) {
        this.parentNode = jsonSchemaData;
        this.currentNode = (ObjectNode)jsonSchemaData.path(JSON_SCHEMA_PROPERTIES);
    }

    public void visitField(QueryVisitorFieldEnvironment queryVisitorFieldEnvironment) {
        ArrayNode required = this.getRequiredArrayNode();
        required.add(queryVisitorFieldEnvironment.getFieldDefinition().getName());
        GraphQLOutputType outputType = queryVisitorFieldEnvironment.getFieldDefinition().getType();
        Type definitionType = queryVisitorFieldEnvironment.getFieldDefinition().getDefinition().getType();
        if (TypeUtil.isNonNull((Type)definitionType)) {
            definitionType = TypeUtil.unwrapOne((Type)definitionType);
        }
        ObjectNode fieldNode = this.currentNode.putObject(queryVisitorFieldEnvironment.getFieldDefinition().getName());
        TypeInfo definitionTypeInfo = TypeInfo.typeInfo((Type)definitionType);
        if (ScalarInfo.isGraphqlSpecifiedScalar((String)definitionTypeInfo.getName())) {
            fieldNode.put(JSON_SCHEMA_TYPE, this.getJsonScalarType(definitionTypeInfo.getName()));
        } else if (outputType instanceof GraphQLObjectType) {
            fieldNode.put(JSON_SCHEMA_TYPE, JSON_SCHEMA_OBJECT_TYPE);
            ObjectNode properties = fieldNode.putObject(JSON_SCHEMA_PROPERTIES);
            this.parentNode.put(JSON_SCHEMA_ADDITIONAL_PROPERTIES, false);
            fieldNode.put(JSON_SCHEMA_ADDITIONAL_PROPERTIES, false);
            this.parentNode = fieldNode;
            this.currentNode = properties;
        } else if (TypeUtil.isList((Type)definitionType)) {
            fieldNode.put(JSON_SCHEMA_TYPE, JSON_SCHEMA_ARRAY_TYPE);
            ObjectNode items = fieldNode.putObject(JSON_SCHEMA_ITEMS);
            TypeName itemTypeInfo = TypeUtil.unwrapAll((Type)definitionType);
            if (!ScalarInfo.isGraphqlSpecifiedScalar((String)itemTypeInfo.getName())) {
                items.put(JSON_SCHEMA_TYPE, JSON_SCHEMA_OBJECT_TYPE);
                ObjectNode properties = items.putObject(JSON_SCHEMA_PROPERTIES);
                items.put(JSON_SCHEMA_ADDITIONAL_PROPERTIES, false);
                this.parentNode = items;
                this.currentNode = properties;
            }
        } else if (outputType instanceof GraphQLEnumType) {
            GraphQLEnumType enumType = (GraphQLEnumType)outputType;
            fieldNode.put(JSON_SCHEMA_TYPE, JSON_SCHEMA_STRING_TYPE);
            ArrayNode enumNode = fieldNode.putArray(JSON_SCHEMA_ENUM);
            for (GraphQLEnumValueDefinition valDef : enumType.getValues()) {
                enumNode.add(valDef.getName());
            }
        }
    }

    public void visitInlineFragment(QueryVisitorInlineFragmentEnvironment queryVisitorInlineFragmentEnvironment) {
    }

    public void visitFragmentSpread(QueryVisitorFragmentSpreadEnvironment queryVisitorFragmentSpreadEnvironment) {
    }

    private ArrayNode getRequiredArrayNode() {
        JsonNode required = this.parentNode.get(JSON_SCHEMA_REQUIRED);
        if (required == null) {
            required = this.parentNode.putArray(JSON_SCHEMA_REQUIRED);
        }
        return (ArrayNode)required;
    }

    private String getJsonScalarType(String graphqlScalarType) {
        switch (graphqlScalarType) {
            case "Int": {
                return "integer";
            }
            case "Float": {
                return "number";
            }
            case "ID": {
                return JSON_SCHEMA_STRING_TYPE;
            }
        }
        return graphqlScalarType.toLowerCase();
    }
}

