/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.avro.AvroTypeException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.JsonDecoder;

public class AvroUtil {
    private AvroUtil() {
    }

    public static Schema getSchema(String avroSchema) {
        return new Schema.Parser().parse(avroSchema);
    }

    public static byte[] jsonToAvro(String json, String avroSchema) throws AvroTypeException, IOException {
        return AvroUtil.jsonToAvro(json, AvroUtil.getSchema(avroSchema));
    }

    public static byte[] jsonToAvro(String json, Schema avroSchema) throws AvroTypeException, IOException {
        if (avroSchema.isUnion()) {
            for (Schema schema : avroSchema.getTypes()) {
                try {
                    return AvroUtil.jsonToAvro(json, schema);
                }
                catch (AvroTypeException avroTypeException) {
                }
            }
            throw new AvroTypeException("No schema in union matches JSON data");
        }
        GenericDatumReader reader = new GenericDatumReader(avroSchema);
        ByteArrayInputStream input = new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8));
        JsonDecoder jsonDecoder = DecoderFactory.get().jsonDecoder(avroSchema, (InputStream)input);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GenericDatumWriter writer = new GenericDatumWriter(avroSchema);
        BinaryEncoder e = EncoderFactory.get().binaryEncoder((OutputStream)baos, null);
        GenericRecord datum = (GenericRecord)reader.read(null, (Decoder)jsonDecoder);
        writer.write((Object)datum, (Encoder)e);
        e.flush();
        return baos.toByteArray();
    }

    public static GenericRecord jsonToAvroRecord(String json, String avroSchema) throws AvroTypeException, IOException {
        return AvroUtil.jsonToAvroRecord(json, AvroUtil.getSchema(avroSchema));
    }

    public static GenericRecord jsonToAvroRecord(String json, Schema avroSchema) throws AvroTypeException, IOException {
        if (avroSchema.isUnion()) {
            for (Schema schema : avroSchema.getTypes()) {
                try {
                    return AvroUtil.jsonToAvroRecord(json, schema);
                }
                catch (AvroTypeException avroTypeException) {
                }
            }
            throw new AvroTypeException("No schema in union matches JSON data");
        }
        GenericDatumReader reader = new GenericDatumReader(avroSchema);
        ByteArrayInputStream input = new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8));
        JsonDecoder jsonDecoder = DecoderFactory.get().jsonDecoder(avroSchema, (InputStream)input);
        return (GenericRecord)reader.read(null, (Decoder)jsonDecoder);
    }

    public static String avroToJson(byte[] avroBinary, String avroSchema) throws AvroTypeException, IOException {
        return AvroUtil.avroToJson(avroBinary, AvroUtil.getSchema(avroSchema));
    }

    public static String avroToJson(byte[] avroBinary, Schema avroSchema) throws AvroTypeException, IOException {
        if (avroSchema.isUnion()) {
            for (Schema schema : avroSchema.getTypes()) {
                try {
                    return AvroUtil.avroToJson(avroBinary, schema);
                }
                catch (AvroTypeException avroTypeException) {
                }
            }
            throw new AvroTypeException("No schema in union matches Avro binary data");
        }
        GenericDatumReader datumReader = new GenericDatumReader(avroSchema);
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(avroBinary, null);
        GenericRecord genRecord = (GenericRecord)datumReader.read(null, (Decoder)decoder);
        return genRecord.toString();
    }

    public static GenericRecord avroToAvroRecord(byte[] avroBinary, String avroSchema) throws AvroTypeException, IOException {
        return AvroUtil.avroToAvroRecord(avroBinary, AvroUtil.getSchema(avroSchema));
    }

    public static GenericRecord avroToAvroRecord(byte[] avroBinary, Schema avroSchema) throws AvroTypeException, IOException {
        if (avroSchema.isUnion()) {
            for (Schema schema : avroSchema.getTypes()) {
                try {
                    return AvroUtil.avroToAvroRecord(avroBinary, schema);
                }
                catch (AvroTypeException avroTypeException) {
                }
            }
            throw new AvroTypeException("No schema in union matches Avro binary data");
        }
        GenericDatumReader datumReader = new GenericDatumReader(avroSchema);
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(avroBinary, null);
        return (GenericRecord)datumReader.read(null, (Decoder)decoder);
    }

    public static boolean validate(Schema schema, Object datum) {
        switch (schema.getType()) {
            case RECORD: {
                if (!(datum instanceof GenericRecord)) break;
                GenericRecord genericRecord = (GenericRecord)datum;
                for (Schema.Field f : schema.getFields()) {
                    if (!genericRecord.hasField(f.name())) {
                        return false;
                    }
                    if (AvroUtil.validate(f.schema(), genericRecord.get(f.pos()))) continue;
                    return false;
                }
                return true;
            }
        }
        return GenericData.get().validate(schema, datum);
    }

    public static List<String> getValidationErrors(Schema schema, Object datum, String ... fieldName) {
        ArrayList<String> errors = new ArrayList<String>();
        switch (schema.getType()) {
            case RECORD: {
                if (!(datum instanceof GenericRecord)) break;
                GenericRecord genericRecord = (GenericRecord)datum;
                for (Schema.Field f : schema.getFields()) {
                    if (!genericRecord.hasField(f.name()) && !f.hasDefaultValue()) {
                        errors.add("Required field " + f.name() + " cannot be found in record");
                        continue;
                    }
                    if (!genericRecord.hasField(f.name())) continue;
                    errors.addAll(AvroUtil.getValidationErrors(f.schema(), genericRecord.get(f.pos()), f.name()));
                }
                break;
            }
            case ENUM: {
                if (schema.hasEnumSymbol(datum.toString())) break;
                errors.add(String.valueOf(datum) + " enum value is not defined in schema");
                break;
            }
            case ARRAY: {
                if (!(datum instanceof Collection)) {
                    errors.add(fieldName[0] + " is not a valid array");
                    break;
                }
                Collection collection = (Collection)datum;
                for (Object element : collection) {
                    errors.addAll(AvroUtil.getValidationErrors(schema.getElementType(), element, new String[0]));
                }
                break;
            }
            case STRING: {
                if (datum instanceof CharSequence) break;
                errors.add(fieldName[0] + " is not a string");
                break;
            }
            case BYTES: {
                if (datum instanceof ByteBuffer) break;
                errors.add(fieldName[0] + " is not bytes");
                break;
            }
            case INT: {
                if (datum instanceof Integer) break;
                errors.add(fieldName[0] + " is not an integer");
                break;
            }
            case LONG: {
                if (datum instanceof Long) break;
                errors.add(fieldName[0] + " is not a long");
                break;
            }
            case FLOAT: {
                if (datum instanceof Float) break;
                errors.add(fieldName[0] + " is not a float");
                break;
            }
            case DOUBLE: {
                if (datum instanceof Double) break;
                errors.add(fieldName[0] + " is not a double");
                break;
            }
            case BOOLEAN: {
                if (datum instanceof Boolean) break;
                errors.add(fieldName[0] + " is not a boolean");
                break;
            }
            case UNION: {
                for (Schema unionSchema : schema.getTypes()) {
                    errors.addAll(AvroUtil.getValidationErrors(unionSchema, datum, new String[0]));
                }
                break;
            }
        }
        return errors;
    }
}

