/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.web;

import io.github.microcks.domain.Header;
import io.github.microcks.domain.OperationsHeaders;
import io.github.microcks.domain.RequestResponsePair;
import io.github.microcks.domain.Secret;
import io.github.microcks.domain.SecretRef;
import io.github.microcks.domain.Service;
import io.github.microcks.domain.TestCaseResult;
import io.github.microcks.domain.TestOptionals;
import io.github.microcks.domain.TestResult;
import io.github.microcks.domain.TestRunnerType;
import io.github.microcks.domain.UnidirectionalEvent;
import io.github.microcks.repository.SecretRepository;
import io.github.microcks.repository.ServiceRepository;
import io.github.microcks.repository.TestResultRepository;
import io.github.microcks.service.MessageService;
import io.github.microcks.service.TestService;
import io.github.microcks.web.dto.HeaderDTO;
import io.github.microcks.web.dto.TestCaseReturnDTO;
import io.github.microcks.web.dto.TestRequestDTO;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class TestController {
    private static Logger log = LoggerFactory.getLogger(TestController.class);
    private final TestResultRepository testResultRepository;
    private final ServiceRepository serviceRepository;
    private final SecretRepository secretRepository;
    private final TestService testService;
    private final MessageService messageService;

    public TestController(TestService testService, MessageService messageService, TestResultRepository testResultRepository, ServiceRepository serviceRepository, SecretRepository secretRepository) {
        this.testService = testService;
        this.messageService = messageService;
        this.testResultRepository = testResultRepository;
        this.serviceRepository = serviceRepository;
        this.secretRepository = secretRepository;
    }

    @GetMapping(value={"/tests/service/{serviceId}"})
    public List<TestResult> listTestsByService(@PathVariable(value="serviceId") String serviceId, @RequestParam(value="page", required=false, defaultValue="0") int page, @RequestParam(value="size", required=false, defaultValue="20") int size) {
        log.debug("Getting tests list for service {}, page {} and size {}", new Object[]{serviceId, page, size});
        return this.testResultRepository.findByServiceId(serviceId, (Pageable)PageRequest.of((int)page, (int)size, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"testNumber"})));
    }

    @GetMapping(value={"/tests/service/{serviceId}/count"})
    public Map<String, Long> countTestsByService(@PathVariable(value="serviceId") String serviceId) {
        log.debug("Counting tests for service...");
        HashMap<String, Long> counter = new HashMap<String, Long>();
        counter.put("counter", this.testResultRepository.countByServiceId(serviceId));
        return counter;
    }

    @PostMapping(value={"/tests"})
    public ResponseEntity<TestResult> createTest(@RequestBody TestRequestDTO test) {
        List<Secret> secrets;
        log.debug("Creating new test for {} on endpoint {}", (Object)test.getServiceId(), (Object)test.getTestEndpoint());
        Service service = null;
        if (test.getServiceId().contains(":")) {
            String name = test.getServiceId().substring(0, test.getServiceId().indexOf(58));
            String version = test.getServiceId().substring(test.getServiceId().indexOf(58) + 1);
            service = this.serviceRepository.findByNameAndVersion(name, version);
        } else {
            service = this.serviceRepository.findById(test.getServiceId()).orElse(null);
        }
        TestRunnerType testRunner = TestRunnerType.valueOf((String)test.getRunnerType());
        OperationsHeaders operationsHeaders = this.buildOperationsHeaders(test.getOperationsHeaders());
        SecretRef secretRef = null;
        if (test.getSecretName() != null && !(secrets = this.secretRepository.findByName(test.getSecretName())).isEmpty()) {
            secretRef = new SecretRef(secrets.get(0).getId(), secrets.get(0).getName());
        }
        TestOptionals testOptionals = new TestOptionals(secretRef, test.getTimeout(), test.getFilteredOperations(), operationsHeaders, test.getOAuth2Context());
        TestResult testResult = this.testService.launchTests(service, test.getTestEndpoint(), testRunner, testOptionals);
        return new ResponseEntity((Object)testResult, (HttpStatusCode)HttpStatus.CREATED);
    }

    @GetMapping(value={"/tests/{id}"})
    public ResponseEntity<TestResult> getTestResult(@PathVariable(value="id") String testResultId) {
        log.debug("Getting TestResult with id {}", (Object)testResultId);
        return new ResponseEntity((Object)this.testResultRepository.findById(testResultId).orElse(null), (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"tests/{id}/messages/{testCaseId}"})
    public List<RequestResponsePair> getMessagesForTestCase(@PathVariable(value="id") String testResultId, @PathVariable(value="testCaseId") String testCaseId) {
        testCaseId = URLDecoder.decode(testCaseId, StandardCharsets.UTF_8);
        testCaseId = testCaseId.replace('!', '/');
        log.debug("Getting messages for testCase {} on test {}", (Object)testCaseId, (Object)testResultId);
        return this.messageService.getRequestResponseByTestCase(testCaseId);
    }

    @GetMapping(value={"tests/{id}/events/{testCaseId}"})
    public List<UnidirectionalEvent> getEventMessagesForTestCase(@PathVariable(value="id") String testResultId, @PathVariable(value="testCaseId") String testCaseId) {
        testCaseId = URLDecoder.decode(testCaseId, StandardCharsets.UTF_8);
        testCaseId = testCaseId.replace('!', '/');
        log.debug("Getting messages for testCase {} on test {}", (Object)testCaseId, (Object)testResultId);
        return this.messageService.getEventByTestCase(testCaseId);
    }

    @PostMapping(value={"tests/{id}/testCaseResult"})
    public ResponseEntity<TestCaseResult> reportTestCaseResult(@PathVariable(value="id") String testResultId, @RequestBody TestCaseReturnDTO testCaseReturn) {
        log.debug("Reporting testCase results on test {}", (Object)testResultId);
        TestCaseResult testCaseResult = this.testService.reportTestCaseResult(testResultId, testCaseReturn.getOperationName(), testCaseReturn.getTestReturns());
        if (testCaseResult != null) {
            return new ResponseEntity((Object)testCaseResult, (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    private OperationsHeaders buildOperationsHeaders(Map<String, List<HeaderDTO>> operationsHeaders) {
        OperationsHeaders result = new OperationsHeaders();
        if (operationsHeaders != null) {
            for (Map.Entry<String, List<HeaderDTO>> operationsHeadersEntry : operationsHeaders.entrySet()) {
                String operationName = operationsHeadersEntry.getKey();
                List<HeaderDTO> operationHeaders = operationsHeadersEntry.getValue();
                HashSet<Header> headers = new HashSet<Header>();
                for (HeaderDTO operationHeadersEntry : operationHeaders) {
                    String[] headerValues = operationHeadersEntry.getValues().split(",");
                    Header header = new Header();
                    header.setName(operationHeadersEntry.getName());
                    header.setValues(new HashSet<String>(Arrays.asList(headerValues)));
                    headers.add(header);
                }
                result.put((Object)operationName, headers);
            }
            return result;
        }
        return null;
    }
}

