/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.test;

import io.github.microcks.domain.Header;
import io.github.microcks.domain.Request;
import io.github.microcks.util.el.EvaluableRequest;
import io.github.microcks.util.el.TemplateEngine;
import io.github.microcks.util.el.TemplateEngineFactory;
import java.util.HashMap;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRunnerCommons {
    private static Logger log = LoggerFactory.getLogger(TestRunnerCommons.class);

    public static String renderRequestContent(Request request, Set<Header> headers) {
        if (request.getContent().contains("{{")) {
            log.debug("Response contains dynamic EL expression, rendering it...");
            TemplateEngine engine = TemplateEngineFactory.getTemplateEngine();
            EvaluableRequest evaluableRequest = new EvaluableRequest(request.getContent(), null);
            HashMap<String, String> evaluableParams = new HashMap<String, String>();
            for (Object parameter : request.getQueryParameters()) {
                evaluableParams.put(parameter.getName(), parameter.getValue());
            }
            evaluableRequest.setParams(evaluableParams);
            HashMap<String, String> evaluableHeaders = new HashMap<String, String>();
            for (Header header : request.getHeaders()) {
                evaluableHeaders.put(header.getName(), String.join((CharSequence)",", header.getValues()));
            }
            evaluableRequest.setHeaders(evaluableHeaders);
            engine.getContext().setVariable("request", (Object)evaluableRequest);
            try {
                return engine.getValue(request.getContent());
            }
            catch (Throwable t) {
                log.error("Failing at evaluating template " + request.getContent(), t);
                return request.getContent();
            }
        }
        return request.getContent();
    }
}

