/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.har;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import graphql.language.Document;
import graphql.language.Field;
import graphql.language.OperationDefinition;
import graphql.parser.Parser;
import io.github.microcks.domain.Exchange;
import io.github.microcks.domain.Header;
import io.github.microcks.domain.Operation;
import io.github.microcks.domain.Parameter;
import io.github.microcks.domain.Request;
import io.github.microcks.domain.RequestResponsePair;
import io.github.microcks.domain.Resource;
import io.github.microcks.domain.Response;
import io.github.microcks.domain.Service;
import io.github.microcks.domain.ServiceType;
import io.github.microcks.util.DispatchCriteriaHelper;
import io.github.microcks.util.MockRepositoryImportException;
import io.github.microcks.util.MockRepositoryImporter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HARImporter
implements MockRepositoryImporter {
    private static Logger log = LoggerFactory.getLogger(HARImporter.class);
    public static final String MICROCKS_ID_STARTER = "microcksId:";
    public static final String API_PREFIX_STARTER = "apiPrefix:";
    protected static final String REQUEST_NODE = "request";
    protected static final String RESPONSE_NODE = "response";
    protected static final String GRAPHQL_VARIABLES_NODE = "variables";
    protected static final String GRAPHQL_QUERY_NODE = "query";
    private ObjectMapper jsonMapper;
    private JsonNode spec;
    private String apiPrefix;
    private Map<Operation, List<JsonNode>> operationToEntriesMap = new HashMap<Operation, List<JsonNode>>();
    private static final List<String> VALID_VERSIONS = List.of("1.1", "1.2");
    private static final List<String> INVALID_ENTRY_EXTENSIONS = List.of(".ico", ".html", ".css", ".js", ".png", ".jpg", ".ttf", ".woff2");
    private static final List<String> UNWANTED_HEADERS = List.of("host", "sec-fetch-dest", "sec-fetch-mode", "sec-fetch-user", "sec-fetch-site", "sec-gpc", "sec-ch-ua", "sec-ch-ua-mobile", "sec-ch-ua-platform", "upgrade-insecure-requests", "user-agent", "date", "vary");

    public HARImporter(String specificationFilePath) throws IOException {
        File specificationFile = new File(specificationFilePath);
        this.jsonMapper = new ObjectMapper();
        this.spec = this.jsonMapper.readTree(specificationFile);
    }

    @Override
    public List<Service> getServiceDefinitions() throws MockRepositoryImportException {
        String[] commentLines;
        ArrayList<Service> results = new ArrayList<Service>();
        String version = this.spec.path("log").path("version").asText();
        if (!VALID_VERSIONS.contains(version)) {
            throw new MockRepositoryImportException("HAR version is not supported. Currently supporting: " + VALID_VERSIONS);
        }
        String comment = this.spec.path("log").path("comment").asText();
        if (comment == null || comment.length() == 0) {
            throw new MockRepositoryImportException("Expecting a comment in HAR log to specify Microcks service identifier");
        }
        Service service = new Service();
        service.setType(ServiceType.REST);
        for (String commentLine : commentLines = comment.split("\\r?\\n|\\r")) {
            if (commentLine.trim().startsWith(MICROCKS_ID_STARTER)) {
                String identifiers = commentLine.trim().substring(MICROCKS_ID_STARTER.length());
                if (identifiers.indexOf(":") != -1) {
                    String[] serviceAndVersion = identifiers.split(":");
                    service.setName(serviceAndVersion[0].trim());
                    service.setVersion(serviceAndVersion[1].trim());
                    continue;
                }
                log.error("microcksId comment is malformed. Expecting 'microcksId: <API_name>:<API_version>'");
                throw new MockRepositoryImportException("microcksId comment is malformed. Expecting 'microcksId: <API_name>:<API_version>'");
            }
            if (!commentLine.trim().startsWith(API_PREFIX_STARTER)) continue;
            this.apiPrefix = commentLine.trim().substring(API_PREFIX_STARTER.length()).trim();
            log.info("Found an API prefix to use for shortening URLs: {}", (Object)this.apiPrefix);
        }
        if (service.getName() == null || service.getVersion() == null) {
            log.error("No microcksId: comment found into GraphQL schema to get API name and version");
            throw new MockRepositoryImportException("No microcksId: comment found into GraphQL schema to get API name and version");
        }
        Map<ServiceType, Integer> requestsCounters = this.countRequestsByServiceType(this.spec.path("log").path("entries").elements());
        if (requestsCounters.get(ServiceType.GRAPHQL) > requestsCounters.get(ServiceType.REST) && requestsCounters.get(ServiceType.GRAPHQL) > requestsCounters.get(ServiceType.SOAP_HTTP)) {
            service.setType(ServiceType.GRAPHQL);
        } else if (requestsCounters.get(ServiceType.SOAP_HTTP) > requestsCounters.get(ServiceType.REST) && requestsCounters.get(ServiceType.SOAP_HTTP) > requestsCounters.get(ServiceType.GRAPHQL)) {
            service.setType(ServiceType.SOAP_HTTP);
        }
        service.setOperations(this.extractOperations(service.getType(), this.spec.path("log").path("entries").elements()));
        results.add(service);
        return results;
    }

    @Override
    public List<Resource> getResourceDefinitions(Service service) throws MockRepositoryImportException {
        return new ArrayList<Resource>();
    }

    @Override
    public List<Exchange> getMessageDefinitions(Service service, Operation operation) throws MockRepositoryImportException {
        HashMap<Request, Response> result = new HashMap<Request, Response>();
        Optional<Operation> opOperation = this.operationToEntriesMap.keySet().stream().filter(op -> op.getName().equals(operation.getName())).filter(op -> op.getMethod().equals(operation.getMethod())).findFirst();
        if (opOperation.isPresent()) {
            DispatchCriteriaHelper.DispatcherDetails details = DispatchCriteriaHelper.extractDispatcherWithRules(operation);
            String rootDispatcher = details.rootDispatcher();
            String rootDispatcherRules = details.rootDispatcherRules();
            List<JsonNode> operationEntries = this.operationToEntriesMap.get(opOperation.get());
            for (JsonNode entry2 : operationEntries) {
                JsonNode requestNode = entry2.path(REQUEST_NODE);
                JsonNode responseNode = entry2.path(RESPONSE_NODE);
                String requestUrl = this.shortenURL(requestNode.path("url").asText());
                log.debug("Extracting message definitions for entry url {}", (Object)requestUrl);
                String name = entry2.path("startedDateTime").asText();
                Request request = this.buildRequest(requestNode, name);
                Object dispatchCriteria = null;
                if ("URI_PARAMS".equals(rootDispatcher)) {
                    dispatchCriteria = DispatchCriteriaHelper.extractFromURIParams(rootDispatcherRules, requestUrl);
                } else if ("URI_PARTS".equals(rootDispatcher)) {
                    if (rootDispatcherRules != null) {
                        dispatchCriteria = DispatchCriteriaHelper.extractFromURIPattern(rootDispatcherRules, HARImporter.removeVerbFromURL(operation.getName()), requestUrl);
                    }
                } else if ("URI_ELEMENTS".equals(rootDispatcher)) {
                    if (rootDispatcherRules != null) {
                        dispatchCriteria = DispatchCriteriaHelper.extractFromURIPattern(rootDispatcherRules, HARImporter.removeVerbFromURL(operation.getName()), requestUrl);
                    }
                    dispatchCriteria = (String)dispatchCriteria + DispatchCriteriaHelper.extractFromURIParams(rootDispatcherRules, requestUrl);
                } else if ("QUERY_ARGS".equals(rootDispatcher)) {
                    dispatchCriteria = this.extractGraphQLCriteria(rootDispatcherRules, request.getContent());
                } else if (requestUrl != null && requestUrl.length() > 0) {
                    operation.addResourcePath(requestUrl);
                    log.debug("Added operation generic resource path: {}", (Object)operation.getResourcePaths());
                }
                if (service.getType() == ServiceType.GRAPHQL) {
                    // empty if block
                }
                Response response = this.buildResponse(responseNode, name, (String)dispatchCriteria);
                result.put(request, response);
            }
        }
        return result.entrySet().stream().map(entry -> new RequestResponsePair((Request)entry.getKey(), (Response)entry.getValue())).collect(Collectors.toList());
    }

    private Map<ServiceType, Integer> countRequestsByServiceType(Iterator<JsonNode> entries) {
        EnumMap<ServiceType, Integer> requestsCounters = new EnumMap<ServiceType, Integer>(ServiceType.class);
        requestsCounters.put(ServiceType.REST, 0);
        requestsCounters.put(ServiceType.GRAPHQL, 0);
        requestsCounters.put(ServiceType.SOAP_HTTP, 0);
        List<JsonNode> candidateEntries = this.filterValidEntries(entries);
        for (JsonNode entry : candidateEntries) {
            JsonNode responseContent = entry.path(RESPONSE_NODE).path("content");
            if (responseContent == null) continue;
            String mimeType = responseContent.path("mimeType").asText();
            String responseText = this.getContentText(responseContent);
            ServiceType responseType = ServiceType.REST;
            if ("application/json".equals(mimeType)) {
                String requestText = entry.path(REQUEST_NODE).path("postData").path("text").asText();
                if (responseText.contains("\"data\":") && (requestText.contains(GRAPHQL_QUERY_NODE) || requestText.contains("mutation") || requestText.contains("fragment"))) {
                    responseType = ServiceType.GRAPHQL;
                }
            } else if ("text/xml".equals(mimeType) && responseText.contains(":Envelope") && responseText.contains(":Body/>")) {
                responseType = ServiceType.SOAP_HTTP;
            }
            requestsCounters.put(responseType, (Integer)requestsCounters.get(responseType) + 1);
        }
        return requestsCounters;
    }

    private List<Operation> extractOperations(ServiceType serviceType, Iterator<JsonNode> entries) {
        HashMap<Object, Operation> discoveredOperations = new HashMap<Object, Operation>();
        List<JsonNode> candidateEntries = this.filterValidEntries(entries);
        for (JsonNode entry : candidateEntries) {
            Operation existingOperation;
            String requestMethod = entry.path(REQUEST_NODE).path("method").asText();
            String requestUrl = entry.path(REQUEST_NODE).path("url").asText();
            String requestText = entry.path(REQUEST_NODE).path("postData").path("text").asText();
            String baseRequestUrl = this.shortenURL(requestUrl);
            String dispatcher = "URI_PARTS";
            if (baseRequestUrl.contains("?")) {
                baseRequestUrl = baseRequestUrl.substring(0, baseRequestUrl.indexOf("?"));
                dispatcher = "URI_PARAMS";
            }
            Object operationName = requestMethod + " " + baseRequestUrl;
            if (serviceType == ServiceType.GRAPHQL) {
                Parser requestParser = new Parser();
                try {
                    Document graphqlRequest = requestParser.parseDocument(this.extractGraphQLQuery(requestText));
                    OperationDefinition graphqlOperation = (OperationDefinition)graphqlRequest.getDefinitions().get(0);
                    requestMethod = graphqlOperation.getOperation().toString();
                    operationName = ((Field)graphqlOperation.getSelectionSet().getSelections().get(0)).getName();
                    if ("QUERY".equals(requestMethod)) {
                        dispatcher = "QUERY_ARGS";
                    }
                }
                catch (Exception e) {
                    log.warn("Error parsing GraphQL request: {}", (Object)e.getMessage());
                }
            }
            if ((existingOperation = (Operation)discoveredOperations.get(operationName)) == null) {
                String[] newCandidatePaths = ((String)operationName).split("/");
                String searchedMethod = requestMethod;
                List<Operation> similarOperations = discoveredOperations.values().stream().filter(op -> searchedMethod.equals(op.getMethod())).filter(op -> newCandidatePaths.length == op.getName().split("/").length).toList();
                Operation mostSimilarOperation = this.findMostSimilarOperation((String)operationName, similarOperations);
                if (mostSimilarOperation != null) {
                    List<String> uris = List.of(HARImporter.removeVerbFromURL(mostSimilarOperation.getName()), HARImporter.removeVerbFromURL((String)operationName));
                    String urlPart = DispatchCriteriaHelper.buildTemplateURLWithPartsFromURIs(uris);
                    mostSimilarOperation.setName(requestMethod + " " + urlPart);
                    if ("URI_PARAMS".equals(mostSimilarOperation.getDispatcher())) {
                        mostSimilarOperation.setDispatcher("URI_ELEMENTS");
                    } else {
                        mostSimilarOperation.setDispatcher("URI_PARTS");
                        mostSimilarOperation.setDispatcherRules(DispatchCriteriaHelper.extractPartsFromURIs(uris));
                        mostSimilarOperation.addResourcePath(uris.get(0));
                        mostSimilarOperation.addResourcePath(uris.get(1));
                    }
                    this.operationToEntriesMap.get(mostSimilarOperation).add(entry);
                    continue;
                }
                Operation operation = new Operation();
                operation.setName((String)operationName);
                operation.setMethod(requestMethod);
                operation.setDispatcher(dispatcher);
                if ("URI_PARAMS".equals(dispatcher)) {
                    operation.setDispatcherRules(DispatchCriteriaHelper.extractParamsFromURI(requestUrl));
                } else if ("URI_PARTS".equals(dispatcher)) {
                    operation.addResourcePath(baseRequestUrl);
                }
                discoveredOperations.put(operationName, operation);
                ArrayList<JsonNode> operationEntries = new ArrayList<JsonNode>();
                operationEntries.add(entry);
                this.operationToEntriesMap.put(operation, operationEntries);
                continue;
            }
            this.operationToEntriesMap.get(existingOperation).add(entry);
        }
        return discoveredOperations.values().stream().toList();
    }

    private List<JsonNode> filterValidEntries(Iterator<JsonNode> entries) {
        return Stream.generate(() -> null).takeWhile(x -> entries.hasNext()).map(next -> (JsonNode)entries.next()).filter(entry -> {
            String url = entry.path(REQUEST_NODE).path("url").asText();
            String extension = url.substring(url.lastIndexOf("."));
            return !INVALID_ENTRY_EXTENSIONS.contains(extension);
        }).filter(entry -> {
            if (this.apiPrefix != null) {
                String url = entry.path(REQUEST_NODE).path("url").asText();
                return url.startsWith(this.apiPrefix) || HARImporter.removeProtocolAndHostPort(url).startsWith(this.apiPrefix);
            }
            return true;
        }).toList();
    }

    private Operation findMostSimilarOperation(String operationName, List<Operation> similarOperations) {
        Operation mostSimilarOperation = null;
        if (!similarOperations.isEmpty()) {
            int maxScore = 0;
            for (Operation similarOperation : similarOperations) {
                int score = this.getSimilarityScore(similarOperation.getName(), operationName);
                if (score <= 70 || score <= maxScore) continue;
                maxScore = score;
                mostSimilarOperation = similarOperation;
            }
        }
        return mostSimilarOperation;
    }

    private int getSimilarityScore(String base, String candidate) {
        int similarityScore = 0;
        int commonPrefixSize = 0;
        String[] basePaths = base.split("/");
        String[] candidatePaths = candidate.split("/");
        int stepScore = 100 / basePaths.length;
        boolean stillCommon = true;
        for (int i = 0; i < basePaths.length; ++i) {
            String basePath = basePaths[i];
            String candidatePath = candidatePaths[i];
            if (basePath.equals(candidatePath)) {
                if (stillCommon) {
                    ++commonPrefixSize;
                }
                similarityScore += stepScore;
                continue;
            }
            stillCommon = false;
        }
        return similarityScore + basePaths.length * commonPrefixSize;
    }

    private Request buildRequest(JsonNode requestNode, String name) {
        Request request = new Request();
        request.setName(name);
        request.setHeaders(this.buildHeaders(requestNode.path("headers")));
        request.setContent(requestNode.path("postData").path("text").asText());
        JsonNode queryStringNode = requestNode.path("queryString");
        if (!queryStringNode.isMissingNode() && queryStringNode.isArray()) {
            Iterator queryStrings = queryStringNode.elements();
            while (queryStrings.hasNext()) {
                JsonNode queryString = (JsonNode)queryStrings.next();
                Parameter param = new Parameter();
                param.setName(queryString.path("name").asText());
                param.setValue(queryString.path("value").asText());
                request.addQueryParameter(param);
            }
        }
        return request;
    }

    private Response buildResponse(JsonNode responseNode, String name, String dispatchCriteria) {
        Response response = new Response();
        response.setName(name);
        response.setStatus(responseNode.path("status").asText("200"));
        response.setHeaders(this.buildHeaders(responseNode.path("headers")));
        response.setContent(this.getContentText(responseNode.path("content")));
        response.setDispatchCriteria(dispatchCriteria);
        if (response.getHeaders() != null) {
            for (Header header : response.getHeaders()) {
                if (!header.getName().equalsIgnoreCase("Content-Type")) continue;
                response.setMediaType(header.getValues().toArray(new String[0])[0]);
            }
        }
        return response;
    }

    private Set<Header> buildHeaders(JsonNode headerNode) {
        HashMap<String, Header> headers = new HashMap<String, Header>();
        Iterator items = headerNode.elements();
        while (items.hasNext()) {
            JsonNode item = (JsonNode)items.next();
            String name = item.path("name").asText();
            if (UNWANTED_HEADERS.contains(name.toLowerCase())) continue;
            Header header = headers.computeIfAbsent(name, k -> {
                Header h = new Header();
                h.setName(k);
                h.setValues(new HashSet());
                return h;
            });
            header.getValues().add(item.path("value").asText());
        }
        return headers.values().stream().collect(Collectors.toSet());
    }

    private String getContentText(JsonNode contentNode) {
        String text = contentNode.path("text").asText();
        if ("base64".equals(contentNode.path("encoding").asText())) {
            text = new String(Base64.getDecoder().decode(text));
        }
        return text;
    }

    private String shortenURL(String url) {
        if (this.apiPrefix != null) {
            if (this.apiPrefix.startsWith("http://") || this.apiPrefix.startsWith("https://")) {
                return url.substring(this.apiPrefix.length() + 1);
            }
            url = HARImporter.removeProtocolAndHostPort(url);
            return HARImporter.removeApiPrefix(url, this.apiPrefix);
        }
        return HARImporter.removeProtocolAndHostPort(url);
    }

    private String extractGraphQLQuery(String requestContent) {
        try {
            JsonNode requestNode = this.jsonMapper.readTree(requestContent);
            return requestNode.path(GRAPHQL_QUERY_NODE).asText();
        }
        catch (Exception e) {
            log.error("Exception while extracting dispatch criteria from GraphQL variables: {}", (Object)e.getMessage(), (Object)e);
            return "";
        }
    }

    private String extractGraphQLCriteria(String dispatcherRules, String requestContent) {
        String dispatchCriteria = "";
        try {
            JsonNode requestNode = this.jsonMapper.readTree(requestContent);
            if (requestNode.has(GRAPHQL_VARIABLES_NODE)) {
                JsonNode variablesNode = requestNode.path(GRAPHQL_VARIABLES_NODE);
                Map paramsMap = (Map)this.jsonMapper.convertValue((Object)variablesNode, (JavaType)TypeFactory.defaultInstance().constructMapType(TreeMap.class, String.class, String.class));
                dispatchCriteria = DispatchCriteriaHelper.extractFromParamMap(dispatcherRules, paramsMap);
            }
        }
        catch (Exception e) {
            log.error("Exception while extracting dispatch criteria from GraphQL variables: {}", (Object)e.getMessage(), (Object)e);
        }
        return dispatchCriteria;
    }

    private static String removeApiPrefix(String url, String apiPrefix) {
        if (url.startsWith(apiPrefix)) {
            return url.substring(apiPrefix.length());
        }
        return url;
    }

    private static String removeVerbFromURL(String operationName) {
        return operationName.substring(operationName.indexOf(" ") + 1);
    }

    private static String removeProtocolAndHostPort(String url) {
        if (url.startsWith("https://")) {
            url = url.substring(8);
        }
        if (url.startsWith("http://")) {
            url = url.substring(7);
        }
        if (url.indexOf(47) != -1) {
            url = url.substring(url.indexOf(47));
        }
        return url;
    }
}

