/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.web;

import io.github.microcks.domain.Secret;
import io.github.microcks.repository.SecretRepository;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class SecretController {
    private static Logger log = LoggerFactory.getLogger(SecretController.class);
    @Autowired
    private SecretRepository secretRepository;

    @GetMapping(value={"/secrets"})
    public List<Secret> listSecrets(@RequestParam(value="page", required=false, defaultValue="0") int page, @RequestParam(value="size", required=false, defaultValue="20") int size) {
        log.debug("Getting secrets list for page {} and size {}", (Object)page, (Object)size);
        return this.secretRepository.findAll((Pageable)PageRequest.of((int)page, (int)size, (Sort)Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"name"}))).getContent();
    }

    @GetMapping(value={"/secrets/search"})
    public List<Secret> searchSecrets(@RequestParam(value="name") String name) {
        log.debug("Searching secrets corresponding to {}", (Object)name);
        return this.secretRepository.findByNameLike(name);
    }

    @GetMapping(value={"/secrets/count"})
    public Map<String, Long> countSecrets() {
        log.debug("Counting secrets...");
        HashMap<String, Long> counter = new HashMap<String, Long>();
        counter.put("counter", this.secretRepository.count());
        return counter;
    }

    @PostMapping(value={"/secrets"})
    public ResponseEntity<Secret> createSecret(@RequestBody Secret secret) {
        log.debug("Creating new secret: {}", (Object)secret);
        return new ResponseEntity((Object)((Secret)this.secretRepository.save(secret)), (HttpStatusCode)HttpStatus.CREATED);
    }

    @PutMapping(value={"/secrets/{id}"})
    public ResponseEntity<Secret> saveSecret(@RequestBody Secret secret) {
        log.debug("Saving existing secret: {}", (Object)secret);
        return new ResponseEntity((Object)((Secret)this.secretRepository.save(secret)), (HttpStatusCode)HttpStatus.OK);
    }

    @DeleteMapping(value={"/secrets/{id}"})
    public ResponseEntity<String> deleteService(@PathVariable(value="id") String secretId) {
        log.debug("Removing secret with id {}", (Object)secretId);
        this.secretRepository.deleteById(secretId);
        return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
    }
}

