/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.web;

import io.github.microcks.domain.Exchange;
import io.github.microcks.domain.Operation;
import io.github.microcks.domain.Resource;
import io.github.microcks.domain.ResourceType;
import io.github.microcks.domain.Service;
import io.github.microcks.domain.ServiceType;
import io.github.microcks.repository.ResourceRepository;
import io.github.microcks.repository.ServiceRepository;
import io.github.microcks.security.UserInfo;
import io.github.microcks.service.ServiceService;
import io.github.microcks.util.ai.AICopilot;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/copilot"})
public class AICopilotController {
    private static Logger log = LoggerFactory.getLogger(AICopilotController.class);
    @Autowired(required=false)
    private AICopilot copilot;
    @Autowired
    private ServiceRepository serviceRepository;
    @Autowired
    private ResourceRepository resourceRepository;
    @Autowired
    private ServiceService serviceService;

    @RequestMapping(value={"/samples/{id:.+}"}, method={RequestMethod.GET})
    public ResponseEntity<?> getSamplesSuggestions(@PathVariable(value="id") String serviceId, @RequestParam(value="operation") String operationName) {
        log.debug("Retrieving service with id {}", (Object)serviceId);
        Service service = null;
        if (serviceId.contains(":")) {
            String name = serviceId.substring(0, serviceId.indexOf(58));
            String version = serviceId.substring(serviceId.indexOf(58) + 1);
            if (name.contains("+")) {
                name = name.replace('+', ' ');
            }
            service = this.serviceRepository.findByNameAndVersion(name, version);
        } else {
            service = this.serviceRepository.findById(serviceId).orElse(null);
        }
        if (service != null) {
            log.debug("We found service, now looking for required contract...");
            List<Resource> resources = null;
            if (service.getType() == ServiceType.REST) {
                resources = this.resourceRepository.findByServiceIdAndType(service.getId(), ResourceType.OPEN_API_SPEC);
            } else if (service.getType() == ServiceType.GRAPHQL) {
                resources = this.resourceRepository.findByServiceIdAndType(service.getId(), ResourceType.GRAPHQL_SCHEMA);
            } else if (service.getType() == ServiceType.EVENT) {
                resources = this.resourceRepository.findByServiceIdAndType(service.getId(), ResourceType.ASYNC_API_SPEC);
            }
            Optional<Operation> operation = service.getOperations().stream().filter(op -> operationName.equals(op.getName())).findFirst();
            if (!resources.isEmpty() && !operation.isEmpty()) {
                try {
                    List<? extends Exchange> exchanges = this.copilot.suggestSampleExchanges(service, operation.get(), resources.get(0), 2);
                    return new ResponseEntity(exchanges, (HttpStatusCode)HttpStatus.OK);
                }
                catch (Exception e) {
                    log.error("Caught and exception while generating samples", (Throwable)e);
                    return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        }
        log.error("At least one mandatory parameters (serviceId, operationName or contract) is missing");
        return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @RequestMapping(value={"/samples/{id:.+}"}, method={RequestMethod.POST})
    public ResponseEntity<?> addSamplesSuggestions(@PathVariable(value="id") String serviceId, @RequestParam(value="operation") String operationName, @RequestBody List<Exchange> exchanges, UserInfo userInfo) {
        log.debug("Adding new AI samples to service {} and operation {}", (Object)serviceId, (Object)operationName);
        boolean result = this.serviceService.addExchangesToServiceOperation(serviceId, operationName, exchanges, userInfo);
        if (result) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.CREATED);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.FORBIDDEN);
    }
}

